#include-once

#Region Includes

#include <Array.au3>
#include <String.au3>
#include <WinHTTP.au3>
#include <ZLIB.au3>

#EndRegion Includes

#Region Global Variables

Global $sHeader, $sUploadKey, $sCookie, $sAuthenticityToken, $sTokenId, $sTokenSecret
Global $sBoundary = '--' & _GenerateBoundary(30)

;[N][0] = Images Hosting - the host name before ".com" is used to call upload func name:
;			Call('_Host' & StringRegExpReplace($aSupported_Hosts[N][0], '\.[^\.]+$', '') & 'Upload', $sImagePath)
;[N][1] = API key/ID
Global $aSupported_Hosts[6][2] = _
		[ _
		['imgur.com', 'f77d0b8cd41eb62792be0bf303e649df'], _
		['tinypic.com', 'e2aabb8d555322fa'], _
		['bayimg.com', ''], _
		['abload.de', ''], _
		['postimage.org', ''], _
		['imagebam.com', ''] _
		]

Global Enum $iHost_imgur, $iHost_tinypic, $iHost_bayimg, $iHost_abload, $iHost_postimage, $iHost_imagebam

Global $sUserAgent = 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; WOW64; Trident/4.0; SLCC2; .NET CLR 2.0.50727; .NET CLR 3.5.30729; .NET CLR 3.0.30729; Media Center PC 6.0; .NET4.0C; .NET4.0E)'
Global $hUpldPrgrs_Callback_Func = ''

#EndRegion Global Variables

Func _FileGetType($sFilePath)
	If Not FileExists($sFilePath) Then Return SetError(-1)
	If FileGetSize($sFilePath) = 0 Then Return SetError(2, 0, 0)
	Local $sExt = StringUpper(_GetExtByFullPath($sFilePath))
	Local $hFile, $Binary
	$hFile = FileOpen($sFilePath, 16)
	If $hFile = -1 Then Return SetError(3, 0, 0)
	$Binary = FileRead($hFile)
	FileClose($hFile)
	Local $sString = StringTrimLeft($Binary, 2)
	Local $sStringLeft = StringReplace(StringTrimLeft(StringLeft($Binary, 14), 2), '00', '') ; get 7 bit header part.
	Local $sStringLeft12 = StringLeft($sStringLeft, 12)
	Local $sStringLeft8 = StringLeft($sStringLeft, 8)
	Local $sStringLeft6 = StringLeft($sStringLeft, 6)
	Local $sStringLeft4 = StringLeft($sStringLeft, 4)
	Local $aOut[2], $aMOPwppSubHeader[5] = [5, '006E1EF0', '0F00E803', 'A0461DF0', 'FDFFFFFF'] ; 60211BF0 403D1AF0 807A1FF0
	Local $SubHeader, $iIndex
	Select
		#Region ------ Picture Filetype ------------------------------
		Case $sStringLeft12 = '474946383961' ; GIF 89A Bitmap            GIF Graphics interchange format file
			$aOut[0] = 'GIF 89A Bitmap'
			$aOut[1] = 'GIF'
		Case $sStringLeft12 = '474946383761' ; GIF 87A Bitmap            GIF Graphics interchange format file
			$aOut[0] = 'GIF 87A Bitmap'
			$aOut[1] = 'GIF'
		Case $sStringLeft8 = 'FFD8FFE0' ; JFIF, JPE, JPEG, JPG      JPEG/JFIF graphics file
			$aOut[0] = 'JPEG/JFIF graphics file'
			$aOut[1] = 'JPG'
		Case $sStringLeft8 = 'FFD8FFE1' ; JPG                       Standard JPEG/Exif
			$aOut[0] = 'Standard JPEG/Exif'
			$aOut[1] = 'JPG'
		Case $sStringLeft8 = 'FFD8FFE2' ; JPG                       Canon EOS 1D JPEG file
			$aOut[0] = 'Canon EOS 1D JPEG file'
			$aOut[1] = 'JPG'
		Case $sStringLeft8 = 'FFD8FFE3' ; JPG                       Samsung D500 JPEG file
			$aOut[0] = 'Samsung D500 JPEG file'
			$aOut[1] = 'JPG'
		Case $sStringLeft8 = 'FFD8FFE8' ; JPG                       Still Picture Interchange File Format (SPIFF)
			$aOut[0] = 'Still Picture Interchange File Format (SPIFF)'
			$aOut[1] = 'JPG'
		Case $sStringLeft8 = 'FFD8FFDB' ; JPG                       Samsung D807 JPEG file
			$aOut[0] = 'Samsung D807 JPEG file'
			$aOut[1] = 'JPG'
		Case $sStringLeft4 = 'FFD8' ; JPG
			$aOut[0] = 'JPEG file'
			$aOut[1] = 'JPG'
		Case $sStringLeft4 = '424D' ; BMP, DIB                 Windows (or device-independent) bitmap image
			$aOut[0] = 'Windows Bitmap BMP'
			$aOut[1] = 'BMP'
		Case $sStringLeft8 = '89504E47' ; PNG
			$aOut[0] = 'Portable Network Graphics  PNG'
			$aOut[1] = 'PNG'
		Case $sStringLeft6 = '492049' ; TIF, TIFF                   Tagged Image File Format file
			$aOut[0] = 'Tagged Image File Format file'
			$aOut[1] = 'TIFF'
		Case $sStringLeft8 = '49492A00' ; TIF, TIFF                   Tagged Image File Format file (little endian, i.e., LSB first in the byte; Intel)
			$aOut[0] = 'Tagged Image File Format file little endian'
			$aOut[1] = 'TIFF'
		Case $sStringLeft6 = '4D4D2A' ; TIF, TIFF                   Tagged Image File Format file (big endian, i.e., LSB last in the byte; Motorola)
			$aOut[0] = 'Tagged Image File Format file big endian'
			$aOut[1] = 'TIFF'
		Case $sStringLeft6 = '4D4D2B' ; TIF, TIFF                   BigTIFF files; Tagged Image File Format files >4 GB
			$aOut[0] = 'BigTIFF files'
			$aOut[1] = 'TIFF'
			#EndRegion --- Picture Filetype ------------------------------
			
			#Region ------ Document Filetype ------------------------------
		Case $sStringLeft8 = '25504446' ; PDF, FDF                    Adobe Portable Document Format and Forms Document file
			$aOut[0] = 'Adobe Portable Document Format'
			$aOut[1] = 'PDF'
		Case $sStringLeft8 = 'D0CF11E0'
			$SubHeader = StringMid($sString, 1025, 8) ; offset 512
			If $SubHeader = 'ECA5C100' Then
				$aOut[0] = 'Microsoft Word document'
				$aOut[1] = 'DOC'
			Else
				$iIndex = _ArraySearch($aMOPwppSubHeader, $SubHeader, 1, 0, 0, 0)
				If $iIndex > 0 Or StringInStr($sString, StringTrimLeft(Binary('PowerPoint'), 2)) Then
					$aOut[0] = 'Microsoft PowerPoint document'
					If $sExt = 'PPS' Then
						$aOut[1] = 'PPS'
					Else
						$aOut[1] = 'PPT'
					EndIf
				EndIf
			EndIf
		Case $sStringLeft8 = '504B0304' ; odp, odt, docx, pptx, ppsx et zip  504B0304
			If StringInStr($sString, StringTrimLeft(Binary('opendocument.presentationPK'), 2)) Then
				$aOut[0] = 'OpenDocument Presentation'
				$aOut[1] = 'ODP'
				ContinueCase
			EndIf
			If StringInStr($sString, StringTrimLeft(Binary('opendocument.textPK'), 2)) Then
				$aOut[0] = 'OpenDocument Text document'
				$aOut[1] = 'ODT'
				ContinueCase
			EndIf
			If StringInStr($sString, StringTrimLeft(Binary('word/_rels/document.xml.rels'), 2)) Then
				$aOut[0] = 'Word Microsoft Office Open XML Format document'
				$aOut[1] = 'DOCX'
				ContinueCase
			EndIf
			If StringInStr($sString, StringTrimLeft(Binary('ppt/_rels/presentation.xml.rel'), 2)) Then
				$aOut[0] = 'PowerPoint Microsoft Office Open XML Format document'
				If $sExt = 'PPSX' Then
					$aOut[1] = 'PPSX'
				Else
					$aOut[1] = 'PPTX'
				EndIf
				ContinueCase
			EndIf
			#EndRegion --- Document Filetype ------------------------------
	EndSelect
	If $aOut[1] = 'GIF' Then
		StringReplace($sString, '0021F904', '0021F904')
		If @extended > 1 Then $aOut[0] = 'Animated ' & $aOut[0]
	EndIf
	Return $aOut
EndFunc ;==> _FileGetType ()

Func _PicReadData($sPicPath)
	If Not FileExists($sPicPath) Then Return SetError(-1)
	Local $hFile = FileOpen($sPicPath)
	If $hFile = -1 Then Return SetError(1)
	Local $sData = FileRead($hFile)
	If @error Then Return SetError(2)
	FileClose($hFile)
	Return $sData
EndFunc ;==> _PicReadData ()

Func _PicGetContentType($sPicPath)
	If Not FileExists($sPicPath) Then Return SetError(-1)
	Local $sExt = _GetExtByFullPath($sPicPath)
	If @error Or $sExt = '' Then Return SetError(1)
	Local $sContentType
	Switch $sExt
		Case 'jpg', 'jpe', 'jpeg'
			$sContentType = 'Content-Type: image/jpeg' ; ie 'Content-Type: image/pjpeg'
		Case 'gif'
			$sContentType = 'Content-Type: image/gif'
		Case 'bmp'
			$sContentType = 'Content-Type: image/bmp'
		Case 'png'
			$sContentType = 'Content-Type: image/png' ; ie Content-Type: image/x-png
		Case 'tif', 'tiff'
			$sContentType = 'Content-Type: image/tiff'
		Case Else
			Return SetError(2)
	EndSwitch
	Return $sContentType
EndFunc ;==> _PicGetContentType ()

Func _PicUploadProgress($hRequest, $sPicPath, $sDataToSend)
	If Not FileExists($sPicPath) Then Return SetError(-1)
	Local $sDatas = StringToBinary($sDataToSend)
	Local $iNumberOfBytesToSend = 2048 ; 1024; 2048; 8192
	Local $Bin, $iPercent, $iStart = 1, $iExtended = 0
	While 1
		$Bin = BinaryMid($sDatas, $iStart, $iNumberOfBytesToSend)
		If BinaryLen($Bin) = 0 Then Return
		_WinHTTPWriteData($hRequest, $Bin, 1)
		If Not @error Then
			$iExtended += @extended
			$iPercent = Round(($iExtended) / (StringLen($sDataToSend)) * 100, 2)
			If $iPercent > 100 Then $iPercent = 100
			
			If IsFunc($hUpldPrgrs_Callback_Func) Then
				$hUpldPrgrs_Callback_Func($iPercent)
			EndIf
			
			$iStart += $iNumberOfBytesToSend
		Else
			$Bin = 0
			Return SetError(1)
		EndIf
	WEnd
EndFunc

Func _GenerateBoundary($iLen)
	Local $sString = ''
	Do
		Switch Random(1, 3, 1)
			Case 1
				$sString &= Chr(Random(48, 57, 1)) ; 0 to 9
			Case 2
				$sString &= Chr(Random(65, 90, 1)) ; A to Z
			Case 3
				$sString &= Chr(Random(97, 122, 1)) ; a to z
		EndSwitch
	Until StringLen($sString) = $iLen
	Return $sString
EndFunc ;==> _GenerateBoundary ()

Func _GenerateRandomName($sDir)
	Local $sTempName, $sTempPath
	Do
		$sTempName = '~'
		While StringLen($sTempName) < 8
			$sTempName = $sTempName & Chr(Round(Random(97, 122), 0))
		WEnd
		$sTempPath = $sDir & '\' & $sTempName
	Until Not FileExists($sTempPath)
	Return $sTempName
EndFunc ;==> _GenerateRandomName ()

Func _GetExtByFullPath($sFullPath)
	Local $aFileName = StringSplit($sFullPath, '.')
	If Not @error Then Return $aFileName[$aFileName[0]]
	Return SetError(1)
EndFunc ;==> _GetExtByFullPath ()

Func _GetFullNameByFullPath($sFullPath)
	Local $aFileName = StringSplit($sFullPath, '\')
	If Not @error Then Return $aFileName[$aFileName[0]]
	Return SetError(1)
EndFunc ;==> _GetFullNameByFullPath ()

Func _GetNameByFullPath($sFullPath)
	Local $aFileName = StringSplit($sFullPath, '\')
	If Not @error Then Return StringLeft($aFileName[$aFileName[0]], StringInStr($aFileName[$aFileName[0]], '.', 0, -1) - 1)
EndFunc ;==> _GetNameByFullPath ()

Func _HostAbloadExtractLinks($HtmlData)
	Local $sUrl
	Local $aLinks = StringRegExp($HtmlData, '(?s)(?i)value="(.*?)"', 3)
	If Not @error Then
		_ArrayDelete($aLinks, 0)
		_ArrayDelete($aLinks, 0)
		$sUrl = _StringBetween($aLinks[1], '[img]', '[/img]')
		If Not @error Then
			$aLinks[1] = $sUrl[0]
			_ArrayDelete($aLinks, 3)
			ReDim $aLinks[4]
			If $aLinks[UBound($aLinks) - 1] <> '' Then
				Return $aLinks
			Else
				Return SetError(3)
			EndIf
		Else
			Return SetError(2)
		EndIf
	Else
		Return SetError(1)
	EndIf
EndFunc ;==> _HostAbloadExtractLinks ()

Func _HostAbloadSetDataToSend($sPicPath)
	If Not FileExists($sPicPath) Then Return SetError(-1)
	Local $sData = _PicReadData($sPicPath)
	If @error Then Return SetError(1)
	Local $sImageName = _GetFullNameByFullPath($sPicPath)
	If @error Or $sImageName = '' Then Return SetError(2)
	Local $sContentType = _PicGetContentType($sPicPath)
	If @error Then Return SetError(3)
	Return SetError(0, '', $sBoundary & @CRLF & _
			'Content-Disposition: form-data; name="img0"; filename="' & $sImageName & '"' & @CRLF & $sContentType & @CRLF & @CRLF & $sData & @CRLF & $sBoundary & @CRLF & _
			'Content-Disposition: form-data; name="resize"' & @CRLF & @CRLF & 'none' & @CRLF & $sBoundary & @CRLF & _
			'Content-Disposition: form-data; name="delete"' & @CRLF & @CRLF & 'never' & @CRLF & $sBoundary & '--')
EndFunc ;==> _HostAbloadSetDataToSend ()

Func _HostAbloadUpload($sPicPath)
	Local $hOpen, $hConnect, $hRequest, $sHost, $sDataToSend, $sReceivedData, $iError, $sResponse, $sPostData, $sContentType, $aName, $aValue, $aData
	$sHost = 'abload.de'
	$hOpen = _WinHttpOpen($sUserAgent)
	If @error Then
		SetError(1)
	Else
		$hConnect = _WinHttpConnect($hOpen, $sHost)
		If @error Then
			SetError(2)
		Else
			$hRequest = _WinHttpOpenRequest($hConnect, 'POST', '/upload.php', 'HTTP/1.1')
			If @error Then
				SetError(3)
			Else
				_WinHttpSetTimeouts($hRequest, 10000, 60000, 90000, 90000)
				$sDataToSend = _HostAbloadSetDataToSend($sPicPath)
				_WinHttpAddRequestHeaders($hRequest, 'Accept:application/x-ms-application, image/jpeg, application/xaml+xml, image/gif, image/pjpeg, application/x-ms-xbap, application/x-silverlight, */*')
				_WinHttpAddRequestHeaders($hRequest, 'Referer: http://abload.de/')
				_WinHttpAddRequestHeaders($hRequest, 'Accept-Encoding:gzip, deflate')
				_WinHttpAddRequestHeaders($hRequest, 'Connection:Keep-Alive')
				_WinHttpAddRequestHeaders($hRequest, 'Cache-Control:no-cache')
				$sContentType = 'Content-Type: multipart/form-data; boundary=' & StringTrimLeft($sBoundary, 2)
				_WinHttpSendRequest($hRequest, $sContentType, $WINHTTP_NO_REQUEST_DATA, StringLen($sDataToSend))
				If @error Then
					SetError(4)
				Else
					_PicUploadProgress($hRequest, $sPicPath, $sDataToSend)
					If Not @error Then
						$hTimerInit = TimerInit()
						_WinHttpReceiveResponse($hRequest)
						If @error Then
							SetError(5)
						Else
							If _WinHttpQueryDataAvailable($hRequest) Then
								$sReceivedData = ''
								While 1
									$sReceivedData &= _WinHttpReadData($hRequest)
									If Not @extended Then ExitLoop ;~
								WEnd
								If StringInStr($sReceivedData, 'error') Then SetError(6)
								$aName = _StringBetween($sReceivedData, 'name="', '"')
								If Not @error Then
									$aValue = _StringBetween($sReceivedData, 'value="', '"')
									If Not @error Then
										$aData = _StringBetween($sReceivedData, 'display:none;">', '</textarea><noscript>')
										If Not @error Then $sResponse = $aName[0] & '=' & $aValue[0] & '&' & $aName[1] & '=' & $aValue[1] & '&' & $aName[2] & '=' & StringReplace($aData[0], '&quot;', '"')
									EndIf
								EndIf
								$sPostData = Execute("'" & StringRegExpReplace($sResponse, "([<>{}""':?#\[\]!$(),;%])", "%' & hex(asc('\1'),2) & '") & "'")
								If $hRequest Then _WinHttpCloseHandle($hRequest)
								If $hConnect Then _WinHttpCloseHandle($hConnect)
								If $hOpen Then _WinHttpCloseHandle($hOpen)
								$sHost = 'www.abload.de'
								$hOpen = _WinHttpOpen($sUserAgent)
								$hConnect = _WinHttpConnect($hOpen, $sHost)
								$hRequest = _WinHttpOpenRequest($hConnect, 'POST', '/uploadComplete.php', 'HTTP/1.1')
								_WinHttpSetTimeouts($hRequest, 10000, 60000, 90000, 90000)
								_WinHttpAddRequestHeaders($hRequest, 'Accept: application/x-ms-application, image/jpeg, application/xaml+xml, image/gif, image/pjpeg, application/x-ms-xbap, application/x-silverlight, */*')
								_WinHttpAddRequestHeaders($hRequest, 'http://abload.de/upload.php')
								_WinHttpAddRequestHeaders($hRequest, 'Accept-Encoding:gzip, deflate')
								_WinHttpAddRequestHeaders($hRequest, 'Content-Type: application/x-www-form-urlencoded')
								_WinHttpAddRequestHeaders($hRequest, 'Content-Length: ' & StringLen($sPostData))
								_WinHttpAddRequestHeaders($hRequest, 'Connection:Keep-Alive')
								_WinHttpAddRequestHeaders($hRequest, 'Cache-Control:no-cache')
								_WinHttpSendRequest($hRequest, $WINHTTP_NO_ADDITIONAL_HEADERS, $sPostData)
								_WinHttpReceiveResponse($hRequest)
								If _WinHttpQueryDataAvailable($hRequest) Then
									$sReceivedData = ''
									While 1
										$sReceivedData &= _WinHttpReadData($hRequest)
										If Not @extended Then
											SetError(0)
											ExitLoop
										EndIf
									WEnd
								EndIf
							Else
								SetError(7)
							EndIf
						EndIf
					Else
						SetError(8)
					EndIf
				EndIf
			EndIf
		EndIf
	EndIf
	$iError = @error
	If $hRequest Then _WinHttpCloseHandle($hRequest)
	If $hConnect Then _WinHttpCloseHandle($hConnect)
	If $hOpen Then _WinHttpCloseHandle($hOpen)
	Return SetError($iError, 0, $sReceivedData)
EndFunc ;==> _HostAbloadUpload ()

Func _HostBayImgExtractLinks($HtmlData)
;~  Return Links Array
;~  [0] direct link
;~  [1] Thumb link
;~  [2] in BayImg viewer link
;~  [3]
;~  [4] REMOVAL CODE
	$HtmlData = StringMid($HtmlData, StringInStr($HtmlData, '<div id="extra2">', 0, 1))
	Local $aLinks[5], $aRet
	$aRet = StringRegExp($HtmlData, '(?s)(?i)src="//(.*?)" class=', 3)
	If Not @error Then
		$aRet[0] = 'http://' & $aRet[0]
		$aLinks[0] = StringReplace($aRet[0], 'http://thumbs', 'http://image') ; direct link
		$aLinks[1] = $aRet[0] ; Thumb link
	Else
		Return SetError(1)
	EndIf
	$aRet = StringRegExp($HtmlData, '(?s)(?i)<a href="(.*?)"><img', 3) ; in BayImg viewer link
	If Not @error Then
		$aLinks[2] = 'http://' & $aRet[0]
	Else
		Return SetError(2)
	EndIf
	If $aLinks[UBound($aLinks) - 3] <> '' Then
		$aLinks[4] = 'Use Hot Link 1 + REMOVAL CODE = 123456789'
		Return $aLinks
	Else
		Return SetError(3)
	EndIf
EndFunc ;==> _HostBayImgExtractLinks ()

Func _HostBayImgSetDataToSend($sPicPath)
	Local $sData = _PicReadData($sPicPath)
	If @error Then Return SetError(1)
	Local $sImageName = _GetFullNameByFullPath($sPicPath)
	If @error Or $sImageName = '' Then Return SetError(2)
	Local $sContentType = _PicGetContentType($sPicPath)
	If @error Then Return SetError(3)
	Local $sCdfdn = 'Content-Disposition: form-data; name'
	Return SetError(0, '', $sBoundary & @CRLF & _
			$sCdfdn & '="file"; filename="' & $sImageName & '"' & @CRLF & _
			$sContentType & @CRLF & @CRLF & _
			$sData & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="code"' & @CRLF & @CRLF & '123456789' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="tags"' & @CRLF & @CRLF & @CRLF & $sBoundary & '--')
EndFunc ;==> _HostBayImgSetDataToSend ()

Func _HostBayImgUpload($sPicPath)
	Local $hOpen, $hConnect, $hRequest, $sHost, $sDataToSend, $sReceivedData, $iError, $sResponse, $sPostData, $sContentType
	$sHost = 'bayimg.com' ; 'upload.bayimg.com'
	$hOpen = _WinHttpOpen($sUserAgent)
	If @error Then
		SetError(1)
	Else
		$hConnect = _WinHttpConnect($hOpen, $sHost)
		If @error Then
			SetError(2)
		Else
			$hRequest = _WinHttpOpenRequest($hConnect, 'POST', '/upload', 'HTTP/1.1')
			If @error Then
				SetError(3)
			Else
				$sDataToSend = _HostBayImgSetDataToSend($sPicPath)
				If Not @error Then
					_WinHttpSetTimeouts($hRequest, 10000, 60000, 90000, 90000)
					_WinHttpAddRequestHeaders($hRequest, 'Accept: application/x-ms-application, image/jpeg, application/xaml+xml, image/gif, image/pjpeg, application/x-ms-xbap, application/x-silverlight, */*')
					_WinHttpAddRequestHeaders($hRequest, 'Referer: http://bayimg.com/')
					_WinHttpAddRequestHeaders($hRequest, 'Accept-Encoding: gzip, deflate')
					_WinHttpAddRequestHeaders($hRequest, 'Connection: Keep-Alive')
					_WinHttpAddRequestHeaders($hRequest, 'Cache-Control: no-cache')
					_WinHttpAddRequestHeaders($hRequest, 'Cookie: images_per_page=10; show_offensive=1; no_resize=1')
					$sContentType = 'Content-Type: multipart/form-data; boundary=' & StringTrimLeft($sBoundary, 2)
					_WinHttpSendRequest($hRequest, $sContentType, $WINHTTP_NO_REQUEST_DATA, StringLen($sDataToSend))
					If @error Then
						SetError(4)
					Else
						_PicUploadProgress($hRequest, $sPicPath, $sDataToSend)
						If Not @error Then
							$hTimerInit = TimerInit()
							_WinHttpReceiveResponse($hRequest)
							If @error Then
								SetError(5)
							Else
								If _WinHttpQueryDataAvailable($hRequest) Then
									$sReceivedData = ''
									While 1
										$sReceivedData &= _WinHttpReadData($hRequest)
										If Not @extended Then
											SetError(0)
											ExitLoop ;~
										EndIf
									WEnd
									If StringInStr($sReceivedData, 'error') Then SetError(6)
								Else
									SetError(7)
								EndIf
							EndIf
						EndIf
					EndIf
				Else
					SetError(8) ; error in _HostBayImgSetDataToSend func
				EndIf
			EndIf
		EndIf
	EndIf
	$iError = @error
	If $hRequest Then _WinHttpCloseHandle($hRequest)
	If $hConnect Then _WinHttpCloseHandle($hConnect)
	If $hOpen Then _WinHttpCloseHandle($hOpen)
	Return SetError($iError, 0, $sReceivedData)
EndFunc ;==> _HostBayImgUpload ()

Func _HostImagebamExtractLinks($HtmlData)
;~  Return Links Array
;~  [0] Link only ( viewer only, not download link)
;~  [1] Thumb
;~  [2] BBCode
;~  [3] HTML
	$HtmlData = StringMid($HtmlData, StringInStr($HtmlData, 'dlinput_container', 0, 1) - StringLen('dlinput_container') - 1)
	Local $aRet = StringRegExp(StringReplace($HtmlData, @LF, ''), "(?s)(?i)dlinput_container(.*?)</div>", 3)
	If Not @error Then
		Local $aLinks[3], $aRet1
		For $i = 0 To UBound($aRet) - 2
			$aRet1 = StringRegExp($aRet[$i], "(?s)(?i)value='(.*?)>", 3)
			If Not @error Then
				$aRet1[0] = StringStripWS(StringTrimRight($aRet1[0], 1), 1 + 2)
				$aLinks[$i] = $aRet1[0]
			EndIf
		Next
		_ArrayReverse($aLinks)
		Local $sUrl = _StringBetween($aLinks[1], '[IMG]', '[/IMG]')
		If Not @error Then
			_ArrayInsert($aLinks, 1, $sUrl[0])
		Else
			Return SetError(2)
		EndIf
		If $aLinks[UBound($aLinks) - 1] <> '' Then
			Return $aLinks
		Else
			Return SetError(3)
		EndIf
	Else
		Return SetError(1)
	EndIf
EndFunc ;==> _HostImagebamExtractLinks ()

Func _HostImagebamSetDataToSend($sPicPath)
	Local $sData = _PicReadData($sPicPath)
	If @error Then Return SetError(1)
	Local $sImageName = _GetFullNameByFullPath($sPicPath)
	If @error Or $sImageName = '' Then Return SetError(2)
	Local $sContentType = _PicGetContentType($sPicPath)
	If @error Then Return SetError(3)
	Local $sCdfdn = 'Content-Disposition: form-data; name'
	Local $sCtaos = 'Content-Type: application/octet-stream'
	Local $sString = $sBoundary & @CRLF & _
			$sCdfdn & '="file[]"; filename="' & $sImageName & '"' & @CRLF & _
			$sContentType & @CRLF & @CRLF & $sData & @CRLF & $sBoundary & @CRLF
	For $i = 1 To 29
		$sString &= $sCdfdn & '="file[]"; filename=""' & @CRLF & _
				$sCtaos & @CRLF & @CRLF & @CRLF & $sBoundary & @CRLF
	Next
	$sString &= $sCdfdn & '="content_type"' & @CRLF & @CRLF & '0' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="thumb_size"' & @CRLF & @CRLF & '100' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="thumb_aspect_ratio"' & @CRLF & @CRLF & 'resize' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="thumb_file_type"' & @CRLF & @CRLF & 'jpg' & @CRLF & $sBoundary & '--'
	Return SetError(0, '', $sString)
EndFunc ;==> _HostImagebamSetDataToSend ()

Func _HostImagebamUpload($sPicPath)
	Local $hOpen, $hConnect, $hRequest, $sHost, $sDataToSend, $sReceivedData, $iError, $sResponse, $sPostData, $sContentType
	$sHost = 'www.imagebam.com'
	$hOpen = _WinHttpOpen($sUserAgent)
	If @error Then
		SetError(1)
	Else
		$hConnect = _WinHttpConnect($hOpen, $sHost)
		If @error Then
			SetError(2)
		Else
			$hRequest = _WinHttpOpenRequest($hConnect, 'POST', '/sys/upload/save', 'HTTP/1.1')
			If @error Then
				SetError(3)
			Else
				_WinHttpSetTimeouts($hRequest, 10000, 60000, 90000, 90000)
				$sDataToSend = _HostImagebamSetDataToSend($sPicPath)
				_WinHttpAddRequestHeaders($hRequest, 'Accept: application/x-ms-application, image/jpeg, application/xaml+xml, image/gif, image/pjpeg, application/x-ms-xbap, application/x-silverlight, */*')
				_WinHttpAddRequestHeaders($hRequest, 'Referer: http://www.imagebam.com/basic-upload')
				_WinHttpAddRequestHeaders($hRequest, 'Accept-Encoding: gzip, deflate')
				_WinHttpAddRequestHeaders($hRequest, 'Connection: Keep-Alive')
				_WinHttpAddRequestHeaders($hRequest, 'Cache-Control: no-cache')
				$sContentType = 'Content-Type: multipart/form-data; boundary=' & StringTrimLeft($sBoundary, 2)
				_WinHttpSendRequest($hRequest, $sContentType, $WINHTTP_NO_REQUEST_DATA, StringLen($sDataToSend))
				If @error Then
					SetError(4)
				Else
					_PicUploadProgress($hRequest, $sPicPath, $sDataToSend)
					If Not @error Then
						$hTimerInit = TimerInit()
						_WinHttpReceiveResponse($hRequest)
						If @error Then
							SetError(5)
						Else
							If _WinHttpQueryDataAvailable($hRequest) Then
								$sReceivedData = Binary('')
								While 1
									$sReceivedData &= _WinHttpReadData($hRequest, 2)
									If Not @extended Then
										SetError(0)
										ExitLoop ;~
									EndIf
								WEnd
								$sReceivedData = BinaryToString(_ZLIB_GZUncompress($sReceivedData))
								If StringInStr($sReceivedData, 'box_error') Then SetError(6) ; The thumbnail for the file pic.jpg could not be created.
							Else
								SetError(7)
							EndIf
						EndIf
					Else
						SetError(8)
					EndIf
				EndIf
			EndIf
		EndIf
	EndIf
	$iError = @error
	If $hRequest Then _WinHttpCloseHandle($hRequest)
	If $hConnect Then _WinHttpCloseHandle($hConnect)
	If $hOpen Then _WinHttpCloseHandle($hOpen)
	Return SetError($iError, 0, $sReceivedData)
EndFunc ;==> _HostImagebamUpload ()

Func _HostImGurExtractLinks($XmlData)
	Local $aImGurChars[5] = ['original', 'imgur_page', 'delete_page', 'small_square', 'large_thumbnail']
	Local $aLinks[5]
	For $i = 0 To UBound($aLinks) - 1
		$aLinks[$i] = StringRegExpReplace($XmlData, '(?is).*<(' & $aImGurChars[$i] & ')>(.*?)</\1>.*', '\2')
	Next
	If $aLinks[4] <> '' Then
		If $aLinks[UBound($aLinks) - 1] <> '' Then
			Local $sTmp = $aLinks[1]
			$aLinks[1] = $aLinks[3]
			$aLinks[3] = $sTmp
			$sTmp = $aLinks[4]
			$aLinks[4] = $aLinks[2]
			$aLinks[2] = $sTmp
			Return $aLinks
		Else
			Return SetError(3)
		EndIf
	Else
		Return SetError(1)
	EndIf
EndFunc ;==> _HostImGurExtractLinks ()

Func _HostImGurSetDataToSend($sPicPath)
	Local $sData = _PicReadData($sPicPath)
	If @error Then Return SetError(1)
	Local $sImageName = _GetFullNameByFullPath($sPicPath)
	If @error Or $sImageName = '' Then Return SetError(2)
	Local $sContentType = _PicGetContentType($sPicPath)
	If @error Then Return SetError(3)
	
	Return SetError(0, '', $sBoundary & @CRLF & _
			'Content-Disposition: form-data; name="image"; filename="' & $sImageName & '"' & @CRLF & _
			$sContentType & @CRLF & @CRLF & $sData & @CRLF & $sBoundary & @CRLF & _
			'Content-Disposition: form-data; name="key"' & @CRLF & @CRLF & $aSupported_Hosts[$iHost_imgur][1] & @CRLF & $sBoundary)
EndFunc ;==> _HostImGurSetDataToSend ()

Func _HostImGurUpload($sPicPath)
	Local $hOpen, $hConnect, $hRequest, $sHost, $sDataToSend, $sReceivedData, $iError, $sResponse, $sPostData, $sContentType
	$sHost = 'api.imgur.com'
	$hOpen = _WinHttpOpen($sUserAgent)
	If @error Then
		SetError(1)
	Else
		$hConnect = _WinHttpConnect($hOpen, $sHost)
		If @error Then
			SetError(2)
		Else
			$hRequest = _WinHttpOpenRequest($hConnect, 'POST', '/2/upload.xml', 'HTTP/1.1')
			If @error Then
				SetError(3)
			Else
				_WinHttpSetTimeouts($hRequest, 10000, 60000, 90000, 90000)
				$sDataToSend = _HostImGurSetDataToSend($sPicPath)
				_WinHttpAddRequestHeaders($hRequest, 'Accept: */*')
				_WinHttpAddRequestHeaders($hRequest, 'Expect: 100-continue')
				$sContentType = 'Content-Type: multipart/form-data; boundary=' & StringTrimLeft($sBoundary, 2)
				_WinHttpSendRequest($hRequest, $sContentType, $WINHTTP_NO_REQUEST_DATA, StringLen($sDataToSend))
				If @error Then
					SetError(4)
				Else
					_PicUploadProgress($hRequest, $sPicPath, $sDataToSend)
					If Not @error Then
						Local $hTimerInit = TimerInit()
						_WinHttpReceiveResponse($hRequest)
						If @error Then
							SetError(5)
						Else
							If _WinHttpQueryDataAvailable($hRequest) Then
								$sReceivedData = ''
								While 1
									$sReceivedData &= _WinHttpReadData($hRequest)
									If Not @extended Then
										SetError(0)
										ExitLoop
									EndIf
								WEnd
								If StringInStr($sReceivedData, 'error') Then SetError(6)
							Else
								SetError(7)
							EndIf
						EndIf
					Else
						SetError(8)
					EndIf
				EndIf
			EndIf
		EndIf
	EndIf
	$iError = @error
	If $hRequest Then _WinHttpCloseHandle($hRequest)
	If $hConnect Then _WinHttpCloseHandle($hConnect)
	If $hOpen Then _WinHttpCloseHandle($hOpen)
	Return SetError($iError, 0, $sReceivedData)
EndFunc ;==> _HostImGurUpload ()

Func _HostPostimageExtractLinks($HtmlData)
;~  Return Links Array
;~  [0] Viewer link for animated gifs and direct Link for other image types.
;~  [1] Thumb direct link
;~  [2] Thumbnail for Forums
;~  [3] Thumbnail for Website
;~  [4] Deletion Link
	Local $i = 1
	Local $aLinks = StringRegExp($HtmlData, '(?s)(?i)scrolling="no">(.*?)</textarea', 3)
	If Not @error Then
		If UBound($aLinks) > 5 Then
			$i = 2
			$aLinks[0] = $aLinks[1]
		EndIf
		Local $aThumb = _StringBetween($aLinks[$i], '[img]', '[/img]')
		If Not @error Then
			$aLinks[1] = $aThumb[0]
			If UBound($aLinks) > 5 Then
				_ArrayDelete($aLinks, 2)
				$aLinks[4] = $aLinks[UBound($aLinks) - 1]
				ReDim $aLinks[5]
			EndIf
			If $aLinks[UBound($aLinks) - 1] <> '' Then
				Return $aLinks
			Else
				Return SetError(3)
			EndIf
		Else
			Return SetError(2)
		EndIf
	Else
		Return SetError(1)
	EndIf
EndFunc ;==> _HostPostimageExtractLinks ()

Func _HostPostimageSetDataToSend($sPicPath)
	Local $sData = _PicReadData($sPicPath)
	If @error Then Return SetError(1)
	Local $sImageName = _GetFullNameByFullPath($sPicPath)
	If @error Or $sImageName = '' Then Return SetError(2)
	Local $sContentType = _PicGetContentType($sPicPath)
	If @error Then Return SetError(3)
	Local $sCdfdn = 'Content-Disposition: form-data; name'
	Return SetError(0, '', $sBoundary & @CRLF & _
			$sCdfdn & '="mode"' & @CRLF & @CRLF & 'local' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="areaid"' & @CRLF & @CRLF & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="hash"' & @CRLF & @CRLF & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="code"' & @CRLF & @CRLF & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="content"' & @CRLF & @CRLF & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="tpl"' & @CRLF & @CRLF & '.' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="ver"' & @CRLF & @CRLF & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="addform"' & @CRLF & @CRLF & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="mforum"' & @CRLF & @CRLF & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="um"' & @CRLF & @CRLF & 'image' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="ui"' & @CRLF & @CRLF & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="forumurl"' & @CRLF & @CRLF & 'http://postimage.org/' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="hash"' & @CRLF & @CRLF & '338' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="MAX_FILE_SIZE"' & @CRLF & @CRLF & '10485760' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="upload[]"; filename="' & $sImageName & '"' & @CRLF & $sContentType & @CRLF & @CRLF & $sData & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="ui"' & @CRLF & @CRLF & '32__1920__1080__true__en__en__ __' & $sUserAgent & '__' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="optsize"' & @CRLF & @CRLF & '0' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="adult"' & @CRLF & @CRLF & 'no' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="submit"' & @CRLF & @CRLF & 'Upload It!' & @CRLF & $sBoundary & @CRLF & '--')
EndFunc ;==> _HostPostimageSetDataToSend ()

Func _HostPostimageUpload($sPicPath)
	Local $hOpen, $hConnect, $hRequest, $sHost, $sDataToSend, $sReceivedData, $iError, $sResponse, $sPostData, $sContentType
	$sHost = 'postimage.org'
	$hOpen = _WinHttpOpen($sUserAgent)
	If @error Then
		SetError(1)
	Else
		$hConnect = _WinHttpConnect($hOpen, $sHost)
		If @error Then
			SetError(2)
		Else
			$hRequest = _WinHttpOpenRequest($hConnect, 'POST', '/', 'HTTP/1.1')
			If @error Then
				SetError(3)
			Else
				_WinHttpSetTimeouts($hRequest, 10000, 60000, 90000, 90000)
				$sDataToSend = _HostPostimageSetDataToSend($sPicPath)
				If Not @error Then
					_WinHttpAddRequestHeaders($hRequest, 'Accept: application/x-ms-application, image/jpeg, application/xaml+xml, image/gif, image/pjpeg, application/x-ms-xbap, application/x-silverlight, */*')
					_WinHttpAddRequestHeaders($hRequest, 'Referer: http://postimage.org/')
					_WinHttpAddRequestHeaders($hRequest, 'Accept-Encoding: gzip, deflate')
					_WinHttpAddRequestHeaders($hRequest, 'Connection: Keep-Alive')
					_WinHttpAddRequestHeaders($hRequest, 'Cache-Control: no-cache')
					$sContentType = 'Content-Type: multipart/form-data; boundary=' & StringTrimLeft($sBoundary, 2)
					_WinHttpSendRequest($hRequest, $sContentType, $WINHTTP_NO_REQUEST_DATA, StringLen($sDataToSend))
					If @error Then
						SetError(4) ; can't send request
					Else
						_PicUploadProgress($hRequest, $sPicPath, $sDataToSend)
						If Not @error Then
							$hTimerInit = TimerInit()
							_WinHttpReceiveResponse($hRequest)
							If @error Then
								SetError(5) ; no response received
							Else
								If _WinHttpQueryDataAvailable($hRequest) Then
									$sReceivedData = Binary('')
									While 1
										$sReceivedData &= _WinHttpReadData($hRequest, 2)
										If Not @extended Then
											SetError(0)
											ExitLoop
										EndIf
									WEnd
									$sReceivedData = BinaryToString(_ZLIB_GZUncompress($sReceivedData))
;~                                  If StringInStr ( $sReceivedData, 'File is too large.' ) Then SetError ( 7 )
									If Not StringInStr($sReceivedData, 'Upload Completed!') Then SetError(6) ; error while receiving data
								Else
									SetError(7) ; no datas available
								EndIf
							EndIf
						Else
							SetError(8)
						EndIf
					EndIf
				Else
					SetError(9) ; error in _HostPostimageSetDataToSend func
				EndIf
			EndIf
		EndIf
	EndIf
	$iError = @error
	If $hRequest Then _WinHttpCloseHandle($hRequest)
	If $hConnect Then _WinHttpCloseHandle($hConnect)
	If $hOpen Then _WinHttpCloseHandle($hOpen)
	Return SetError($iError, 0, $sReceivedData)
EndFunc

Func _HostTinyPicExtractLinks($XmlData)
	If StringInStr($XmlData, '<status>FAIL</status>') Or StringInStr($XmlData, '<errorcode>1</errorcode>') Then Return SetError(1)
	Local $aTinyPicChars[5] = ['fullsize', 'thumbnail', 'htmlcode', 'forumcode', 'emailimcode']
	Local $aLinks[5]
	For $i = 0 To UBound($aLinks) - 1
		$aLinks[$i] = StringRegExpReplace($XmlData, '(?is).*<(' & $aTinyPicChars[$i] & ')>(.*?)</\1>.*', '\2')
	Next
	$aLinks[0] = StringReplace($aLinks[0], 'http://', 'http://o')
	$aLinks[2] = StringReplace($aLinks[2], '&lt;', '<')
	$aLinks[2] = StringReplace($aLinks[2], '&gt;', '>')
	$aLinks[2] = StringReplace($aLinks[2], '&quot;', '"')
	Local $PicId = _StringBetween($aLinks[2], 'ref=', '"')
	If Not @error And UBound($PicId) > 1 Then
		$aLinks[4] = 'http://tinypic.com/view.php?pic=' & $PicId[1] & '&s=6 and Report Pic'
		ReDim $aLinks[5]
	Else
		ReDim $aLinks[4]
	EndIf
	If $aLinks[UBound($aLinks) - 1] <> '' Then
		Return $aLinks
	Else
		Return SetError(3)
	EndIf
EndFunc ;==> _HostTinyPicExtractLinks ()

Func _HostTinyPicExtractUploadKey($XmlData)
	Local $aRet = StringRegExp($XmlData, '(?s)(?i)uploadkey>(.*?)</uploadkey', 3)
	If Not @error Then Return $aRet[0]
EndFunc ;==> _HostTinyPicExtractUploadKey ()

Func _HostTinyPicGetUploadKey()
	Local $hOpen, $hConnect, $hRequest, $sHost, $sReceivedData, $iError
	$sHost = 'api.tinypic.com'
	$hOpen = _WinHttpOpen($sUserAgent)
	If @error Then
		SetError(1)
	Else
		$hConnect = _WinHttpConnect($hOpen, $sHost)
		If @error Then
			SetError(2)
		Else
			$hRequest = _WinHttpOpenRequest($hConnect, 'GET', _
					'/api.php?action=getuploadkey&tpid=' & $aSupported_Hosts[$iHost_tinypic][1] & '&sig=d251709a418616847d999bbd0dba0042&responsetype=XML', 'HTTP/1.1')
			
			If @error Then
				SetError(3)
			Else
				_WinHttpSetTimeouts($hRequest, 5000, 10000, 10000, 10000)
				_WinHttpAddRequestHeaders($hRequest, 'Connection: Close')
				_WinHttpSendRequest($hRequest)
				If @error Then
					SetError(4)
				Else
					_WinHttpReceiveResponse($hRequest)
					If @error Then
						SetError(5)
					Else
						If _WinHttpQueryDataAvailable($hRequest) Then
							$sReceivedData = ''
							While 1
								$sReceivedData &= _WinHttpReadData($hRequest)
								If Not @extended Then ExitLoop
							WEnd
							If StringInStr($sReceivedData, '<status>FAIL</status>') Then SetError(6)
						Else
							SetError(7)
						EndIf
					EndIf
				EndIf
			EndIf
		EndIf
	EndIf
	$iError = @error
	If $hRequest Then _WinHttpCloseHandle($hRequest)
	If $hConnect Then _WinHttpCloseHandle($hConnect)
	If $hOpen Then _WinHttpCloseHandle($hOpen)
	Return SetError($iError, 0, $sReceivedData)
EndFunc ;==> _HostTinyPicGetUploadKey ()

Func _HostTinyPicSetDataToSend($sPicPath)
	Local $sData = _PicReadData($sPicPath)
	If @error Then Return SetError(1)
	Local $sImageName = _GetFullNameByFullPath($sPicPath)
	If @error Or $sImageName = '' Then Return SetError(2)
	Local $sContentType = _PicGetContentType($sPicPath)
	If @error Then Return SetError(3)
	Local $sCdfdn = 'Content-Disposition: form-data; name'
	Return SetError(0, '', $sBoundary & @CRLF & _
			$sCdfdn & '="action"' & @CRLF & @CRLF & 'upload' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="tpid"' & @CRLF & @CRLF & $aSupported_Hosts[$iHost_tinypic][1] & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="sig"' & @CRLF & @CRLF & '067fc930ca6360449bdd409da5961ccf' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="responsetype"' & @CRLF & @CRLF & 'XML' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="upk"' & @CRLF & @CRLF & $sUploadKey & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="type"' & @CRLF & @CRLF & 'image' & @CRLF & $sBoundary & @CRLF & _
			$sCdfdn & '="uploadfile"; filename="' & $sImageName & '"' & @CRLF & _
			$sContentType & @CRLF & @CRLF & $sData & @CRLF & $sBoundary & '--')
EndFunc ;==> _HostTinyPicSetDataToSend ()

Func _HostTinyPicUpload($sPicPath) ; http://tinypic.com/?t=postupload
	Local $hOpen, $hConnect, $hRequest, $sHost, $sDataToSend, $sReceivedData, $iError, $sResponse, $sPostData, $sContentType
	$sHost = 'api.tinypic.com'
	$hOpen = _WinHttpOpen($sUserAgent)
	If @error Then
		SetError(1)
	Else
		$hConnect = _WinHttpConnect($hOpen, $sHost)
		If @error Then
			SetError(2)
		Else
			$hRequest = _WinHttpOpenRequest($hConnect, 'POST', '/api.php', 'HTTP/1.1')
			If @error Then
				SetError(3)
			Else
				_WinHttpSetTimeouts($hRequest, 10000, 60000, 90000, 90000)
				$sDataToSend = _HostTinyPicSetDataToSend($sPicPath)
				If Not @error Then
					_WinHttpAddRequestHeaders($hRequest, 'Referer: http://tinypic.com/')
					_WinHttpAddRequestHeaders($hRequest, 'Pragma: no-cache')
					_WinHttpAddRequestHeaders($hRequest, 'Connection: Close')
					_WinHttpAddRequestHeaders($hRequest, 'Cache-Control: no-store,no-cache')
					$sContentType = 'Content-Type: multipart/form-data; boundary=' & StringTrimLeft($sBoundary, 2)
					_WinHttpSendRequest($hRequest, $sContentType, $WINHTTP_NO_REQUEST_DATA, StringLen($sDataToSend))
					If @error Then
						SetError(4)
					Else
						_PicUploadProgress($hRequest, $sPicPath, $sDataToSend)
						If Not @error Then
							$hTimerInit = TimerInit()
							_WinHttpReceiveResponse($hRequest)
							If @error Then
								SetError(5)
							Else
								If _WinHttpQueryDataAvailable($hRequest) Then
									$sReceivedData = ''
									While 1
										$sReceivedData &= _WinHttpReadData($hRequest)
										If Not @extended Then
											SetError(0)
											ExitLoop
										EndIf
									WEnd
;~                                  ; <status>OK</status>
;~                                  If StringInStr ( $sReceivedData, '<status>OK</status>' ) Then ExitLoop
									If StringInStr($sReceivedData, 'Upload Failed') Or StringInStr($sReceivedData, '<status>FAIL</status>') Then SetError(6)
;~                                  If StringInStr ( $sReceivedData, 'error' ) Then SetError ( 7 )
								Else
									SetError(7)
								EndIf
							EndIf
						Else
							SetError(8)
						EndIf
					EndIf
				Else
					SetError(9) ; error in _HostTinyPicSetDataToSend func
				EndIf
			EndIf
		EndIf
	EndIf
	$iError = @error
	If $hRequest Then _WinHttpCloseHandle($hRequest)
	If $hConnect Then _WinHttpCloseHandle($hConnect)
	If $hOpen Then _WinHttpCloseHandle($hOpen)
	Return SetError($iError, 0, $sReceivedData)
EndFunc ;==> _HostTinyPicUpload ()
