#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#Region Header

;Source code for AutoIt 3.3.10.2

#pragma compile(Icon, Resources\Icon.ico)
#pragma compile(ExecLevel, highestavailable)
#pragma compile(Compatibility, win7)
#pragma compile(x64, False)
#pragma compile(UPX, True)
#pragma compile(Compression, 9)
#pragma compile(FileDescription, 'Screen Capture Utility')
#pragma compile(ProductName, 'CaptureIt')
#pragma compile(ProductVersion, '1.0.4')
#pragma compile(FileVersion, '1.0.4')
#pragma compile(LegalCopyright, 'Copyright  2008-2014 G.Sandler (CreatoR), www.autoit-script.ru. All rights reserved.')
#pragma compile(CompanyName, 'CreatoR's Lab')
#pragma compile(Comments, 'Program made by G.Sandler')

#include <Constants.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <StaticConstants.au3>
#include <EditConstants.au3>
#include <TabConstants.au3>
#include <ComboConstants.au3>
#include <ButtonConstants.au3>
#include <GUIListView.au3>
#include <GUITab.au3>
#include <ScreenCapture.au3>
#include <ClipBoard.au3>
#include <Misc.au3>
#include <File.au3>
#include <WinAPIEx.au3>

#include "Includes\AboutBox.au3"
#include "Includes\GUIHotKey.au3"
#include "Includes\ModernMenu.au3"
#include "Includes\TreeViewTab.au3"
#include "Includes\iUploader\iUploader.au3"

Opt("TrayMenuMode", 1)
Opt("GUIOnEventMode", 1)
Opt("TrayOnEventMode", 1)

_Singleton("CaptureIt")

#EndRegion Header

#Region Variables and Options

;Defaults
Global $Def_Silent_Save_Path		= _GetMyPicturesPath()
Global $Def_Silent_Save_FileName	= "Captured_Image [%s] [$MM.DD.YYYY, HH;MM;SS$]"
Global $Def_Captured_ImgFile		= "Captured Image"
Global $Def_ImageEditorPath			= "ImageView_Fullscreen"
Global $Def_UploadImage_Host		= "tinypic.com"
Global $Def_Last_Sttngs_TVItem		= "Main"

Global $Def_sFullScreen_HK			= "^{F10}"
Global $Def_sWindow_HK				= "^{F9}"
Global $Def_sSelection_HK			= "^{F8}"

Global $AppName						= "CaptureIt"
Global $AppVersion					= _GetResData("ProductVersion")
Global $CopyRight_Str 				= _GetResData("LegalCopyright")
Global $ConfigFile					= @ScriptDir & "\CaptureIt.ini"

Global $Default_Save_Format			= IniRead($ConfigFile, "Image Format Prefs", "Default Image Format", 1)
Global $Remember_LastSave_Format	= IniRead($ConfigFile, "Image Format Prefs", "Remember Last Image Format", 1)
Global $JPG_Quality					= IniRead($ConfigFile, "Image Format Prefs", "JPG Quality", 100)
Global $BMP_Format					= IniRead($ConfigFile, "Image Format Prefs", "BMP Format", 2)

Global $SaveHistory					= IniRead($ConfigFile, "Main Prefs", "Save Capture History", 1)
Global $SaveToFile					= IniRead($ConfigFile, "Main Prefs", "Save To File", 1)
Global $Captured_ImgFile			= IniRead($ConfigFile, "Main Prefs", "Capture Image File", $Def_Captured_ImgFile)
Global $SelectActionAfterCapture	= IniRead($ConfigFile, "Main Prefs", "Select Action After Capture", 0)
Global $OpenImageInEditor			= IniRead($ConfigFile, "Main Prefs", "Open Image In Editor", 0)
Global $ImageEditorPath				= IniRead($ConfigFile, "Main Prefs", "Image Editor", $Def_ImageEditorPath)
Global $PrintImage					= IniRead($ConfigFile, "Main Prefs", "Print Image", 0)
Global $UploadImage					= IniRead($ConfigFile, "Main Prefs", "Upload Image", 0)
Global $UploadImage_Host			= IniRead($ConfigFile, "Main Prefs", "Upload Image Host", $Def_UploadImage_Host)
Global $CopyImageToClipBoard		= IniRead($ConfigFile, "Main Prefs", "Copy Image To ClipBoard", 0)
Global $WaitBeforeCapture			= IniRead($ConfigFile, "Main Prefs", "Wait Before Capturing", 0)
Global $WaitBeforeCapture_Secs		= IniRead($ConfigFile, "Main Prefs", "Wait Before Capturing Secs", 0)
Global $UseAlternativeCapture 		= IniRead($ConfigFile, "Main Prefs", "Use Alternative Capture", 0)

Global $Last_Sttngs_TVItem			= IniRead($ConfigFile, "Main Prefs", "Settings Last Tab", $Def_Last_Sttngs_TVItem)
Global $Show_ToolTip				= IniRead($ConfigFile, "Main Prefs", "Show ToolTip", 1)

Global $sFullScreen_HK				= IniRead($ConfigFile, "HotKyes Prefs", "FullScreen HotKey", $Def_sFullScreen_HK)
Global $sWindow_HK					= IniRead($ConfigFile, "HotKyes Prefs", "Window HotKey", $Def_sWindow_HK)
Global $sSelection_HK				= IniRead($ConfigFile, "HotKyes Prefs", "Selection HotKey", $Def_sSelection_HK)

Global $Silent_Save					= IniRead($ConfigFile, "Silent Save Prefs", "Silent Save", 0)
Global $Silent_Save_Path			= IniRead($ConfigFile, "Silent Save Prefs", "Silent Save Path", $Def_Silent_Save_Path)
Global $Silent_Save_FileName		= IniRead($ConfigFile, "Silent Save Prefs", "Silent Save File Name", $Def_Silent_Save_FileName)

_GDIPlus_Validate()

Global $oCOM_Err					= ObjEvent("AutoIt.Error", "COM_Error_Handler")
Global $hUpldPrgrs_Callback_Func	= UploadImage_PrgrsCallback

Global $GUI_Bk_Color				= 0xDADADA
Global $GUI_Txt_Color				= 0x4B4B4B
Global $GUI_GrpTxt_Color			= 0xFF0000
Global $GUI_TVItem_Color			= 0x0000C0
Global $GUI_TipTxt_Color			= 0x6F6F6F
Global $Tray_Bk_Color				= $GUI_Bk_Color
Global $Tray_Txt_Color				= $GUI_Txt_Color

Global $Frame_Color 				= 0xFF0000
Global $Frame_Width 				= 3
Global $hSelection_GUI				= -1
Global $hSquare_GUI					= -1

Global $JPG_Quality_Label			= -1
Global $JPG_Quality_Slider			= -1

Global $ShowSettings				= False
Global $iPrimaryMouseClicked		= False

Global $Icons_Library_Path			= @TempDir & "\Icons.icl"
Global $Capture_Sound_Path			= @TempDir & "\Capture.wav"
Global $History_Path				= @ScriptDir & "\History"

Global $iHistoryPreview_Pic			= 0

Local $aBMP_Format_List[5] = [ _
	"16 bpp; 5 bits for each RGB component", _
	"16 bpp; 5 bits for red, 6 bits for green and 5 bits blue", _
	"24 bpp; 8 bits for each RGB component", _
	"32 bpp; 8 bits for each RGB component. No alpha component.", _
	"32 bpp; 8 bits for each RGB and alpha component"]

If $BMP_Format < 0 Or $BMP_Format > 4 Then $BMP_Format = 2
If $JPG_Quality < 0 Or $JPG_Quality > 100 Then $JPG_Quality = 100

_ScreenCapture_SetBMPFormat($BMP_Format)
_ScreenCapture_SetJPGQuality($JPG_Quality)

FileInstall("Resources\Icons.icl", $Icons_Library_Path)
FileInstall("Resources\Capture.wav", $Capture_Sound_Path)

HotKeysSet_Toggle_Proc(1)

#EndRegion Variables and Options

#Region Tray Part

$Tray_Icon = _TrayIconCreate($AppName & " v" & $AppVersion & @LF & "Click right mouse buton to show main menu", $Icons_Library_Path, 0, "TrayCallBack_Proc")
_TrayIconSetClick(-1, 16)
_SetTrayBkColor($Tray_Bk_Color)
_SetTrayIconBkColor($Tray_Bk_Color)
_SetTrayTextColor($Tray_Txt_Color)
_SetTraySelectBkColor(0xCC0000)
_SetTraySelectTextColor(0x80FFFF)

$Settings_TrayItem = _TrayCreateItem("Settings")
GUICtrlSetOnEvent(-1, "Tray_Events")
GUICtrlSetState(-1, $GUI_DEFBUTTON)
_TrayItemSetIcon(-1, $Icons_Library_Path, 1)

$About_TrayItem = _TrayCreateItem("About - " & $AppName)
GUICtrlSetOnEvent(-1, "Tray_Events")
_TrayItemSetIcon(-1, $Icons_Library_Path, 2)

_TrayCreateItem("")
_TrayItemSetIcon(-1, "", 0)

$sFHK_TrayText = ($sFullScreen_HK <> "") ? @TAB & "(" & _GetHotKeyTrueValue($sFullScreen_HK) & ")" : ""
$sWHK_TrayText = ($sWindow_HK <> "") ? @TAB & "(" & _GetHotKeyTrueValue($sWindow_HK) & ")" : ""
$sSHK_TrayText = ($sSelection_HK <> "") ? @TAB & "(" & _GetHotKeyTrueValue($sSelection_HK) & ")" : ""

$FullScreenCapture_TrayItem = _TrayCreateItem("Full Screen Capture" & $sFHK_TrayText)
GUICtrlSetOnEvent(-1, "Tray_Events")
_TrayItemSetIcon(-1, $Icons_Library_Path, 4)

$WindowCapture_TrayItem = _TrayCreateItem("Window Capture" & $sWHK_TrayText)
GUICtrlSetOnEvent(-1, "Tray_Events")
_TrayItemSetIcon(-1, $Icons_Library_Path, 5)

$SelectionCapture_TrayItem = _TrayCreateItem("Selection Capture" & $sSHK_TrayText)
GUICtrlSetOnEvent(-1, "Tray_Events")
_TrayItemSetIcon(-1, $Icons_Library_Path, 6)

_TrayCreateItem("")
_TrayItemSetIcon(-1, "", 0)

$CaptureHistory_TrayItem = _TrayCreateItem("Capture History")
GUICtrlSetOnEvent(-1, "Tray_Events")
_TrayItemSetIcon(-1, $Icons_Library_Path, 9)

_TrayCreateItem("")
_TrayItemSetIcon(-1, "", 0)

$Exit_TrayItem = _TrayCreateItem("Exit " & $AppName)
GUICtrlSetOnEvent($Exit_TrayItem, "Tray_Events")
_TrayItemSetIcon(-1, $Icons_Library_Path, 3)

If $Show_ToolTip = 1 Then
	_TrayTip($Tray_Icon, $AppName & " v" & $AppVersion, "This program works from system tray" & @LF & "Click right mouse button to show main menu", 20, 1)
	IniWrite($ConfigFile, "Main Prefs", "Show ToolTip", 0)
EndIf

#EndRegion Tray Part

#Region RegisterMsg and Main Loop

GUIRegisterMsg($WM_LBUTTONDOWN, "WM_LBUTTONDOWN")
GUIRegisterMsg($WM_ENTERMENULOOP, "WM_ENTEREXITMENULOOP")
GUIRegisterMsg($WM_EXITMENULOOP, "WM_ENTEREXITMENULOOP")

While 1
	Sleep(100)
	
	If $ShowSettings Then
		$ShowSettings = False
		
		_TrayIconSetState(-1, 2)
		HotKeysSet_Toggle_Proc(0)
		
		Settings_Dialog()
		
		HotKeysSet_Toggle_Proc(1)
		_TrayIconSetState(-1, 1)
	EndIf
WEnd

#EndRegion RegisterMsg and Main Loop

#Region Program Functions

Func Settings_Dialog()
	Opt("GUIOnEventMode", 0)
	
	Local $sAutoRun_App_With_Windows = RegRead("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", $AppName)
	
	Local Enum _
		$iMain_Indx, $iCaptureMode_Indx, $iHotKeys_Indx, _
		$iTotal_Indxs
	
	Local $aImage_Indxs[$iTotal_Indxs][2] = [['Main', -2], ['Capturing', -8], ['HotKeys', -9]]
	Local $iWidth = 680, $iHeight = 450
	Local $iLeft_Base = 160
	
	Local $hSettings_GUI = GUICreate($AppName & " - Settings", $iWidth, $iHeight, -1, -1, -1, _
		BitOR($WS_EX_DLGMODALFRAME, $WS_EX_TOOLWINDOW, $WS_EX_DLGMODALFRAME, $WS_EX_CLIENTEDGE, $WS_EX_APPWINDOW))
	GUISetBkColor($GUI_Bk_Color)
	GUISetIcon($Icons_Library_Path, 0, $hSettings_GUI)
	
	;Seperators
	GUICtrlCreateLabel('', $iLeft_Base + 10, 50, $iWidth - $iLeft_Base - 20, 2, $SS_SUNKEN)
	GUICtrlCreateGroup('', $iLeft_Base + 10, 55, $iWidth - $iLeft_Base - 20, $iHeight - 105)
	GUICtrlCreateLabel('', 10, $iHeight - 40, $iWidth - 20, 2, $SS_SUNKEN)
	
	DllCall("uxtheme.dll", "none", "SetThemeAppProperties", "int", 0)
	
	Local $iTreeViewTab = _GUICtrlTreeViewTab_CreateTab(10, 10, $iLeft_Base - 10, $iHeight - 60, -1, BitOR($WS_EX_STATICEDGE, $WS_EX_CLIENTEDGE))
	
	#Region Main Preferences
	
	Local $iMain_TVItem = _GUICtrlTreeViewTab_CreateTabItem($aImage_Indxs[$iMain_Indx][0], $iTreeViewTab)
	GUICtrlSetColor(-1, $GUI_TVItem_Color)
	GUICtrlSetImage(-1, $Icons_Library_Path, $aImage_Indxs[$iMain_Indx][1])
	
	GUICtrlCreateIcon($Icons_Library_Path, $aImage_Indxs[$iMain_Indx][1], $iLeft_Base + 20, 10, 32, 32)
	GUICtrlCreateLabel($aImage_Indxs[$iMain_Indx][0], $iLeft_Base + 60, 10, $iWidth - $iLeft_Base - 40, 40)
	GUICtrlSetColor(-1, $GUI_GrpTxt_Color)
	GUICtrlSetFont(-1, 12, 800, 0, 'Georgia')
	
	Local $AutorunWithWin_CB = GUICtrlCreateCheckbox("Autorun program with Windows", $iLeft_Base + 20, 70)
	If $sAutoRun_App_With_Windows = FileGetShortName(@ScriptFullPath) Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $SaveHistory_CB = GUICtrlCreateCheckbox("Save capture history", $iLeft_Base + 20, 95)
	If $SaveHistory = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	GUICtrlCreateGroup("Save Image Format", $iLeft_Base + 30, 200, $iWidth - $iLeft_Base - 60, 180)
	GUICtrlSetColor(-1, $GUI_GrpTxt_Color)
	
	Local $Remember_LastSave_Format_CB = GUICtrlCreateCheckbox("Remember last format when saving", $iLeft_Base + 40, 220)
	If $Remember_LastSave_Format = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $PngImage_Radio = GUICtrlCreateRadio("PNG", $iLeft_Base + 40, 250, 50, 15)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	If $Default_Save_Format <= 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	
	Local $GifImage_Radio = GUICtrlCreateRadio("GIF", $iLeft_Base + 40, 280, 50, 15)
	If $Default_Save_Format = 2 Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $JpgImage_Radio = GUICtrlCreateRadio("JPEG", $iLeft_Base + 40, 310, 50, 15)
	If $Default_Save_Format = 3 Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	GUICtrlCreateLabel("Quality:", $iLeft_Base + 90, 310, -1, 15)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	$JPG_Quality_Slider = GUICtrlCreateSlider($iLeft_Base + 130, 308, $iWidth - ($iLeft_Base + 200), 20)
	GUICtrlSetLimit(-1, 100, 0)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	GUICtrlSetBkColor(-1, $GUI_Bk_Color)
	GUICtrlSetData(-1, $JPG_Quality)
	If $Default_Save_Format <> 3 Then GUICtrlSetState(-1, $GUI_DISABLE)
	
	$JPG_Quality_Label = GUICtrlCreateLabel($JPG_Quality, $iWidth - 65, 310, 30)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $BmpImage_Radio = GUICtrlCreateRadio("BMP", $iLeft_Base + 40, 345, 50, 15)
	If $Default_Save_Format = 4 Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	GUICtrlCreateLabel("Image Format:", $iLeft_Base + 90, 345, -1, 15)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $BMP_Format_Combo = GUICtrlCreateCombo("", $iLeft_Base + 160, 343, $iWidth - ($iLeft_Base + 200), 30, BitOR($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
	Local $sDefault_BMP_Format = $aBMP_Format_List[2]
	If $Default_Save_Format <> 4 Then GUICtrlSetState(-1, $GUI_DISABLE)
	
	For $i = 0 To 4
		If $i = $BMP_Format Then $sDefault_BMP_Format = $aBMP_Format_List[$i]
		GUICtrlSetData(-1, $aBMP_Format_List[$i], $sDefault_BMP_Format)
	Next
	
	#EndRegion Main Preferences
	
	#Region Capture Mode Preferences
	
	Local $iCaptureMode_TVItem = _GUICtrlTreeViewTab_CreateTabItem($aImage_Indxs[$iCaptureMode_Indx][0], $iTreeViewTab)
	GUICtrlSetColor(-1, $GUI_TVItem_Color)
	GUICtrlSetImage(-1, $Icons_Library_Path, $aImage_Indxs[$iCaptureMode_Indx][1])
	
	GUICtrlCreateIcon($Icons_Library_Path, $aImage_Indxs[$iCaptureMode_Indx][1], $iLeft_Base + 20, 10, 32, 32)
	GUICtrlCreateLabel($aImage_Indxs[$iCaptureMode_Indx][0], $iLeft_Base + 60, 10, 300, 40)
	GUICtrlSetColor(-1, $GUI_GrpTxt_Color)
	GUICtrlSetFont(-1, 12, 800, 0, 'Georgia')
	
	GUICtrlCreateGroup("Save to file", $iLeft_Base + 20, 70, $iWidth - ($iLeft_Base + 40), 130)
	GUICtrlSetColor(-1, $GUI_GrpTxt_Color)
	
	Local $SaveToFile_CB = GUICtrlCreateCheckbox("Display <File Save> dialog after capturing", $iLeft_Base + 30, 90)
	If $SaveToFile = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $SilentSave_CB = GUICtrlCreateCheckbox("Silent Save to specified folder", $iLeft_Base + 30, 110)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $SilentSave_Path_Input = GUICtrlCreateInput($Silent_Save_Path, $iLeft_Base + 30, 135, $iWidth - ($iLeft_Base + 90), 20, -1, $WS_EX_DLGMODALFRAME)
	GUICtrlSetState(-1, $GUI_DISABLE)
	
	Local $SilentSave_SelectPath_Button = GUICtrlCreateButton("...", $iWidth - 50, 135, 20, 20)
	GUICtrlSetState(-1, $GUI_DISABLE)
	
	GUICtrlCreateLabel("File Name:", $iLeft_Base + 30, 163)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	Local $SilentSave_Name_Input = GUICtrlCreateInput($Silent_Save_FileName, $iLeft_Base + 120, 160, $iWidth - ($iLeft_Base + 150), 20, -1, $WS_EX_DLGMODALFRAME)
	GUICtrlSetState(-1, $GUI_DISABLE)
	
	GUICtrlCreateLabel("Existing files will be automaticaly renamed (File (1)..(2) etc.)", $iLeft_Base + 30, 180, -1, 15)
	GUICtrlSetColor(-1, $GUI_TipTxt_Color)
	GUICtrlSetFont(-1, 8, 400, 2)
	
	If $Silent_Save = 1 Then
		GUICtrlSetState($SaveToFile_CB, $GUI_DISABLE)
		GUICtrlSetState($SilentSave_CB, $GUI_CHECKED)
		GUICtrlSetState($SilentSave_Path_Input, $GUI_ENABLE)
		GUICtrlSetState($SilentSave_Name_Input, $GUI_ENABLE)
		GUICtrlSetState($SilentSave_SelectPath_Button, $GUI_ENABLE)
	EndIf
	
	Local $SelectActionAfterCapture_CB = GUICtrlCreateCheckbox("Select action after capturing", $iLeft_Base + 20, 210)
	GUICtrlSetState(-1, ($SelectActionAfterCapture = 1) ? $GUI_CHECKED : $GUI_UNCHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $OpenImageInEditor_CB = GUICtrlCreateCheckbox("Open Image in [...] after capturing", $iLeft_Base + 20, 235, -1, 15)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $OpenImageInEditor_Input = GUICtrlCreateInput($ImageEditorPath, $iLeft_Base + 20, 255, $iWidth - ($iLeft_Base + 80), 20, -1, $WS_EX_DLGMODALFRAME)
	GUICtrlSetState(-1, $GUI_DISABLE)
	
	Local $OpenImageInEditor_SelectPath_Button = GUICtrlCreateButton("...", $iWidth - 50, 255, 20, 20)
	GUICtrlSetState(-1, $GUI_DISABLE)
	
	If $OpenImageInEditor = 1 Then
		GUICtrlSetState($OpenImageInEditor_CB, $GUI_CHECKED)
		GUICtrlSetState($OpenImageInEditor_SelectPath_Button, $GUI_ENABLE)
		GUICtrlSetState($OpenImageInEditor_Input, $GUI_ENABLE)
	EndIf
	
	Local $PrintImage_CB = GUICtrlCreateCheckbox("Print image after capture", $iLeft_Base + 20, 285)
	If $PrintImage = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $UploadImage_CB = GUICtrlCreateCheckbox("Upload image after capture to:", $iLeft_Base + 20, 305)
	GUICtrlSetState(-1, ($UploadImage = 1) ? $GUI_CHECKED : $GUI_UNCHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $UploadImage_Combo = GUICtrlCreateCombo("", $iLeft_Base + 185, 304, $iWidth - ($iLeft_Base + 215), 30, _
		BitOR($CBS_AUTOHSCROLL, $WS_VSCROLL, $CBS_DROPDOWNLIST))
	Local $sUIC_Data = ''
	
	For $i = 0 To UBound($aSupported_Hosts) - 1
		$sUIC_Data &= $aSupported_Hosts[$i][0] & '|'
	Next
	
	GUICtrlSetData($UploadImage_Combo, $sUIC_Data, $UploadImage_Host)
	GUICtrlSetState(-1, ($UploadImage = 1) ? $GUI_ENABLE : $GUI_DISABLE)
	
	Local $CopyImageToClipBoard_CB = GUICtrlCreateCheckbox("Copy Image to clipboard after capture", $iLeft_Base + 20, 325)
	If $CopyImageToClipBoard = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $WaitBeforeCapture_CB = GUICtrlCreateCheckbox("Wait before capturing:", $iLeft_Base + 20, 350)
	GUICtrlSetState(-1, ($WaitBeforeCapture = 1) ? $GUI_CHECKED : $GUI_UNCHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $WaitBeforeCapture_Input = GUICtrlCreateInput($WaitBeforeCapture_Secs, $iLeft_Base + 150, 350, 30, 20, BitOR($GUI_SS_DEFAULT_INPUT, $ES_NUMBER))
	GUICtrlSetState(-1, ($WaitBeforeCapture = 1) ? $GUI_ENABLE : $GUI_DISABLE)
	GUICtrlSetLimit(-1, 3, 1)
	GUICtrlCreateLabel('seconds', $iLeft_Base + 185, 352)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	Local $UseAlternativeCapture_CB = GUICtrlCreateCheckbox("Use alternative capture Mode", $iLeft_Base + 20, 375)
	GUICtrlSetState(-1, ($UseAlternativeCapture = 1) ? $GUI_CHECKED : $GUI_UNCHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	GUICtrlSetTip(-1, "Uses clipboard to capture images")
	
	#EndRegion Capture Mode Preferences
	
	#Region HotKeys Preferences
	
	Local $iHotKeys_TVItem = _GUICtrlTreeViewTab_CreateTabItem($aImage_Indxs[$iHotKeys_Indx][0], $iTreeViewTab)
	GUICtrlSetColor(-1, $GUI_TVItem_Color)
	GUICtrlSetImage(-1, $Icons_Library_Path, $aImage_Indxs[$iHotKeys_Indx][1])
	
	GUICtrlCreateIcon($Icons_Library_Path, $aImage_Indxs[$iHotKeys_Indx][1], $iLeft_Base + 20, 10, 32, 32)
	GUICtrlCreateLabel($aImage_Indxs[$iHotKeys_Indx][0], $iLeft_Base + 60, 10, 300, 40)
	GUICtrlSetColor(-1, $GUI_GrpTxt_Color)
	GUICtrlSetFont(-1, 12, 800, 0, 'Georgia')
	
	GUICtrlCreateLabel("Full Screen Capture:", $iLeft_Base + 20, 90, -1, 20)
	Local $hFullScreen_HotKey = _GUICtrlHotkey_Create($hSettings_GUI, $iLeft_Base + 150, 88)
	_GUICtrlHotkey_SetRules($hFullScreen_HotKey, $HKCOMB_NONE, BitOR($HOTKEYF_SHIFT, $HOTKEYF_CONTROL))
	_GUICtrlHotkey_SetHotkey($hFullScreen_HotKey, $sFullScreen_HK)
	_GUICtrlTreeViewTab_AddExternalControl($iTreeViewTab, $iHotKeys_TVItem, $hFullScreen_HotKey)
	
	GUICtrlCreateLabel("Window Capture:", $iLeft_Base + 20, 170, -1, 20)
	Local $hWindow_HotKey = _GUICtrlHotkey_Create($hSettings_GUI, $iLeft_Base + 150, 168)
	_GUICtrlHotkey_SetRules($hWindow_HotKey, $HKCOMB_NONE, BitOR($HOTKEYF_SHIFT, $HOTKEYF_CONTROL))
	_GUICtrlHotkey_SetHotkey($hWindow_HotKey, $sWindow_HK)
	_GUICtrlTreeViewTab_AddExternalControl($iTreeViewTab, $iHotKeys_TVItem, $hWindow_HotKey)
	
	GUICtrlCreateLabel("Selection Capture:", $iLeft_Base + 20, 250, -1, 20)
	Local $hSelection_HotKey = _GUICtrlHotkey_Create($hSettings_GUI, $iLeft_Base + 150, 248)
	_GUICtrlHotkey_SetRules($hSelection_HotKey, $HKCOMB_NONE, BitOR($HOTKEYF_SHIFT, $HOTKEYF_CONTROL))
	_GUICtrlHotkey_SetHotkey($hSelection_HotKey, $sSelection_HK)
	_GUICtrlTreeViewTab_AddExternalControl($iTreeViewTab, $iHotKeys_TVItem, $hSelection_HotKey)
	
	#EndRegion HotKeys Preferences
	
	_GUICtrlTreeViewTab_CloseTab($iTreeViewTab)
	
	DllCall("uxtheme.dll", "none", "SetThemeAppProperties", "int", 3)
	
	Local $OK_Button = GUICtrlCreateButton("OK", 10, $iHeight - 30, 70, 20)
	Local $Cancel_Button = GUICtrlCreateButton("Cancel", 90, $iHeight - 30, 70, 20)
	
	GUISetState(@SW_SHOW, $hSettings_GUI)
	GUICtrlSetState($iMain_TVItem, BitOR($GUI_DEFBUTTON, $GUI_FOCUS))
	GUIRegisterMsg($WM_COMMAND, "WM_COMMAND")
	GUIRegisterMsg($WM_HSCROLL, "WM_HSCROLL")
	
	Switch $Last_Sttngs_TVItem
		Case 'Capturing'
			GUICtrlSetState($iCaptureMode_TVItem, $GUI_FOCUS)
		Case 'HotKeys'
			GUICtrlSetState($iHotKeys_TVItem, $GUI_FOCUS)
	EndSwitch
	
	While 1
		$nMsg = GUIGetMsg()
		
		Switch $nMsg
			Case $GUI_EVENT_CLOSE, $Cancel_Button
				_GUICtrlTreeViewTab_DestroyTab($iTreeViewTab)
				GUIDelete($hSettings_GUI)
				ExitLoop
			Case $PngImage_Radio, $GifImage_Radio
				GUICtrlSetState($JPG_Quality_Slider, $GUI_DISABLE)
				GUICtrlSetState($BMP_Format_Combo, $GUI_DISABLE)
			Case $JpgImage_Radio
				GUICtrlSetState($JPG_Quality_Slider, $GUI_ENABLE)
				GUICtrlSetState($BMP_Format_Combo, $GUI_DISABLE)
				ControlFocus($hSettings_GUI, "", $JPG_Quality_Slider)
			Case $JPG_Quality_Slider
				_GUICtrlSetData($JPG_Quality_Label, GUICtrlRead($JPG_Quality_Slider))
			Case $BmpImage_Radio
				GUICtrlSetState($BMP_Format_Combo, $GUI_ENABLE)
				GUICtrlSetState($JPG_Quality_Slider, $GUI_DISABLE)
				ControlFocus($hSettings_GUI, "", $BMP_Format_Combo)
			Case $SaveToFile_CB
				If GUICtrlRead($SaveToFile_CB) = $GUI_UNCHECKED And _
					GUICtrlRead($OpenImageInEditor_CB) = $GUI_UNCHECKED And _
					GUICtrlRead($PrintImage_CB) = $GUI_UNCHECKED And _
					GUICtrlRead($UploadImage_CB) = $GUI_UNCHECKED And _
					GUICtrlRead($CopyImageToClipBoard_CB) = $GUI_UNCHECKED Then GUICtrlSetState($SaveToFile_CB, $GUI_CHECKED)
			Case $SilentSave_SelectPath_Button
				GUISetState(@SW_HIDE, $hSettings_GUI)
				
				Local $sInitDir = GUICtrlRead($SilentSave_Path_Input)
				Local $sSilentSave_SelectPath = FileSelectFolder($AppName & " - Select Silent Saving Path", "", 7, $sInitDir)
				
				If Not @error Then GUICtrlSetData($SilentSave_Path_Input, $sSilentSave_SelectPath)
				
				GUISetState(@SW_SHOW, $hSettings_GUI)
			Case $SilentSave_CB
				Local $iState = (GUICtrlRead($SilentSave_CB) = $GUI_CHECKED) ? $GUI_ENABLE : $GUI_DISABLE
				
				GUICtrlSetState($SaveToFile_CB, ($iState = $GUI_ENABLE) ? $GUI_DISABLE : $GUI_ENABLE)
				GUICtrlSetState($SilentSave_Path_Input, $iState)
				GUICtrlSetState($SilentSave_Name_Input, $iState)
				GUICtrlSetState($SilentSave_SelectPath_Button, $iState)
			Case $OpenImageInEditor_CB
				If GUICtrlRead($OpenImageInEditor_CB) = $GUI_CHECKED Then
					GUICtrlSetState($OpenImageInEditor_SelectPath_Button, $GUI_ENABLE)
					GUICtrlSetState($OpenImageInEditor_Input, $GUI_ENABLE)
				Else
					GUICtrlSetState($OpenImageInEditor_SelectPath_Button, $GUI_DISABLE)
					GUICtrlSetState($OpenImageInEditor_Input, $GUI_DISABLE)
					If GUICtrlRead($PrintImage_CB) = $GUI_UNCHECKED And _
						GUICtrlRead($UploadImage_CB) = $GUI_UNCHECKED And _
						GUICtrlRead($CopyImageToClipBoard_CB) = $GUI_UNCHECKED Then GUICtrlSetState($SaveToFile_CB, $GUI_CHECKED)
				EndIf
			Case $OpenImageInEditor_SelectPath_Button
				Local $sImage_Editor = GUICtrlRead($OpenImageInEditor_Input)
				Local $sInitDir = StringRegExpReplace($sImage_Editor, "\\[^\\]*$", "")
				Local $sFileName = StringRegExpReplace($sImage_Editor, "^.*\\", "")
				
				Local $sOpenImageInEditor_SelPath = _FileOpenDialog($AppName & " - Select Image Editor", $sInitDir, _
					"Application (*.exe)|*.exe", 3, $sFileName, 1, $hSettings_GUI)
				
				If Not @error Then
					GUICtrlSetData($OpenImageInEditor_Input, $sOpenImageInEditor_SelPath)
					FileChangeDir(@ScriptDir)
				EndIf
			Case $PrintImage_CB, $UploadImage_CB, $CopyImageToClipBoard_CB
				GUICtrlSetState($UploadImage_Combo, (GUICtrlRead($UploadImage_CB) = $GUI_CHECKED) ? $GUI_ENABLE : $GUI_DISABLE)
				
				If GUICtrlRead($PrintImage_CB) = $GUI_UNCHECKED And _
					GUICtrlRead($UploadImage_CB) = $GUI_UNCHECKED And _
					GUICtrlRead($CopyImageToClipBoard_CB) = $GUI_UNCHECKED And _
					GUICtrlRead($OpenImageInEditor_CB) = $GUI_UNCHECKED Then GUICtrlSetState($SaveToFile_CB, $GUI_CHECKED)
			Case $WaitBeforeCapture_CB
				GUICtrlSetState($WaitBeforeCapture_Input, (GUICtrlRead($WaitBeforeCapture_CB) = $GUI_CHECKED) ? $GUI_ENABLE : $GUI_DISABLE)
			Case $OK_Button
				;Tab Settings
				$Last_Sttngs_TVItem = _GUICtrlTreeView_GetText($iTreeViewTab, _GUICtrlTreeView_GetSelection($iTreeViewTab))
				
				;Main Prefs
				$Remember_LastSave_Format = Number(GUICtrlRead($Remember_LastSave_Format_CB) = $GUI_CHECKED)
				
				$Default_Save_Format = 1
				If GUICtrlRead($GifImage_Radio) = $GUI_CHECKED Then $Default_Save_Format = 2
				If GUICtrlRead($JpgImage_Radio) = $GUI_CHECKED Then $Default_Save_Format = 3
				If GUICtrlRead($BmpImage_Radio) = $GUI_CHECKED Then $Default_Save_Format = 4
				
				$JPG_Quality = Number(GUICtrlRead($JPG_Quality_Slider))
				$BMP_Format = GUICtrlRead($BMP_Format_Combo)
				
				For $i = 0 To 4
					If $aBMP_Format_List[$i] = $BMP_Format Then
						$BMP_Format = Number($i)
						ExitLoop
					EndIf
				Next
				
				If Not IsNumber($BMP_Format) Then $BMP_Format = 2
				
				$SaveHistory = Number(GUICtrlRead($SaveHistory_CB) = $GUI_CHECKED)
				
				;Save Mode Prefs
				$SaveToFile = Number(GUICtrlRead($SaveToFile_CB) = $GUI_CHECKED)
				$Silent_Save = Number(GUICtrlRead($SilentSave_CB) = $GUI_CHECKED)
				$Silent_Save_Path = _StringReplaceUnsupported(GUICtrlRead($SilentSave_Path_Input), '[\*\?/\|:<>"]', '_', 2)
				$Silent_Save_FileName = _StringReplaceUnsupported(GUICtrlRead($SilentSave_Name_Input))
				
				If $Silent_Save_Path = "" Then $Silent_Save_Path = $Def_Silent_Save_Path
				If $Silent_Save_FileName = "" Then $Silent_Save_FileName = $Def_Silent_Save_FileName
				
				$SelectActionAfterCapture = Number(GUICtrlRead($SelectActionAfterCapture_CB) = $GUI_CHECKED)
				
				$OpenImageInEditor = Number(GUICtrlRead($OpenImageInEditor_CB) = $GUI_CHECKED)
				$ImageEditorPath = GUICtrlRead($OpenImageInEditor_Input)
				If $ImageEditorPath = "" Then $ImageEditorPath = $Def_ImageEditorPath
				
				$PrintImage = Number(GUICtrlRead($PrintImage_CB) = $GUI_CHECKED)
				$UploadImage = Number(GUICtrlRead($UploadImage_CB) = $GUI_CHECKED)
				$UploadImage_Host = GUICtrlRead($UploadImage_Combo)
				$CopyImageToClipBoard = Number(GUICtrlRead($CopyImageToClipBoard_CB) = $GUI_CHECKED)
				$WaitBeforeCapture = Number(GUICtrlRead($WaitBeforeCapture_CB) = $GUI_CHECKED)
				$WaitBeforeCapture_Secs = Int(GUICtrlRead($WaitBeforeCapture_Input))
				$UseAlternativeCapture = Number(GUICtrlRead($UseAlternativeCapture_CB) = $GUI_CHECKED)
				
				;HotKes Prefs
				$sFullScreen_HK = _GUICtrlHotkey_GetHotkey($hFullScreen_HotKey)
				$sWindow_HK = _GUICtrlHotkey_GetHotkey($hWindow_HotKey)
				$sSelection_HK = _GUICtrlHotkey_GetHotkey($hSelection_HotKey)
				
				;Save Settings
				If GUICtrlRead($AutorunWithWin_CB) = $GUI_CHECKED Then
					RegWrite("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", $AppName, "REG_SZ", FileGetShortName(@ScriptFullPath))
				Else
					RegDelete("HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run", $AppName)
				EndIf
				
				IniWrite($ConfigFile, "Main Prefs", "Settings Last Tab", $Last_Sttngs_TVItem)
				IniWrite($ConfigFile, "Main Prefs", "Save Capture History", $SaveHistory)
				IniWrite($ConfigFile, "Main Prefs", "Save To File", $SaveToFile)
				
				IniWrite($ConfigFile, "Main Prefs", "Select Action After Capture", $SelectActionAfterCapture)
				
				IniWrite($ConfigFile, "Main Prefs", "Open Image In Editor", $OpenImageInEditor)
				IniWrite($ConfigFile, "Main Prefs", "Image Editor", $ImageEditorPath)
				
				IniWrite($ConfigFile, "Main Prefs", "Print Image", $PrintImage)
				IniWrite($ConfigFile, "Main Prefs", "Upload Image", $UploadImage)
				IniWrite($ConfigFile, "Main Prefs", "Upload Image Host", $UploadImage_Host)
				IniWrite($ConfigFile, "Main Prefs", "Copy Image To ClipBoard", $CopyImageToClipBoard)
				IniWrite($ConfigFile, "Main Prefs", "Wait Before Capturing", $WaitBeforeCapture)
				IniWrite($ConfigFile, "Main Prefs", "Wait Before Capturing Secs", $WaitBeforeCapture_Secs)
				IniWrite($ConfigFile, "Main Prefs", "Use Alternative Capture", $UseAlternativeCapture)
				
				IniWrite($ConfigFile, "Silent Save Prefs", "Silent Save", $Silent_Save)
				IniWrite($ConfigFile, "Silent Save Prefs", "Silent Save Path", $Silent_Save_Path)
				IniWrite($ConfigFile, "Silent Save Prefs", "Silent Save File Name", $Silent_Save_FileName)
				
				IniWrite($ConfigFile, "Image Format Prefs", "Default Image Format", $Default_Save_Format)
				IniWrite($ConfigFile, "Image Format Prefs", "Remember Last Image Format", $Remember_LastSave_Format)
				
				IniWrite($ConfigFile, "Image Format Prefs", "JPG Quality", $JPG_Quality)
				IniWrite($ConfigFile, "Image Format Prefs", "BMP Format", $BMP_Format)
				
				IniWrite($ConfigFile, "HotKyes Prefs", "FullScreen HotKey", $sFullScreen_HK)
				IniWrite($ConfigFile, "HotKyes Prefs", "Window HotKey", $sWindow_HK)
				IniWrite($ConfigFile, "HotKyes Prefs", "Selection HotKey", $sSelection_HK)
				
				$sFHK_TrayText = ($sFullScreen_HK <> "") ? @TAB & "(" & _GetHotKeyTrueValue($sFullScreen_HK) & ")" : ""
				$sWHK_TrayText = ($sWindow_HK <> "") ? @TAB & "(" & _GetHotKeyTrueValue($sWindow_HK) & ")" : ""
				$sSHK_TrayText = ($sSelection_HK <> "") ? @TAB & "(" & _GetHotKeyTrueValue($sSelection_HK) & ")" : ""
				
				_TrayItemSetText($FullScreenCapture_TrayItem, "FullScreen Capture" & $sFHK_TrayText)
				_TrayItemSetText($WindowCapture_TrayItem, "Window Capture" & $sWHK_TrayText)
				_TrayItemSetText($SelectionCapture_TrayItem, "Selection Capture" & $sSHK_TrayText)
				
				_ScreenCapture_SetJPGQuality($JPG_Quality)
				_ScreenCapture_SetBMPFormat($BMP_Format)
				
				_GUICtrlTreeViewTab_DestroyTab($iTreeViewTab)
				GUIDelete($hSettings_GUI)
				ExitLoop
		EndSwitch
	WEnd
	
	GUIRegisterMsg($WM_COMMAND, "")
	GUIRegisterMsg($WM_HSCROLL, "")
	Opt("GUIOnEventMode", 1)
EndFunc

Func History_Dialog()
	Local $aFS_Files = _FileListToArray($History_Path & '\FullScreen', '*.*', 1, True)
	Local $aWnd_Files = _FileListToArray($History_Path & '\Window', '*.*', 1, True)
	Local $aSel_Files = _FileListToArray($History_Path & '\Selection', '*.*', 1, True)
	
	If Not IsArray($aFS_Files) And Not IsArray($aWnd_Files) And Not IsArray($aSel_Files) Then
		MsgBox(64, $AppName & ' - Error', 'The History is empty!')
		Return
	EndIf
	
	Opt("GUIOnEventMode", 0)
	
	Local $iWidth = 600, $iHeight = 660
	Local $iLeft_Base = 20, $iLV_Width = $iWidth - ($iLeft_Base + 20)
	
	$hHistory_GUI = GUICreate($AppName & " - History", $iWidth, $iHeight, -1, -1, -1, BitOR($WS_EX_APPWINDOW, $WS_EX_TOOLWINDOW))
	GUISetIcon($Icons_Library_Path, 0, $hHistory_GUI)
	GUISetBkColor($GUI_Bk_Color, $hHistory_GUI)
	
	DllCall("uxtheme.dll", "none", "SetThemeAppProperties", "int", 0)
	
	$iTab = GUICtrlCreateTab(10, 10, $iWidth - 20, 300, -1, BitOR($WS_EX_STATICEDGE, $WS_EX_CLIENTEDGE))
	
	$iFS_TabItem = GUICtrlCreateTabItem("FullScreen")
	GUICtrlSetImage(-1, $Icons_Library_Path, 5)
	History_AddLV_Proc($aFS_Files, $iWidth, $iHeight, $iLeft_Base, $iLV_Width)
	
	$iWnd_TabItem = GUICtrlCreateTabItem("Window")
	GUICtrlSetImage(-1, $Icons_Library_Path, 6)
	History_AddLV_Proc($aWnd_Files, $iWidth, $iHeight, $iLeft_Base, $iLV_Width)
	
	$iSel_TabItem = GUICtrlCreateTabItem("Selection")
	GUICtrlSetImage(-1, $Icons_Library_Path, 7)
	History_AddLV_Proc($aSel_Files, $iWidth, $iHeight, $iLeft_Base, $iLV_Width)
	
	GUICtrlCreateTabItem("")
	
	GUICtrlCreateLabel('* Double click to open the image', $iLeft_Base, 320, -1, 20)
	GUICtrlSetColor(-1, $GUI_TipTxt_Color)
	
	GUICtrlCreateGroup("Preview", ($iWidth / 2) - 130, 340, 255, $iHeight - 390)
	GUICtrlSetColor(-1, $GUI_GrpTxt_Color)
	$iHistoryPreview_Pic = GUICtrlCreatePic("", ($iWidth / 2) - 120, 360, 230, $iHeight - 420, -1, $WS_EX_DLGMODALFRAME)
	GUICtrlSetImage($iHistoryPreview_Pic, "")
	
	DllCall("uxtheme.dll", "none", "SetThemeAppProperties", "int", 3)
	
	GUICtrlCreateLabel('', $iLeft_Base - 10, $iHeight - 40, $iWidth - $iLeft_Base, 2, $SS_SUNKEN)
	
	$iClose_Button = GUICtrlCreateButton("Close", 10, $iHeight - 30, 60, 20)
	$iClearHistory_Button = GUICtrlCreateButton("Clear History", 80, $iHeight - 30, 80, 20)
	
	GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")
	GUISetState(@SW_SHOW, $hHistory_GUI)
	
	While 1
		$nMsg = GUIGetMsg()
		
		Switch $nMsg
			Case $GUI_EVENT_CLOSE, $iClose_Button
				GUIDelete($hHistory_GUI)
				ExitLoop
			Case $iClearHistory_Button
				Local $sTabItemText = _GUICtrlTab_GetItemText($iTab, GUICtrlRead($iTab))
				
				If MsgBox(256+52, 'Attention', 'Are you sure, clear [' & $sTabItemText & '] history?', 0, $hHistory_GUI) = 6 Then
					If $sTabItemText <> "" Then
						DirRemove($History_Path & "\" & $sTabItemText, 1)
					EndIf
					
					_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle(GUICtrlRead($iTab, 1) + 1))
					GUICtrlSetImage($iHistoryPreview_Pic, "")
				EndIf
			Case $iTab
				Local $iTabItem = GUICtrlRead($iTab, 1)
				Local $iIndex = _GUICtrlListView_GetSelectedIndices($iTabItem + 1)
				Local $sPath = _GUICtrlListView_GetItemText($iTabItem + 1, Int($iIndex), 2)
				
				If $iIndex Then
					Local $hBMP = _BMPGetImage($sPath, 230, BitOR(0xFF000000, $GUI_Bk_Color))
					_BMPToPicControl($iHistoryPreview_Pic, $hBMP, 1)
					GUICtrlSetStyle($iHistoryPreview_Pic, -1, $WS_EX_DLGMODALFRAME)
				Else
					GUICtrlSetImage($iHistoryPreview_Pic, "")
				EndIf
		EndSwitch
	WEnd
	
	Opt("GUIOnEventMode", 1)
	GUIRegisterMsg($WM_NOTIFY, "")
EndFunc

Func History_AddLV_Proc($aFiles, $iWidth, $iHeight, $iLeft_Base, $iLV_Width)
	Local $iLV = GUICtrlCreateListView("Name|Size|Path", $iLeft_Base, 40, $iLV_Width, 260, BitOR($GUI_SS_DEFAULT_LISTVIEW, $LVS_NOSORTHEADER))
	Local $hLV = GUICtrlGetHandle($iLV)
	
	_GUICtrlListView_SetColumnWidth($hLV, 0, $iLV_Width - ($iLV_Width / 3))
	_GUICtrlListView_HideColumn($hLV, 2)
	
	If Not IsArray($aFiles) Or $aFiles[0] = 0 Then
		Return
	EndIf
	
	_ArraySortByFileDate($aFiles, 1, 1)
	
	Local $aDate, $sDate, $sSize, $iCurrent_GroupID
	Local $aDates[1][2], $iDate_Indx
	
	_GUICtrlListView_EnableGroupView($hLV)
	
	For $i = 1 To UBound($aFiles) - 1
		$aDate = FileGetTime($aFiles[$i], $FT_MODIFIED)
		$sDate = $aDate[2] & '/' & $aDate[1] & '/' & $aDate[0]
		$sSize = _StringGetFormattedSize(FileGetSize($aFiles[$i]))
		
		GUICtrlCreateListViewItem(StringRegExpReplace($aFiles[$i], "^.*\\", "") & '|' & $sSize & '|' & $aFiles[$i], $iLV)
		GUICtrlSetImage(-1, $Icons_Library_Path, 11)
		
		$iDate_Indx = _ArraySearch($aDates, $sDate, 1, 0, 0, 0, 1, 0)
		
		If $iDate_Indx = -1 Then
			$iCurrent_GroupID = $i
			
			$aDates[0][0] += 1
			ReDim $aDates[$aDates[0][0]+1][2]
			
			$aDates[$aDates[0][0]][0] = $sDate
			$aDates[$aDates[0][0]][1] = $iCurrent_GroupID
			
			_GUICtrlListView_InsertGroup($hLV, $i-1, $iCurrent_GroupID, $sDate, 1)
			_GUICtrlListView_SetGroupInfo($hLV, $iCurrent_GroupID, $sDate, 1, $LVGS_COLLAPSIBLE)
		Else
			$iCurrent_GroupID = $aDates[$iDate_Indx][1]
		EndIf
		
		_GUICtrlListView_SetItemGroupID($hLV, $i-1, $iCurrent_GroupID)
	Next
	
	_GUICtrlListView_HideColumn($hLV, 2)
EndFunc

Func TrayCallBack_Proc($nID, $nMsg)
	If $nMsg = $WM_LBUTTONDBLCLK Then $ShowSettings = True
EndFunc

Func Tray_Events()
	_TrayIconSetState(-1, 2)
	HotKeysSet_Toggle_Proc(0)
	
	Switch @GUI_CtrlId
		Case $GUI_EVENT_PRIMARYDOWN, $Settings_TrayItem
			Settings_Dialog()
		Case $About_TrayItem
			Local $aHyperLinks[3], $aData[5]
			Local $sTitle = "About Info"
			
			$aData[0] = $AppName
			$aData[1] = "Version: " & @CRLF & $AppVersion
			$aData[2] = _
				"Credits:(Georgia,14," & $GUI_GrpTxt_Color & ")\n\n\n\n" & _
				"Holger Kotsch:\nModernMenu.au3 Module(Impact,10)\n\n" & _
				"A.Melnichuk (amel27):\n_FileSaveDialog(), _FileOpenDialog()(Impact,10)\n\n" & _
				"Mat:\nGUIHotkey.au3(Impact,10)\n\n" & _
				"wakillon:\niUploader.au3 functions(Impact,10)\n\n\n\n\n" & _
				"[And others...](Georgia,12," & $GUI_GrpTxt_Color & ")\n\n" & _
				"Dimon:\nMain Tester(Impact,10)\n\n" & _
				"AutoIt Dev Team:\nAutoIt v3 :-)(Impact,10)"
			$aData[3] = $CopyRight_Str
			$aData[4] = "Play sound"
			
			$aHyperLinks[0] = UBound($aHyperLinks) - 1
			$aHyperLinks[1] = "CreatoR's Lab|http://creator-lab.ucoz.ru"
			$aHyperLinks[2] = "AutoIt Russian Community|http://autoit-script.ru"
			
			GUIRegisterMsg($WM_LBUTTONDOWN, '')
			_AboutBox($sTitle, $aData, $aHyperLinks, 0, $Icons_Library_Path, 0x0000FF, $GUI_Bk_Color)
			GUIRegisterMsg($WM_LBUTTONDOWN, 'WM_LBUTTONDOWN')
		Case $FullScreenCapture_TrayItem
			FullScreen_Capture_Proc()
		Case $WindowCapture_TrayItem
			Window_Capture_Proc()
		Case $SelectionCapture_TrayItem
			Selection_Capture_Proc()
		Case $CaptureHistory_TrayItem
			History_Dialog()
		Case $Exit_TrayItem
			QuitApp()
	EndSwitch
	
	HotKeysSet_Toggle_Proc(1)
	_TrayIconSetState(-1, 1)
EndFunc

Func HotKeys_Events()
	HotKeysSet_Toggle_Proc(0)
	_TrayIconSetState(-1, 2)
	
	Switch @HotKeyPressed
		Case $sFullScreen_HK
			FullScreen_Capture_Proc()
		Case $sWindow_HK
			Window_Capture_Proc()
		Case $sSelection_HK
			Selection_Capture_Proc()
	EndSwitch
	
	HotKeysSet_Toggle_Proc(1)
	_TrayIconSetState(-1, 1)
EndFunc

Func HotKeysSet_Toggle_Proc($iFlag = 0)
	If $iFlag = 0 Then
		HotKeySet($sFullScreen_HK)
		HotKeySet($sWindow_HK)
		HotKeySet($sSelection_HK)
	Else
		HotKeySet($sFullScreen_HK, "HotKeys_Events")
		HotKeySet($sWindow_HK, "HotKeys_Events")
		HotKeySet($sSelection_HK, "HotKeys_Events")
	EndIf
EndFunc

Func FullScreen_Capture_Proc()
	CaptureSave_Proc(1, "Full Screen")
EndFunc

Func Window_Capture_Proc()
	Local $sImgFile
	Local $hUser32Dll = DllOpen("user32.dll")
	Local $hLast_Control = -1
	Local $hWinCtrl = -1
	Local $IsCapture = False
	
	Local Const $WH_MOUSE_LL = 14

	Local $hKey_Proc = DllCallbackRegister("_Mouse_Handler", "int", "int;ptr;ptr;int")
	Local $hModule = DllCall("kernel32.dll", "hwnd", "GetModuleHandle", "int", 0)
	Local $hHook = DllCall($hUser32Dll, "hwnd", "SetWindowsHookEx", "int", $WH_MOUSE_LL, _
		"ptr", DllCallbackGetPtr($hKey_Proc), "hwnd", $hModule[0], "dword", 0)
	
	While 1
		Check_Highlight_Controls_Proc($hSquare_GUI, $hLast_Control)
		_IdleWait()
		
		If _IsPressed("0D", $hUser32Dll) Or $iPrimaryMouseClicked Then
			GUIDeleteSquare($hSquare_GUI)
			$hWinCtrl = $hLast_Control
			If $hWinCtrl <= 0 Then $hWinCtrl = _Get_Hovered_Handle()
			
			$IsCapture = True
			ExitLoop
		EndIf
		
		If _IsPressed("1B", $hUser32Dll) Then
			GUIDeleteSquare($hSquare_GUI)
			ExitLoop
		EndIf
	WEnd
	
	DllCall($hUser32Dll, "int", "UnhookWindowsHookEx", "hwnd", $hHook[0])
	DllCallbackFree($hKey_Proc)
	DllClose($hUser32Dll)
	
	$iPrimaryMouseClicked = False
	
	If $IsCapture And IsHWnd($hWinCtrl) Then CaptureSave_Proc(2, "Window", $hWinCtrl)
EndFunc

Func Selection_Capture_Proc()
	Opt("GUIOnEventMode", 0)
	
	Local $IsCapture = False
	Local $aPass_Coords[4]
	
	$hSelection_GUI = GUICreate($AppName & " - Capture Selected Area", 400, 300, -1, -1, _
		BitOR($WS_SIZEBOX, $WS_POPUP), BitOR($WS_EX_DLGMODALFRAME, $WS_EX_DLGMODALFRAME, $WS_EX_CLIENTEDGE, $WS_EX_TOPMOST, $WS_EX_TOOLWINDOW))
	GUISetBkColor(0x00FF00)
	WinSetTrans($hSelection_GUI, "", 30)
	
	ToolTip("Double Click on the selection to Capture", 0, 0, $AppName, 1, 4)
	
	Local $OK_Capture_Button = GUICtrlCreateButton("Capture", 10, 10, -1, -1, $BS_DEFPUSHBUTTON)
	GUICtrlSetState(-1, $GUI_HIDE)
	
	Local $aSel_GUI_Pos = WinGetPos($hSelection_GUI)
	$hSquare_GUI = GUICreateSquare($aSel_GUI_Pos[0]+4, $aSel_GUI_Pos[1]+4, $aSel_GUI_Pos[2]-8, $aSel_GUI_Pos[3]-8, $Frame_Color)
	
	GUISetState(@SW_SHOWNOACTIVATE, $hSelection_GUI)
	GUISetState(@SW_SHOWNOACTIVATE, $hSquare_GUI)
	
	GUIRegisterMsg($WM_LBUTTONDBLCLK, "WM_LBUTTONDBLCLK")
	GUIRegisterMsg($WM_WINDOWPOSCHANGING, "WM_WINDOWPOSCHANGING")
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				GUIDelete($hSelection_GUI)
				GUIDelete($hSquare_GUI)
				
				ExitLoop
			Case $OK_Capture_Button
				GUIRegisterMsg($WM_WINDOWPOSCHANGING, "")
				ToolTip("")
				
				Local $aSelect_Coords = WinGetPos($hSelection_GUI)
				GUIDeleteSquare($hSquare_GUI)
				GUIDelete($hSelection_GUI)
				
				If IsArray($aSelect_Coords) Then
					Dim $aPass_Coords[4] = [$aSelect_Coords[0], $aSelect_Coords[1], $aSelect_Coords[0]+$aSelect_Coords[2], $aSelect_Coords[1]+$aSelect_Coords[3]]
					$IsCapture = True
				EndIf
				
				ExitLoop
		EndSwitch
	WEnd
	
	ToolTip("")
	GUIRegisterMsg($WM_LBUTTONDBLCLK, "")
	GUIRegisterMsg($WM_WINDOWPOSCHANGING, "")
	
	If $IsCapture Then CaptureSave_Proc(3, "Selection", $aPass_Coords)
	
	Opt("GuiOnEventMode", 1)
EndFunc

Func CaptureSave_Proc($iSaveMode, $sTitle_Sufix, $hWin_aCoords = 0)
	If $WaitBeforeCapture = 1 Then
		Sleep($WaitBeforeCapture_Secs * 1000)
	EndIf
	
	SoundPlay($Capture_Sound_Path, 0)
	
	$Default_Save_Format = Number($Default_Save_Format)
	
	Local $h_Win = $hWin_aCoords
	If Not IsHWnd($h_Win) Then $h_Win = WinGetHandle("")
	
	Local $sDef_Ext = "png"
	Local $sImgFile, $sSave_Name
	Local $iTemp_FileDelete = 0
	
	Local $hBitmap = 0
	
	Switch $iSaveMode
		Case 1 ;Full Screen
			If $UseAlternativeCapture = 1 Then
				Sleep(500) ;From some strange reason, the CaptureIt menu also captured with the fullscreen.
				$hBitmap = _ScreenCapture_CaptureEx("", False, 500)
			Else
				$hBitmap = _ScreenCapture_Capture("", 0, 0, @DesktopWidth, @DesktopHeight, False)
			EndIf
		Case 2 ;Window
			;WinActivate($h_Win)
			
			If Not _WinIsFullVisible($h_Win) And Not BitAND(WinGetState($h_Win), 32) Then
				$hBitmap = _ScreenCapture_CaptureBkWnd("", $hWin_aCoords)
			Else
				$hBitmap = _ScreenCapture_CaptureWndEx("", $hWin_aCoords, 0, 0, -1, -1, False)
			EndIf
		Case 3 ;Selection
			$hBitmap = _ScreenCapture_Capture("", $hWin_aCoords[0], $hWin_aCoords[1], $hWin_aCoords[2], $hWin_aCoords[3], False)
	EndSwitch
	
	Switch $Default_Save_Format
		Case 2
			$sDef_Ext = "gif"
		Case 3
			$sDef_Ext = "jpg"
		Case 4
			$sDef_Ext = "bmp"
	EndSwitch
	
	Local $sImgSaveMode = "FullScreen"
	If $iSaveMode = 2 Then $sImgSaveMode = "Window"
	If $iSaveMode = 3 Then $sImgSaveMode = "Selection"
	
	If $Silent_Save = 1 Then
		If Not _PathIsDir($Silent_Save_Path) And Not DirCreate($Silent_Save_Path) Then Return
		If $Silent_Save_FileName = "" Then $Silent_Save_FileName = "Captured_Image"
		
		$sSave_Name = StringFormat(_DateTimeStringFormat($Silent_Save_FileName), $sImgSaveMode)
		$sSave_Name = _GetNewFileName($sSave_Name & "." & $sDef_Ext, $Silent_Save_Path)
		
		$sImgFile = $Silent_Save_Path & "\" & $sSave_Name
	ElseIf $SaveToFile = 1 Then
		If $sTitle_Sufix = "Window" Then $h_Win = 0
		$sImgFile = SaveCapturedToFile_Proc($sTitle_Sufix)
		If @error Then Return
	Else
		$sImgFile = @TempDir & "\Captured_Image." & $sDef_Ext
		$iTemp_FileDelete = 1
	EndIf
	
	If $UseAlternativeCapture = 1 Then
		_GDIPlus_Startup()
		Local $hImage = _GDIPlus_BitmapCreateFromHBITMAP($hBitmap)
		_GDIPlus_ImageSaveToFile($hImage, $sImgFile)
		_GDIPlus_ImageDispose($hImage)
		_GDIPlus_Shutdown()
	Else
		_ScreenCapture_SaveImage($sImgFile, $hBitmap, True)
	EndIf
	
	If $SaveHistory = 1 Then
		Local $sDestPath = $History_Path & "\" & $sImgSaveMode
		Local $sFileName = StringRegExpReplace($sImgFile, "^.*\\", "")
		FileCopy($sImgFile, $sDestPath & "\" & _GetNewFileName($sFileName, $sDestPath), 9)
	EndIf
	
	Local $_Tmp_CopyImageToClipBoard = $CopyImageToClipBoard
	Local $_Tmp_OpenImageInEditor = $OpenImageInEditor
	Local $_Tmp_PrintImage = $PrintImage
	Local $_Tmp_UploadImage = $UploadImage
	
	If $SelectActionAfterCapture = 1 Then
		SelectActionAfterCapture_Dialog($_Tmp_CopyImageToClipBoard, $_Tmp_OpenImageInEditor, $_Tmp_PrintImage, $_Tmp_UploadImage)
	EndIf
	
	If $_Tmp_CopyImageToClipBoard = 1 Then
		_ClipBoard_Open(0)
		_ClipBoard_SetData($hBitmap, $CF_BITMAP)
		_ClipBoard_Close()
	EndIf
	
	If $_Tmp_OpenImageInEditor = 1 Then
		Local $sEditor = $ImageEditorPath
		Local $sImage = $sImgFile
		
		If StringLeft($sEditor, 12) = 'rundll32.exe' Then
			$sImage = StringRegExpReplace($sEditor, '(?i)^.*?rundll32\.exe (.*?)$', '\1') & ' ' & $sImage
			$sEditor = 'rundll32.exe'
		ElseIf StringLeft($sEditor, 10) = 'ImageView_' Then
			$sImage = 'shimgvw.dll,' & $sEditor & ' ' & $sImage
			$sEditor = 'rundll32.exe'
		ElseIf $sEditor = '' Then
			$sEditor = $sImage
			$sImage = ''
		Else
			$sImage = '"' & $sImage & '"'
		EndIf
		
		_ShellExecuteEx($sEditor, $sImage, "", "", @SW_MAXIMIZE)
		
		If @error Then
			Run($sEditor & " " & $sImage, "", @SW_MAXIMIZE)
		EndIf
		
		$iTemp_FileDelete = 0
	EndIf
	
	If $_Tmp_PrintImage = 1 Then Run('Rundll32.exe "' & @SystemDir & '\mshtml.dll",PrintHTML "' & $sImgFile & '"', @SystemDir)
	If $_Tmp_UploadImage = 1 Then UploadImage_Proc($sImgFile)
	If $iTemp_FileDelete Then FileDelete($sImgFile)
EndFunc

Func SaveCapturedToFile_Proc($sTitle_Sufix)
	Local $sInitPath = StringRegExpReplace($Captured_ImgFile, "\\[^\\]*$", "")
	Local $sFileName = StringRegExpReplace($Captured_ImgFile, "^.*\\", "")
	
	Local $sDef_Ext = "png"
	Local $sFormat_Filter = "PNG Image (*.png)|*.png|GIF Image (*.gif)|*.gif|JPEG Image (*.jpg)|*.jpg|BMP Image (*.bmp)|*.bmp|"
	$sFormat_Filter &= "Supported Image files (*.bmp, *.jpg, *.gif, *.png)|*.bmp;*.jpg;*.gif;*.png"
	
	Switch $Default_Save_Format
		Case 2
			$sDef_Ext = "gif"
		Case 3
			$sDef_Ext = "jpg"
		Case 4
			$sDef_Ext = "bmp"
	EndSwitch
	
	Local $hDummy_GUI = GUICreate("", 10, 10, 0, 0, -1, $WS_EX_TOPMOST)
	Local $sImgFile = _FileSaveDialog($AppName & " - Save Image as" & " [" & $sTitle_Sufix & "]", _
		$sInitPath, $sFormat_Filter, 18, $sFileName, $Default_Save_Format, $hDummy_GUI)
	Local $iError = @error
	
	GUIDelete($hDummy_GUI)
	If $iError Then Return SetError(1, 0, "")
	
	If Not StringRegExp($sImgFile, "(?i)\.(png|gif|jpg|bmp|)$") Then
		$sImgFile &= "." & $sDef_Ext
	EndIf
	
	If $Remember_LastSave_Format = 1 Then
		$Default_Save_Format = 1
		If StringRegExp($sImgFile, "(?i)\.(gif)$") Then $Default_Save_Format = 2
		If StringRegExp($sImgFile, "(?i)\.(jpg)$") Then $Default_Save_Format = 3
		If StringRegExp($sImgFile, "(?i)\.(bmp)$") Then $Default_Save_Format = 4
		
		IniWrite($ConfigFile, "Main Prefs", "Default Image Format", $Default_Save_Format)
	EndIf
	
	$Captured_ImgFile = $sImgFile
	IniWrite($ConfigFile, "Main Prefs", "Capture Image File", $sImgFile)
	
	Return $sImgFile
EndFunc

Func SelectActionAfterCapture_Dialog(ByRef $_Copy, ByRef $_OpenIn, ByRef $_Print, ByRef $_Upload)
	Opt("GUIOnEventMode", 0)
	HotKeysSet_Toggle_Proc(0)
	
	$hSelectAction_GUI = GUICreate($AppName & " - Select Action", 320, 200, -1, -1, -1, BitOR($WS_EX_APPWINDOW, $WS_EX_TOOLWINDOW))
	GUISetIcon($Icons_Library_Path, 0, $hSelectAction_GUI)
	GUISetBkColor($GUI_Bk_Color, $hSelectAction_GUI)
	
	GUICtrlCreateLabel("Select action with the captured image:", 20, 10, 300, 30)
	GUICtrlSetFont(-1, 9, 800)
	
	DllCall("uxtheme.dll", "none", "SetThemeAppProperties", "int", 0)
	
	$Copy_CB = GUICtrlCreateCheckbox('Copy to clipboard', 20, 35)
	GUICtrlSetState(-1, ($_Copy = 1) ? $GUI_CHECKED : $GUI_UNCHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	$OpenIn_CB = GUICtrlCreateCheckbox('Open in [' & StringRegExpReplace($ImageEditorPath, '^.*\\', '') & ']', 20, 65)
	GUICtrlSetState(-1, ($_OpenIn = 1) ? $GUI_CHECKED : $GUI_UNCHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	$Print_CB = GUICtrlCreateCheckbox('Print', 20, 95)
	GUICtrlSetState(-1, ($_Print = 1) ? $GUI_CHECKED : $GUI_UNCHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	$Upload_CB = GUICtrlCreateCheckbox('Upload to [' & $UploadImage_Host & ']', 20, 125)
	GUICtrlSetState(-1, ($_Upload = 1) ? $GUI_CHECKED : $GUI_UNCHECKED)
	GUICtrlSetColor(-1, $GUI_Txt_Color)
	
	DllCall("uxtheme.dll", "none", "SetThemeAppProperties", "int", 3)
	
	$OK_Button = GUICtrlCreateButton("OK", 20, 170, 70, 20)
	$Cancel_Button = GUICtrlCreateButton("Cancel", 100, 170, 70, 20)
	
	GUISetState(@SW_SHOW, $hSelectAction_GUI)
	
	While 1
		$nMsg = GUIGetMsg()
	
		Switch $nMsg
			Case $GUI_EVENT_CLOSE, $Cancel_Button
				$_Copy = 0
				$_OpenIn = 0
				$_Print = 0
				$_Upload = 0
				
				GUIDelete($hSelectAction_GUI)
				ExitLoop
			Case $OK_Button
				$_Copy = Int(GUICtrlRead($Copy_CB) = $GUI_CHECKED)
				$_OpenIn = Int(GUICtrlRead($OpenIn_CB) = $GUI_CHECKED)
				$_Print = Int(GUICtrlRead($Print_CB) = $GUI_CHECKED)
				$_Upload = Int(GUICtrlRead($Upload_CB) = $GUI_CHECKED)
				
				GUIDelete($hSelectAction_GUI)
				ExitLoop
		EndSwitch
	WEnd
	
	Opt("GUIOnEventMode", 1)
	HotKeysSet_Toggle_Proc(1)
EndFunc

Func UploadImage_Proc($sImageFile)
	If Not FileExists($sImageFile) Then Return
	
	Opt("GUIOnEventMode", 0)
	HotKeysSet_Toggle_Proc(0)
	_TrayIconSetState(-1, 2)
	
	Local $sImageFName = StringRegExpReplace($sImageFile, "^.*\\", "")
	Local $sDirect_Link = "", $sThumbnail_Link = ""
	Local $sFuncName = '_Host' & StringRegExpReplace($UploadImage_Host, '\.[^\.]+$', '')
	
	ProgressOn($AppName & ' - Image Upload', StringFormat('Uploading <%s>...', _GetShortString($sImageFName, 20)), 'Progress: 0%')
	
	Local $sResponse = Call($sFuncName & 'Upload', $sImageFile)
	Local $aLinks = Call($sFuncName & 'ExtractLinks', $sResponse)
	
	If Not IsArray($aLinks) Then
		$sDirect_Link = "[Upload Internal ERROR]"
		$sThumbnail_Link = "[Upload Internal ERROR]"
	Else
		$sDirect_Link = $aLinks[0]
		$sThumbnail_Link = $aLinks[1]
	EndIf
	
	ProgressOff()
	
	$hUploadImg_GUI = GUICreate($AppName & " - Upload Complete", 480, 170, -1, -1, -1, $WS_EX_TOPMOST)
	
	GUICtrlCreateLabel(StringFormat("File <%s> has been uploaded to [%s]", _GetShortString($sImageFName, 25), $UploadImage_Host), 20, 5, 440, 15)
	GUICtrlSetFont(-1, 8.5, 800)
	GUICtrlSetColor(-1, 0x0000FF)
	
	GUICtrlCreateLabel("Direct link to uploaded Image:", 20, 25, -1, 15)
	$Copy_Direct_Link_Button = GUICtrlCreateButton("Copy", 420, 40, 50, 20)
	$Copy_Direct_Link_Input = GUICtrlCreateInput($sDirect_Link, 20, 40, 390, 20, BitOR($ES_LEFT, $ES_AUTOHSCROLL, $ES_READONLY), $WS_EX_DLGMODALFRAME)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	
	GUICtrlCreateLabel("Thumbnail link (for forums):", 20, 85, -1, 15)
	$Copy_Thumbnail_Link_Button = GUICtrlCreateButton("Copy", 420, 100, 50, 20)
	$Copy_Thumbnail_Link_Input = GUICtrlCreateInput($sThumbnail_Link, 20, 100, 390, 20, BitOR($ES_LEFT, $ES_AUTOHSCROLL, $ES_READONLY), $WS_EX_DLGMODALFRAME)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	
	$Close_Button = GUICtrlCreateButton("Close", 20, 130, 60, 20)
	
	WinActivate("Active")
	GUISetState(@SW_SHOWNORMAL, $hUploadImg_GUI)
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE, $Close_Button
				GUIDelete($hUploadImg_GUI)
				ExitLoop
			Case $Copy_Direct_Link_Button
				ClipPut(GUICtrlRead($Copy_Direct_Link_Input))
			Case $Copy_Thumbnail_Link_Button
				ClipPut(GUICtrlRead($Copy_Thumbnail_Link_Input))
		EndSwitch
	WEnd
	
	Opt("GUIOnEventMode", 1)
	HotKeysSet_Toggle_Proc(1)
	_TrayIconSetState(-1, 1)
EndFunc

Func UploadImage_PrgrsCallback($iPrecent)
	ProgressSet($iPrecent, 'Progress: ' & $iPrecent & '%')
EndFunc

Func Check_Highlight_Controls_Proc(ByRef $hSquare_GUI, ByRef $hLast_Control)
	Local $hWinCtrl = _Get_Hovered_Handle()
	
	If $hWinCtrl <> 0 And $hWinCtrl <> $hLast_Control And $hWinCtrl <> $hSquare_GUI Then
		$hLast_Control = $hWinCtrl
		Local $aCtrlPos = WinGetPos($hWinCtrl)
		If @error Then Return
		
		GUIDeleteSquare($hSquare_GUI)
		$hSquare_GUI = GUICreateSquare($aCtrlPos[0], $aCtrlPos[1], $aCtrlPos[2], $aCtrlPos[3], $Frame_Color)
		GUISetState(@SW_SHOWNOACTIVATE, $hSquare_GUI)
	EndIf
EndFunc

Func _GUICtrlSetData($iCtrlID, $sData, $sDefault = "")
	If StringCompare(GUICtrlRead($iCtrlID, 1), $sData, 1) <> 0 Then GUICtrlSetData($iCtrlID, $sData, $sDefault)
EndFunc

Func GUICreateSquare($i_X = -1, $i_Y = -1, $i_W = -1, $i_H = -1, $sColor = $GUI_Bk_Color)
	Local $hSquare_GUI = GUICreate($AppName, $i_W, $i_H, $i_X, $i_Y, $WS_POPUP, BitOR($WS_EX_TOPMOST, $WS_EX_TOOLWINDOW))
	GUISetBkColor($sColor)
	_GUISetHole($hSquare_GUI, $Frame_Width, $Frame_Width, $i_W - ($Frame_Width * 2), $i_H - ($Frame_Width * 2))
	Return $hSquare_GUI
EndFunc

Func GUIDeleteSquare($hSquare_GUI)
	If IsHWnd($hSquare_GUI) Then
		GUIDelete($hSquare_GUI)
		$hSquare_GUI = -1
	EndIf
EndFunc

Func _GUISetHole($hWin, $i_X, $i_Y, $i_SizeW, $i_SizeH)
	Local $aWinPos, $Outer_Rgn, $Inner_Rgn, $Wh, $Combined_Rgn
	Local Const $RGN_DIFF = 4
	$aWinPos = WinGetPos($hWin)
	
	$Outer_Rgn = DllCall("gdi32.dll", "long", "CreateRectRgn", "long", 0, "long", 0, "long", $aWinPos[2], "long", $aWinPos[3])
	$Inner_Rgn = DllCall("gdi32.dll", "long", "CreateRectRgn", "long", $i_Y, "long", $i_Y, "long", $i_Y + $i_SizeW, "long", $i_Y + $i_SizeH)
	$Combined_Rgn = DllCall("gdi32.dll", "long", "CreateRectRgn", "long", 0, "long", 0, "long", 0, "long", 0)
	DllCall("gdi32.dll", "long", "CombineRgn", "long", $Combined_Rgn[0], "long", $Outer_Rgn[0], "long", $Inner_Rgn[0], "int", $RGN_DIFF)
	DllCall("user32.dll", "long", "SetWindowRgn", "hwnd", $hWin, "long", $Combined_Rgn[0], "int", 1)
EndFunc

Func _IdleWait($IdleSec = 0)
	Local $iSave, $stLastInput = DllStructCreate("uint;dword")
	DllStructSetData($stLastInput, 1, DllStructGetSize($stLastInput))
	DllCall("user32.dll", "int", "GetLastInputInfo", "ptr", DllStructGetPtr($stLastInput))
	Do
		$iSave = DllStructGetData($stLastInput, 2)
		Sleep(20)
		DllCall("user32.dll", "int", "GetLastInputInfo", "ptr", DllStructGetPtr($stLastInput))
	Until (DllStructGetData($stLastInput, 2) - $iSave) > $IdleSec
	Return DllStructGetData($stLastInput, 2) - $iSave
EndFunc

Func _Get_Hovered_Handle()
	Local $aRet = DllCall("user32.dll", "int", "WindowFromPoint", "long", MouseGetPos(0), "long", MouseGetPos(1))
	If Not IsArray($aRet) Then Return SetError(1, 0, 0)
	Return HWnd($aRet[0])
EndFunc

Func _GetHotKeyTrueValue($sHotKey)
	Local $sRet_HotKey = $sHotKey
	
	$sRet_HotKey = StringReplace($sRet_HotKey, "+", "+SHIFT+")
	$sRet_HotKey = StringReplace($sRet_HotKey, "^", "+CTRL+")
	$sRet_HotKey = StringReplace($sRet_HotKey, "!", "+ALT+")
	$sRet_HotKey = StringRegExpReplace($sRet_HotKey, "[\}\{]", "")
	
	$sRet_HotKey = StringStripWS($sRet_HotKey, 8)
	$sRet_HotKey = _StringStripChars($sRet_HotKey, "+", 3)
	$sRet_HotKey = StringRegExpReplace($sRet_HotKey, "\++", " + ")
	
	Return StringStripWS($sRet_HotKey, 3)
EndFunc

Func _GetMyPicturesPath()
	Local $sRegReadMPPath = RegRead("HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders", "My Pictures")
	If _PathIsDir($sRegReadMPPath) Then Return $sRegReadMPPath
	
	Local $sRetPath = ""
	Local $oShell = ObjCreate("Shell.Application")
	
	If IsObj($oShell) Then
		Local $oNameSpace = $oShell.NameSpace(0x27) ;$MY_PICTURES = 0x27
		
		If Not @error Then
			Local $oSelf = $oNameSpace.Self
			If Not @error Then $sRetPath = $oSelf.Path
			If _PathIsDir($sRetPath) Then Return $sRetPath
		EndIf
	EndIf
	
	Return @MyDocumentsDir
EndFunc

Func _GetNewFileName($sFileName, $sDir, $iExt_Mod = -1, $sDelim1 = -1, $sDelim2 = -2)
	If Not _PathIsDir($sDir) Then Return $sFileName
	If Not FileExists($sDir & "\" & $sFileName) Then Return $sFileName
	
	$sDir = StringRegExpReplace($sDir, "\\ *$", "")
	
	Local $sName = StringRegExpReplace($sFileName, "\.[^.]*$", "")
	If $iExt_Mod <> -1 Then $sName = StringRegExpReplace($sFileName, "\.[^.]*(\.[^.]*$|$)", "")
	
	Local $sExtn = StringMid($sFileName, StringLen($sName) + 1)
	Local $iCount = 1, $sRet_FileName = $sFileName
	
	While FileExists($sDir & "\" & $sRet_FileName)
		If $sDelim1 = -1 And $sDelim2 = -2 Then
			$sRet_FileName = $sName & " (" & $iCount & ")" & $sExtn
		ElseIf $sDelim1 <> -1 And $sDelim2 <> -2 Then
			$sRet_FileName = $sName & $sDelim1 & $iCount & $sDelim2 & $sExtn
		ElseIf $sDelim1 <> -1 And $sDelim2 = -2 Then
			$sRet_FileName = $sName & $sDelim1 & $iCount & $sExtn
		EndIf
		$iCount += 1
	WEnd
	
	Return $sRet_FileName
EndFunc

Func _GetShortString($sString, $iMax_Ret_Lenght = 30)
	If StringLen($sString) < $iMax_Ret_Lenght Then Return $sString
	
	If $iMax_Ret_Lenght <= 4 Then $iMax_Ret_Lenght = 5
	Local $iSide_Lenght = Round(($iMax_Ret_Lenght / 2) - 2, 0)
	
	Local $sLeft_Side = StringStripWS(StringLeft($sString, $iSide_Lenght), 3)
	Local $sRight_Side = StringStripWS(StringRight($sString, $iSide_Lenght), 3)
	
	Return $sLeft_Side & "...." & $sRight_Side
EndFunc

Func _GetToolTip_WinHandle($sTitle = "")
	Local $aWinList = WinList("[CLASS:tooltips_class32]")
	
	For $i = 1 To UBound($aWinList)-1
		If BitAND(WinGetState($aWinList[$i][1]), 2) And WinGetTitle($aWinList[$i][1]) = $sTitle Then Return $aWinList[$i][1]
	Next
	
	Return 0
EndFunc

Func _ArraySortByFileDate(ByRef $avArr, $iStart = 0, $iDesc = 0)
	If UBound($avArr) < 2 Then
		Return SetError(1)
	EndIf
	
	If $iStart < 0 Or $iStart > UBound($avArr) Then
		$iStart = 0
	EndIf
	
	Local $vVal1, $vVal2, $sDate1, $sDate2
	
	For $i = UBound($avArr)-1 To $iStart + 1 Step -1
		If Not FileExists($avArr[$i]) Then
			ContinueLoop
		EndIf
		
		$vVal1 = $avArr[$i]
		$vVal2 = $avArr[$i-1]
		
		$sDate1 = StringLeft(FileGetTime($vVal1, 0, 1), 8)
		$sDate2 = StringLeft(FileGetTime($vVal2, 0, 1), 8)
		
		If $sDate1 < $sDate2 Then
			$avArr[$i] = $vVal2
			$avArr[$i-1] = $vVal1
		EndIf
	Next
	
	If $iDesc = 1 Then
		_ArrayReverse($avArr, $iStart)
	EndIf
EndFunc

Func _DateTimeStringFormat($sDT_Format)
	Local $sFormat = StringRegExpReplace($sDT_Format, '(?is).*(\$.*\$).*', '\1')
	
	Local $sStamp = '<_>'
	
	While StringInStr($sFormat, $sStamp)
		$sStamp = '<' & Random(10000000, 99999999, 1) & '>'
	WEnd
	
	StringReplace($sFormat, "y", "")
	Local $iYear = StringRight(@YEAR, @extended)
	Local $iMounth = @MON
	Local $iDay = @MDAY
	Local $iHours = @HOUR
	Local $iMinutes = @MIN
	Local $iSeconds = @SEC

	$sFormat = StringRegExpReplace($sFormat, "(?i)(?:(d+|y+)(\W*)(mm)|(mm)(\W*)(d+|y+))", '\1\2' & $sStamp & '\5\6')
	If @extended Then $sFormat = StringReplace($sFormat, $sStamp, $iMounth)
	$sFormat = StringRegExpReplace($sFormat, "(?i)(?:(d+|y+)(\W*)(m)|(m)(\W*)(d+|y+))", '\1\2' & $sStamp & '\5\6')
	If @extended Then $sFormat = StringReplace($sFormat, $sStamp, $iMounth+0)
	
	$sFormat = StringRegExpReplace($sFormat, '(?i)y+', $iYear)
	
	$sFormat = StringReplace($sFormat, "mm", $iMinutes)
	$sFormat = StringReplace($sFormat, "m", $iMinutes+0)
	
	$sFormat = StringReplace($sFormat, "dd", $iDay)
	$sFormat = StringReplace($sFormat, "d", $iDay+0)
	
	$sFormat = StringReplace($sFormat, "hh", $iHours)
	$sFormat = StringReplace($sFormat, "h", $iHours+0)
	
	$sFormat = StringReplace($sFormat, "ss", $iSeconds)
	$sFormat = StringReplace($sFormat, "s", $iSeconds+0)
	
	$sFormat = StringRegExpReplace($sFormat, "\A\$+|\$+$", "")
	$sFormat = StringRegExpReplace($sDT_Format, '(?is)(\$.*\$)', $sFormat)
	
	Return $sFormat
EndFunc

Func _StringGetFormattedSize($iByteSize, $iRound = 2, $sRetFormat = -1)
	Local $asBytes[9] = [8, 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'] ;Last two unreachable ;)
	Local $iBytes_Val = 2 ^ 10
	
	If $iByteSize < $iBytes_Val Then
		Return $iByteSize & ' Bytes'
	EndIf
	
	Local $iRetFormat_IsString = IsString($sRetFormat)
	Local $iFor = 1, $iTo = 8, $iStep = 1
	
	If $iRetFormat_IsString Then
		If Not StringRegExp($sRetFormat, "\A(?i)(KB|MB|GB|TB|PB|EB|ZB|YB)\z") Then
			Return SetError(1, 0, $iByteSize)
		EndIf
	Else
		Local $iFor = 8, $iTo = 1, $iStep = -1
	EndIf
	
	For $i = $iFor To $iTo Step $iStep
		If ($iRetFormat_IsString And $sRetFormat = $asBytes[$i]) Or (Not $iRetFormat_IsString And $iByteSize >= $iBytes_Val ^ $i) Then
			Return Round($iByteSize / $iBytes_Val ^ $i, $iRound) & ' ' & $asBytes[$i]
		EndIf
	Next
EndFunc

Func _StringReplaceUnsupported($sString, $sPatern = '[\*\?\\/\|:<>"]', $sReplace = "_", $iTrimMode = 0)
	Switch $iTrimMode
		Case 0
			$sString = StringRegExpReplace($sString, $sPatern, $sReplace)
			Return StringRegExpReplace($sString, $sReplace & '+', $sReplace)
		Case Else
			Local $sPrefix = StringLeft($sString, $iTrimMode)
			$sString = StringTrimLeft($sString, $iTrimMode)
			$sString = StringRegExpReplace($sString, $sPatern, $sReplace)
			Return $sPrefix & StringRegExpReplace($sString, $sReplace & '+', $sReplace)
	EndSwitch
EndFunc

Func _StringStripChars($String, $SubString, $Flag = 0, $Count = 0)
	If StringLen($String) = 0 Then Return SetError(1, 0, $String)
	
	Local $GroupChar_a = '(', $GroupChar_b = ')'
	If $Count < 0 Then Local $GroupChar_a = '[', $GroupChar_b = ']'
	
	$SubString = StringRegExpReplace($SubString, '([][{}()|.?+*\\^])', '\\\1')
	Local $Pattern = '(?i)' & $GroupChar_a & $SubString & $GroupChar_b, $sCnt = '{1,'& $Count &'}'
	
	If $Count <= 0 Then $sCnt = '+'
	If $Flag <> 0 Then $Count = 0
	If $Flag = 1 Then $Pattern = '(?i)^' & $GroupChar_a & $SubString & $GroupChar_b & $sCnt
	If $Flag = 2 Then $Pattern = '(?i)' & $GroupChar_a & $SubString & $GroupChar_b & $sCnt & '$'
	If $Flag = 3 Then $Pattern = '(?i)^' & $GroupChar_a & $SubString & $GroupChar_b & $sCnt & '|' & _
		$GroupChar_a & $SubString & $GroupChar_b & $sCnt & '$'
	Return StringRegExpReplace($String, $Pattern, '', $Count)
EndFunc

Func _PathIsDir($sPath)
	Return StringInStr(FileGetAttrib($sPath), "D")
EndFunc

Func _ShellExecuteEx($sCmd, $Args = "", $sFolder = "", $Verb = "", $rState = @SW_SHOWNORMAL, $hWnd = 0)
	Local $struINFO = DllStructCreate("long;long;long;ptr;ptr;ptr;ptr;long;long;long;ptr;long;long;long;long")
	Local $struVerb = DllStructCreate("char[15];char")
	Local $struPath = DllStructCreate("char[255];char")
	Local $struArgs = DllStructCreate("char[255];char")
	Local $struWDir = DllStructCreate("char[255];char")
	
	DllStructSetData($struVerb, 1, $Verb)
	DllStructSetData($struPath, 1, $sCmd)
	DllStructSetData($struWDir, 1, $sFolder)
	DllStructSetData($struArgs, 1, $Args)

	DllStructSetData($struINFO, 1, DllStructGetSize($struINFO))
	DllStructSetData($struINFO, 2, BitOR(0xC, 0x40, 0x400))
	DllStructSetData($struINFO, 3, $hWnd)
	DllStructSetData($struINFO, 4, DllStructGetPtr($struVerb))
	DllStructSetData($struINFO, 5, DllStructGetPtr($struPath))
	DllStructSetData($struINFO, 6, DllStructGetPtr($struArgs))
	DllStructSetData($struINFO, 7, DllStructGetPtr($struWDir))
	DllStructSetData($struINFO, 8, $rState)

	Local $iRet = DllCall("shell32.dll", "int", "ShellExecuteEx", "ptr", DllStructGetPtr($struINFO))
	If Not IsArray($iRet) Or Not $iRet[0] Then Return SetError(2, 0, 0)
	
	Return 1
EndFunc

Func _FileSaveDialog($sTitle, $sInitDir, $sFilter = 'All (*.*)', $iOpt = 0, $sDefFile = '', $iDefFilter = 1, $hWnd = 0)
	Local $sWorkingDir = @WorkingDir
	Local $iFileLen = 65536 ; Max chars in returned string
	
	; API flags prepare
	Local $iFlag = BitOR(BitShift(BitAND($iOpt, 2), -10), BitShift(BitAND($iOpt, 16), 3))
	
	; Filter string to array convertion
	If Not StringInStr($sFilter, '|') Then $sFilter &= '|*.*'
	$sFilter = StringRegExpReplace($sFilter, '|+', '|')
	
	Local $asFLines = StringSplit($sFilter, '|')
	Local $i, $suFilter = ''

	For $i = 1 To $asFLines[0] Step 2
		If $i < $asFLines[0] Then
			$suFilter &= 'byte[' & StringLen($asFLines[$i]) + 1 & '];char[' & StringLen($asFLines[$i + 1]) + 1 & '];'
		EndIf
	Next
	
	; Create API structures
	Local $uOFN = DllStructCreate('dword;int;int;ptr;ptr;dword;dword;ptr;dword;ptr;int;ptr;ptr;dword;short;short;ptr;ptr;ptr;ptr;ptr;dword;dword')
	Local $usTitle = DllStructCreate('char[' & StringLen($sTitle) + 1 & ']')
	Local $usInitDir = DllStructCreate('char[' & StringLen($sInitDir) + 1 & ']')
	Local $usFilter = DllStructCreate($suFilter & 'byte')
	Local $usFile = DllStructCreate('char[' & $iFileLen & ']')
	Local $usExtn = DllStructCreate('char[1]')
	
	For $i = 1 To $asFLines[0]
		DllStructSetData($usFilter, $i, $asFLines[$i])
	Next
	
	; Set Data of API structures
	DllStructSetData($usTitle, 1, $sTitle)
	DllStructSetData($usInitDir, 1, $sInitDir)
	DllStructSetData($usFile, 1, $sDefFile)
	DllStructSetData($usExtn, 1, '')
	DllStructSetData($uOFN, 1, DllStructGetSize($uOFN))
	DllStructSetData($uOFN, 2, $hWnd)
	DllStructSetData($uOFN, 4, DllStructGetPtr($usFilter))
	DllStructSetData($uOFN, 7, $iDefFilter)
	DllStructSetData($uOFN, 8, DllStructGetPtr($usFile))
	DllStructSetData($uOFN, 9, $iFileLen)
	DllStructSetData($uOFN, 12, DllStructGetPtr($usInitDir))
	DllStructSetData($uOFN, 13, DllStructGetPtr($usTitle))
	DllStructSetData($uOFN, 14, $iFlag)
	DllStructSetData($uOFN, 17, DllStructGetPtr($usExtn))
	DllStructSetData($uOFN, 23, BitShift(BitAND($iOpt, 32), 5))
	
	; Call API function
	Local $aRet = DllCall('comdlg32.dll', 'int', 'GetSaveFileName', 'ptr', DllStructGetPtr($uOFN))
	FileChangeDir($sWorkingDir)
	
	If Not IsArray($aRet) Or Not $aRet[0] Then Return SetError(1, 0, "")
	
	;Return Results
	Local $sRet = StringStripWS(DllStructGetData($usFile, 1), 3)
	Return SetExtended(DllStructGetData($uOFN, 7), $sRet) ;@extended is the 1-based index of selected filter
EndFunc

Func _FileOpenDialog($sTitle, $sInitDir, $sFilter = 'All (*.*)|*.*', $iOpt = 0, $sDefFile = '', $iDefFilter = 1, $Main_GUI = 0)
	Local $sWorkingDir = @WorkingDir
	Local $iFileLen = 65536 ; Max chars in returned string
	
	; API flags prepare
	Local $iFlag = BitOR( _
		BitShift(BitAND($iOpt, 1), -12), BitShift(BitAND($iOpt, 2), -10), BitShift(BitAND($iOpt, 4), -7), _
		BitShift(BitAND($iOpt, 8), -10), BitShift(BitAND($iOpt, 4), -17))
	
	; Filter string to array convertion
	If Not StringInStr($sFilter, '|') Then $sFilter &= '|*.*'
	$sFilter = StringRegExpReplace($sFilter, '|+', '|')
	
	Local $asFLines = StringSplit($sFilter, '|')
	Local $i, $suFilter = ''

	For $i = 1 To $asFLines[0] Step 2
		If $i < $asFLines[0] Then
			$suFilter &= 'byte[' & StringLen($asFLines[$i]) + 1 & '];char[' & StringLen($asFLines[$i + 1]) + 1 & '];'
		EndIf
	Next
	
	; Create API structures
	Local $uOFN = DllStructCreate('dword;int;int;ptr;ptr;dword;dword;ptr;dword;ptr;int;ptr;ptr;dword;short;short;ptr;ptr;ptr;ptr;ptr;dword;dword')
	Local $usTitle = DllStructCreate('char[' & StringLen($sTitle) + 1 & ']')
	Local $usInitDir = DllStructCreate('char[' & StringLen($sInitDir) + 1 & ']')
	Local $usFilter = DllStructCreate($suFilter & 'byte')
	Local $usFile = DllStructCreate('char[' & $iFileLen & ']')
	Local $usExtn = DllStructCreate('char[1]')
	
	For $i = 1 To $asFLines[0]
		DllStructSetData($usFilter, $i, $asFLines[$i])
	Next
	
	; Set Data of API structures
	DllStructSetData($usTitle, 1, $sTitle)
	DllStructSetData($usInitDir, 1, $sInitDir)
	DllStructSetData($usFile, 1, $sDefFile)
	DllStructSetData($usExtn, 1, '')
	DllStructSetData($uOFN, 1, DllStructGetSize($uOFN))
	DllStructSetData($uOFN, 2, $Main_GUI)
	DllStructSetData($uOFN, 4, DllStructGetPtr($usFilter))
	DllStructSetData($uOFN, 7, $iDefFilter)
	DllStructSetData($uOFN, 8, DllStructGetPtr($usFile))
	DllStructSetData($uOFN, 9, $iFileLen)
	DllStructSetData($uOFN, 12, DllStructGetPtr($usInitDir))
	DllStructSetData($uOFN, 13, DllStructGetPtr($usTitle))
	DllStructSetData($uOFN, 14, $iFlag)
	DllStructSetData($uOFN, 17, DllStructGetPtr($usExtn))
	DllStructSetData($uOFN, 23, BitShift(BitAND($iOpt, 32), 5))
	
	; Call API function
	Local $aRet = DllCall('comdlg32.dll', 'int', 'GetOpenFileName', 'ptr', DllStructGetPtr($uOFN))
	FileChangeDir($sWorkingDir)
	
	If Not IsArray($aRet) Or Not $aRet[0] Then Return SetError(1, 0, "")
	
	If BitAND($iOpt, 4) Then
		$i = 1
		
		While 1
			If Binary(DllStructGetData($usFile, 1, $i)) = 0 Then
				If Binary(DllStructGetData($usFile, 1, $i + 1)) = 0 Then
					ExitLoop
				Else
					DllStructSetData($usFile, 1, '|', $i)
				EndIf
			EndIf
			
			$i += 1
		WEnd
	EndIf
	
	Local $sRet = StringStripWS(DllStructGetData($usFile, 1), 3)
	Return SetExtended(DllStructGetData($uOFN, 7), $sRet)
EndFunc

Func _Mouse_Handler($nCode, $wParam, $lParam, $iParam)
	If $iPrimaryMouseClicked Then Return 0
	
	Switch BitAND($wParam, 0xFFFF)
		Case 513 ;Primary Down
			$iPrimaryMouseClicked = True
			Return 1 ;Block default processing
	EndSwitch
	
	Return 0 ;Allow default processing
EndFunc

Func _WinIsFullVisible($hWin)
	Local $tRECT = _WinAPI_GetWorkArea()
	
	Local $iWidth = DllStructGetData($tRECT, 'Right') - DllStructGetData($tRECT, 'Left')
	Local $iHeight = DllStructGetData($tRECT, 'Bottom') - DllStructGetData($tRECT, 'Top')
	Local $iX = DllStructGetData($tRECT, 'Left')
	Local $iY = DllStructGetData($tRECT, 'Top')
	
	Local $aWinPos = WinGetPos($hWin)
	
	Return ($aWinPos[0]+2 > $iX) And ($aWinPos[0] + $aWinPos[2] < $iWidth) And ($aWinPos[1]+3 > $iY) And ($aWinPos[1] + $aWinPos[3]-2 < $iHeight)
EndFunc

Func _ScreenCapture_CaptureEx($sFile, $bActiveWindow = False, $iSleep = 0)
	Local $Result, $Timer, $aOld_Clip, $iFormat, $hImage, $hBitmap
	
	_ClipBoard_Open(0)
	
	Dim $aOld_Clip[_ClipBoard_CountFormats()+1][2]
	
	Do
		$iFormat = _ClipBoard_EnumFormats($iFormat)
		
		If $iFormat <> 0 Then
			$aOld_Clip[0][0] += 1
			$aOld_Clip[$aOld_Clip[0][0]][0] = _ClipBoard_GetData($iFormat)
			$aOld_Clip[$aOld_Clip[0][0]][1] = $iFormat
		EndIf
	Until $iFormat = 0
	
	_ClipBoard_Empty()
	_ClipBoard_Close()
	
	If $bActiveWindow Then
		Send('!{PRINTSCREEN}')
	Else
		Send('{PRINTSCREEN}')
	EndIf
	
	$Timer = TimerInit()
	
	While TimerDiff($Timer) < 1000
		_ClipBoard_Open(0)
		$hBitmap = _ClipBoard_GetDataEx($CF_BITMAP)
		_ClipBoard_Close()
		If $hBitmap Then ExitLoop
		Sleep(10)
	WEnd
	
	$hBitmap = DllCall('user32.dll', 'ptr', 'CopyImage', 'ptr', $hBitmap, 'int', 0, 'int', 0, 'int', 0, 'int', 0)
	If Not @error Then $hBitmap = $hBitmap[0]
	
	_ClipBoard_Open(0)
	
	For $i = 1 To $aOld_Clip[0][0]
		_ClipBoard_SetData($aOld_Clip[$i][0], $aOld_Clip[$i][1])
	Next
	
	_ClipBoard_Close()
	
	If $iSleep Then Sleep($iSleep)
	If Not $hBitmap Then Return 0
	
	If $sFile <> "" Then
		_GDIPlus_Startup()
		$hImage = _GDIPlus_BitmapCreateFromHBITMAP($hBitmap)
		$Result = _GDIPlus_ImageSaveToFile($hImage, $sFile)
		_GDIPlus_ImageDispose($hImage)
		_GDIPlus_Shutdown()
	Else
		$Result = $hBitmap
	EndIf
	
	Return $Result
EndFunc

Func _ScreenCapture_CaptureWndEx($sFileName, $hWnd, $iLeft = 0, $iTop = 0, $iRight = -1, $iBottom = -1, $fCursor = True)
	Local $tRect = _WinAPI_GetWindowRect($hWnd)
	Local $aWinClientSize, $aWinPos, $iBorder = 1
	
	If BitAND(WinGetState($hWnd), 32) Then ;window is maximized
		$aWinClientSize = WinGetClientSize($hWnd)
		$aWinPos = WinGetPos($hWnd)
		If Not @error Then $iBorder = ($aWinPos[2] - $aWinClientSize[0]) / 2
	EndIf
	
	$iLeft += DllStructGetData($tRect, "Left") + $iBorder
	$iTop += DllStructGetData($tRect, "Top") + $iBorder
	
	If $iRight = -1 Then $iRight = DllStructGetData($tRect, "Right") - DllStructGetData($tRect, "Left") - $iBorder
	If $iBottom = -1 Then $iBottom = DllStructGetData($tRect, "Bottom") - DllStructGetData($tRect, "Top") - $iBorder
	
	$iRight += DllStructGetData($tRect, "Left")
	$iBottom += DllStructGetData($tRect, "Top")
	
	If $iLeft > DllStructGetData($tRect, "Right") Then $iLeft = DllStructGetData($tRect, "Left")
	If $iTop > DllStructGetData($tRect, "Bottom") Then $iTop = DllStructGetData($tRect, "Top")
	If $iRight > DllStructGetData($tRect, "Right") Then $iRight = DllStructGetData($tRect, "Right")
	If $iBottom > DllStructGetData($tRect, "Bottom") Then $iBottom = DllStructGetData($tRect, "Bottom")
	
	Return _ScreenCapture_Capture($sFileName, $iLeft, $iTop, $iRight, $iBottom, $fCursor)
EndFunc

Func _ScreenCapture_CaptureBkWnd($sFileName, $hWnd, $iWidth = -1, $iHeight = -1)
    Local $iOpt_WWD, $hActive, $aPos, $iH, $iW, $hDDC, $hCDC, $hBMP
	Local $aWinClientSize, $aWinPos, $iBorder = 1
	
	If Not IsHWnd($hWnd) Then Return SetError(1, 0, 0)
	
	If Not BitAND(WinGetState($hWnd), 2) Then
		$iOpt_WWD = Opt("WinWaitDelay", 0)
		$hActive = WinGetHandle("[ACTIVE]")
		
		$aPos = WinGetPos($hWnd)
		WinMove($hWnd, "", -1500, -1500)
		WinSetState($hWnd, "", @SW_SHOW)
		WinActivate($hActive)
		WinWaitActive($hActive)
		
		Opt("WinWaitDelay", $iOpt_WWD)
	ElseIf BitAND(WinGetState($hWnd), 16) Then
		$iOpt_WWD = Opt("WinWaitDelay", 0)
		$hActive = WinGetHandle("[ACTIVE]")
		
		WinSetState($hWnd, "", @SW_RESTORE)
		WinActivate($hActive)
		WinWaitActive($hActive)
		
		Opt("WinWaitDelay", $iOpt_WWD)
	EndIf
	
	If BitAND(WinGetState($hWnd), 32) Then ;window is maximized
		$aWinClientSize = WinGetClientSize($hWnd)
		$aWinPos = WinGetPos($hWnd)
		If Not @error Then $iBorder = ($aWinPos[2] - $aWinClientSize[0]) / 2
	EndIf
	
    If $iWidth = -1 Then $iWidth = _WinAPI_GetWindowWidth($hWnd) - $iBorder
    If $iHeight = -1 Then $iHeight = _WinAPI_GetWindowHeight($hWnd) - $iBorder
	
    $hDDC = _WinAPI_GetDC($hWnd)
    $hCDC = _WinAPI_CreateCompatibleDC($hDDC)
    $hBMP = _WinAPI_CreateCompatibleBitmap($hDDC, $iWidth, $iHeight)
    _WinAPI_SelectObject($hCDC, $hBMP)
	
	DllCall("User32.dll", "int", "PrintWindow", "hwnd", $hWnd, "hwnd", $hCDC, "int", 0)
	_WinAPI_BitBlt($hCDC, 0, 0, 0, 0, $hDDC, 0, 0, 0x00330008)
	_WinAPI_ReleaseDC($hWnd, $hDDC)
	_WinAPI_DeleteDC($hCDC)
	
	If IsArray($aPos) Then
		WinMove($hWnd, "", $aPos[0], $aPos[1])
		WinSetState($hWnd, "", @SW_HIDE)
	ElseIf IsHWnd($hActive) Then
		WinSetState($hWnd, "", @SW_MINIMIZE)
	EndIf
	
	If $sFileName = "" Then Return $hBMP
	_ScreenCapture_SaveImage($sFileName, $hBMP, True)
EndFunc

Func _BMPGetImage($sFile, $iWH, $iBkClr = 0xFFFFFF)
    Local $hBmp1, $hBitmap, $hGraphic, $hImage, $iW, $iH, $aGS, $hBmp2
    
	_GDIPlus_Startup()
    $hBmp1 = _WinAPI_CreateBitmap($iWH, $iWH, 1, 32)
    $hBitmap = _GDIPlus_BitmapCreateFromHBITMAP($hBmp1)
    $hGraphic = _GDIPlus_ImageGetGraphicsContext($hBitmap)
    _WinAPI_DeleteObject($hBmp1)
    _GDIPlus_GraphicsClear($hGraphic, BitOR(0xFF000000, $iBkClr))
    $hImage = _GDIPlus_ImageLoadFromFile($sFile)
    $iW = _GDIPlus_ImageGetWidth($hImage)
    $iH = _GDIPlus_ImageGetHeight($hImage)
	
	Local $aGS[4]
	
    If $iW <= $iWH And $iH <= $iWH Then
        $aGS[2] = $iW
        $aGS[3] = $iH
        $aGS[0] = ($iWH - $aGS[2])/2
        $aGS[1] = ($iWH - $aGS[3])/2
    ElseIf $iW > $iH Then
        $aGS[2] = $iWH
        $aGS[3] = $iH/($iW/$iWH)
        $aGS[0] = 0
        $aGS[1] = ($iWH - $aGS[3])/2
    ElseIf $iW < $iH Then
        $aGS[2] = $iW/($iH/$iWH)
        $aGS[3] = $iWH
        $aGS[0] = ($iWH - $aGS[2])/2
        $aGS[1] = 0
    ElseIf $iW = $iH Then
        $aGS[2] = $iWH
        $aGS[3] = $iWH
        $aGS[0] = 0
        $aGS[1] = 0
    EndIf
	
    _GDIPlus_GraphicsDrawImageRect($hGraphic, $hImage, $aGS[0], $aGS[1], $aGS[2], $aGS[3])
    _GDIPlus_ImageDispose($hImage)
    _GDIPlus_GraphicsDispose($hGraphic)
    $hBmp2 = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hBitmap)
    _GDIPlus_BitmapDispose($hBitmap)
    _GDIPlus_Shutdown()
	
    Return $hBmp2
EndFunc

Func _BMPToPicControl($iCID, ByRef $hBmp, $iFlag = 0)
    Local Const $STM_SETIMAGE = 0x0172
    Local Const $IMAGE_BITMAP = 0
    Local $hOldBmp
    $hOldBmp = GUICtrlSendMsg($iCID, $STM_SETIMAGE, $IMAGE_BITMAP, $hBmp)
    If $hOldBmp Then _WinAPI_DeleteObject($hOldBmp)
    If $iFlag Then _WinAPI_DeleteObject($hBmp)
EndFunc

Func _GetResData($sRes)
	If @Compiled Then
		Return FileGetVersion(@AutoItExe, $sRes)
	EndIf
	
	Return StringStripWS(_StringBetween(FileRead(@ScriptFullPath), "#pragma compile(" & $sRes & ", '", "')" & @CR)[0], 3)
EndFunc

Func _GDIPlus_Validate()
	_GDIPlus_Startup()
	
	If @error Then
		MsgBox(262144+16, $AppName & ' - Error', StringFormat('GDIPlus error (%i)', @extended) & @CRLF & @CRLF & 'OK ==> EXIT')
		Exit
	EndIf
	
	_GDIPlus_Shutdown()
EndFunc

Func COM_Error_Handler()
	SetError(1)
EndFunc

Func WM_NOTIFY($hWnd, $iMsg, $iwParam, $ilParam)
	Local $hWndFrom, $iIDFrom, $iCode, $iItem, $tNMHDR
	
	$tNMHDR = DllStructCreate($tagNMHDR & ";int iItem;int iButton;ptr pitem", $ilParam)
	
	$hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
	$iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
	$iCode = DllStructGetData($tNMHDR, "Code")
	$iItem = DllStructGetData($tNMHDR, "iItem")
	
	Local $iIndex = _GUICtrlListView_GetSelectedIndices($hWndFrom)
	Local $sPath = _GUICtrlListView_GetItemText($hWndFrom, Int($iIndex), 2)
	
	Switch $iCode
		Case $NM_DBLCLK
			If $iIndex Then
				_ShellExecuteEx($sPath)
			EndIf
		Case $LVN_ITEMCHANGED
			If $iIndex Then
				Local $hBMP = _BMPGetImage($sPath, 230, BitOR(0xFF000000, $GUI_Bk_Color))
				_BMPToPicControl($iHistoryPreview_Pic, $hBMP, 1)
				GUICtrlSetStyle($iHistoryPreview_Pic, -1, $WS_EX_DLGMODALFRAME)
			Else
				GUICtrlSetImage($iHistoryPreview_Pic, "")
			EndIf
		Case $LVN_BEGINDRAG
			Return 0
		Case $HDN_ITEMCHANGING, $HDN_ITEMCHANGINGW
			If $iItem = 2 Then ;Path column
				Return 1
			EndIf
	EndSwitch
	
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_HSCROLL($hWndGUI, $MsgID, $wParam, $lParam)
	_GUICtrlSetData($JPG_Quality_Label, GUICtrlRead($JPG_Quality_Slider))
	
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_COMMAND($hWndGUI, $MsgID, $WParam, $LParam)
	Local $iIDFrom = BitAND($wParam, 0xFFFF) ; Low Word
    Local $iCode = BitShift($wParam, 16) ; Hi Word
	
	Switch $iCode
		Case 8
			GUICtrlSetState($iIDFrom, $GUI_HIDE)
			GUICtrlSetState($iIDFrom, $GUI_SHOW)
	EndSwitch
	
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_LBUTTONDOWN($hWnd, $iMsg, $wParam, $lParam)
	If $hWnd = $hSquare_GUI Then Return $GUI_RUNDEFMSG
	
	If BitAND(WinGetState($hWnd), 32) Then Return $GUI_RUNDEFMSG
	DllCall("user32.dll", "long", "SendMessage", "hwnd", $hWnd, "int", $WM_SYSCOMMAND, "int", 0xF009, "int", 0)
EndFunc

Func WM_LBUTTONDBLCLK($hWnd, $iMsg, $wParam, $lParam)
	ControlClick($hWnd, "", "Button1")
EndFunc

Func WM_WINDOWPOSCHANGING($hWnd, $iMsg, $wParam, $lParam)
	If $hWnd <> $hSelection_GUI Then Return $GUI_RUNDEFMSG
	
	Local $stWINDOWPOS = DllStructCreate("int[6];uint", $lParam)
    Local $iX = DllStructGetData($stWINDOWPOS, 1, 3)
    Local $iY = DllStructGetData($stWINDOWPOS, 1, 4)
    Local $iW = DllStructGetData($stWINDOWPOS, 1, 5)
    Local $iH = DllStructGetData($stWINDOWPOS, 1, 6)
	
	If IsHWnd($hSquare_GUI) Then
		GUIDeleteSquare($hSquare_GUI)
		
		If $iX+4 = -1 Then $iX -= 1
		If $iY+4 = -1 Then $iY -= 1
		
		$hSquare_GUI = GUICreateSquare($iX+4, $iY+4, $iW-8, $iH-8, $Frame_Color)
		GUISetState(@SW_SHOWNOACTIVATE, $hSquare_GUI)
	EndIf
	
	Local $aToolTip_Pos = WinGetPos(_GetToolTip_WinHandle("Double Click on the selection to Capture"))
	
	If UBound($aToolTip_Pos) > 3 Then
		Local $iToolTip_Width = $aToolTip_Pos[2] ;250
		Local $iToolTip_Height = $aToolTip_Pos[3] ;60
	Else
		Local $iToolTip_Width = 250
		Local $iToolTip_Height = 60
	EndIf
	
	If $iX > $iToolTip_Width Or $iY > $iToolTip_Height Then
		ToolTip("Double Click on the selection to Capture", 0, 0, $AppName, 1, 4)
	ElseIf $iX+$iW < @DesktopWidth-$iToolTip_Width Or $iY > $iToolTip_Height Then
		ToolTip("Double Click on the selection to Capture", @DesktopWidth-210, 0, $AppName, 1, 4)
	EndIf
	
	If $iY <= $iToolTip_Height And $iX <= $iToolTip_Width And $iX+$iW > @DesktopWidth-$iToolTip_Width Then ToolTip("")
EndFunc

Func WM_ENTEREXITMENULOOP($hWnd, $iMsg, $wParam, $lParam)
	Switch $iMsg
		Case $WM_ENTERMENULOOP
			HotKeysSet_Toggle_Proc(0)
		Case $WM_EXITMENULOOP
			HotKeysSet_Toggle_Proc(1)
	EndSwitch
EndFunc

Func QuitApp()
	SoundPlay("")
	FileDelete($Icons_Library_Path)
	FileDelete($Capture_Sound_Path)
	Exit
EndFunc

#EndRegion Program Functions
