$wcancelId = _RegisterPlugin("[!./]wcancel\z","_WMod_Cancel","!wcancel - Cancel WMod without saving",True)
$wsaveId = _RegisterPlugin("[!./]wsave\z","_WMod_Save","!wsave - Save written content",True)
$wmodId = _RegisterPlugin("[!./]wmod (.+)\z","_WMod_Start","!wmod - Start WMod session",True)
$wmodwriteId = _RegisterPlugin(".*\z","_WMod_Write","<string> - writes content in file (WMod)",True,True)
_Add_Init("_WMod_Init")
_Add_Pre("_WMod_Pre")

Func _WMod_Start($from,$messbody,ByRef $sock)
	$path = StringRegExp($messbody,"[!./]wmod (.+)",1)
	$wm = _SetWmod($from,$path[0],1)
	if $wm=False Then
		_JabMsg($from,"Error",$sock)
		return False
	EndIf
	_JabMsg($from,"WMod started",$sock)
	_PluginOn($wmodwriteId)
EndFunc

Func _WMod_Pre($from,$messbody,ByRef $sock)
	$from1 = _GetJID($from)
	$wadm = _ArraySearch($admins,$from1)
	If ($wadm <> -1) And (_IsWmod($from1)) Then
		local $ret[2]
		$ret[0]="[!./]wsave\z"
		$ret[1]="[!./]wcancel\z"
		return $ret
	Else
		return -1
	EndIf
EndFunc

Func _WMod_Write($from,$messbody,ByRef $sock)
	$from1 = _GetJID($from)
	$wadm = _ArraySearch($admins,$from1)
	MsgBox(0,"Info",$wadm)
	If ($wadm <> -1) And (_IsWmod($from1)) Then
		_ContentWrite($messbody,$wcnts[$wadm])
	EndIf
EndFunc

Func _WMod_Save($from,$messbody,ByRef $sock)
	$wm = _SetWmod($from,"",0)
	if $wm=False Then
		_JabMsg($from,"Turn on WMod first",$sock)
		return False
	EndIf
	$from1 = _GetJID($from)
	$con = _ArraySearch($admins,$from1)
	MsgBox(0,"Info",$wcnts[$con] & " " & $wpaths[$con])
	$issvd = _ContentSave($wcnts[$con],$wpaths[$con])
	if $issvd=False Then
		_JabMsg($from,"Error saving file!",$sock)
	Else
		_JabMsg($from,"Saved!",$sock)
	EndIf
EndFunc

Func _WMod_Cancel($from,$messbody,ByRef $sock)
	$from1 = _GetJID($from)
	$wm = _SetWmod($from1,"",0)
	if $wm = True Then
		_JabMsg($from,"Canceled!",$sock)
	Else
		_JabMsg($from,"Error",$sock)
	EndIf
EndFunc

Func _WMod_Init()
	Global $wmods[UBound($admins)]
	For $i=0 To UBound($admins)-1 Step 1
		$wmods[$i] = 0
	Next
	Global $wcnts[UBound($admins)]
	For $i=0 To UBound($admins)-1 Step 1
		$wcnts[$i] = ""
	Next
	Global $wpaths[UBound($admins)]
	For $i=0 To UBound($admins)-1 Step 1
		$wpaths[$i] = ""
	Next
EndFunc

Func _IsWmod($who)
	$var = _ArraySearch($admins,$who)
	if $var <> -1 Then
		If $wmods[$var] = 1 Then
			return True
		EndIf
	EndIf
	Return False
EndFunc

Func _SetWmod($who,$path,$onf)
	$who1 = _GetJID($who)
	$con = _ArraySearch($admins,$who1)
	if $con <> -1 Then
		if $onf = 1 Then
			$wmods[$con] = 1
			$wpaths[$con] = $path
			Return True
		ElseIf _IsWmod($who1) Then
			$wmods[$con] = 0
			$wpaths[$con] = ""
			$wcnts[$con] = ""
			Return True
		EndIf
	EndIf
	Return False
EndFunc

Func _ContentWrite($str,ByRef $wcnt)
	$wcnt = $wcnt & $str & @CRLF
EndFunc

Func _ContentSave(ByRef $str,ByRef $path)
	$issvd1 = FileWrite($path,$str)
	$str = ""
	$path = ""
	If $issvd1=0 Then
		return False
	Else
		return True
	EndIf
EndFunc