Func _JabStart($jid,$jidpass,$port,$res)
	$jidname = StringTrimRight($jid, StringLen($jid) - StringInStr($jid, "@") + 1)
	$server = StringTrimLeft($jid, StringInStr($jid, "@"))
	TCPStartUp()
	$socket = TCPConnect(TCPNameToIP($server), $port )
	If $socket = -1 Then
		msgbox(0, "Error", "Connection to server failed")
		Exit
	EndIf
	TCPSend($socket, "<?xml version='1.0' encoding='UTF-8' ?><stream:stream to='" & $server & "' xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams'>")
	TCPSend($socket, "<iq type='get' to='" & $server & "' id='auth1'><query xmlns='jabber:iq:auth'><username>" & $jidname & "</username></query></iq>")
    TCPSend($socket, "<iq type='set' id='auth2'><query xmlns='jabber:iq:auth'><username>" & $jidname & "</username><password>" & $jidpass & "</password><resource>" & $res & "</resource></query></iq><presence type='available'></presence>")
	return $socket
EndFunc
 
Func _JabExit(ByRef $socket)
    TCPsend($socket, "</stream:stream>")
    TCPCloseSocket($socket)
    TCPShutdown()
EndFunc
 
;#####-#####-(Future Jabber UDF begins here)-#####-#####
 
Func _JabMsg($Target, $Message,ByRef $socket,$type='normal')
	$sMessageBinary=StringToBinary($Message)
	$Message=BinaryToString ($sMessageBinary , 4 )
	$Message = StringRegExpReplace($Message,"&",'&amp;')
	$Message = StringRegExpReplace($Message,"<","&lt;")
	$Message = StringRegExpReplace($Message,">","&gt;")
	$Message = StringRegExpReplace($Message,'"','&quot;')
	$Message = StringRegExpReplace($Message,"'",'&apos;')
    TCPSend($socket, "<message to='" & $Target & "' type='" & $type & "'><body>" & $Message & "</body></message>")
EndFunc
Func _JabPoll(ByRef $socket)
    $recv = TCPRecv($socket, 2048)
    if $recv <> "" then
        if StringInStr($recv, "<message ") And StringInStr($recv, "<body>") Then
			$from = StringRegExp($recv,"from=[""']([^""']*)[""']",3)
			$from = $from[0]
            $body = StringInStr($recv, "<body>") + 5
            $body2 = StringLen($recv) - StringInStr($recv, "</body>") + 1
            $messbod = StringTrimRight(StringTrimLeft($recv, $body), $body2)
			$messbod=BinaryToString(StringToBinary($messbod),4)
			$messbod = StringRegExpReplace($messbod,"&amp;",'&')
			$messbod = StringRegExpReplace($messbod,"&lt;","<")
			$messbod = StringRegExpReplace($messbod,"&gt;",">")
			$messbod = StringRegExpReplace($messbod,"&quot;",'"')
			$messbod = StringRegExpReplace($messbod,"&apos;","'")
			;---------------------------------------------------------------------
			Local $retun[2]
			$retun[0] = $from
			$retun[1] = $messbod
			return $retun
			;---------------------------------------------------------------------
        EndIf
	EndIf
EndFunc

Func _JabStatus($status,$statstr,ByRef $socket)
	$statstr=StringToBinary($statstr)
	$statstr=BinaryToString ($statstr , 4 )
    TCPSend($socket, "<presence><show>" & $status & "</show><status>" & $statstr & "</status></presence>")
EndFunc

Func _JabSendFile($fname,$to,ByRef $socket)
	$sid = Int(Random(10000000,99999999))
	$count = 0
	if StringRegExp($fname,".*\\.*") = 1 Then
		$f = StringSplit($fname,"\\",2)
		$fname2 = $f[UBound($f)-1]
	Else
		$fname2 = $fname
	EndIf
	TCPSend($socket,"<iq type='set' to='" & $to & "' id='jadmin_" & $count & "'>" & @CRLF & _
"<si xmlns='http://jabber.org/protocol/si' id='" & $sid & "' mime-type='binary/octet-stream' profile='http://jabber.org/protocol/si/profile/file-transfer'>" & @CRLF & _
"<file xmlns='http://jabber.org/protocol/si/profile/file-transfer' name='" & $fname2 & "' size='" & StringLen(FileRead($fname)) & "'>" & @CRLF & _
"<desc>" & $fname2 & "</desc>" & @CRLF & _
"</file>" & @CRLF & _
"<feature xmlns='http://jabber.org/protocol/feature-neg'>" & @CRLF & _
"<x xmlns='jabber:x:data' type='form'>" & @CRLF & _
"<field var='stream-method' type='list-single'>" & @CRLF & _
"<option>" & @CRLF & _
"<value>http://jabber.org/protocol/ibb</value>" & @CRLF & _
"</option>" & @CRLF & _
"</field>" & @CRLF & _
"</x>" & @CRLF & _
"</feature>" & @CRLF & _
"</si>" & @CRLF & _
"</iq>")
	$recv = ""
	While $recv = ""
		$recv = TCPRecv($socket, 2048)
		if StringRegExp($recv,".*id=[""']jadmin_" & $count & "[""'].*") and StringRegExp($recv,".*type=[""']result[""'].*") Then
			TCPSend($socket,"<iq type='set' to='" & $to & "' id='jadmin_" & $count+1 & "'>" & @CRLF & _
"<open xmlns='http://jabber.org/protocol/ibb' sid='" & $sid & "' block-size='2048' />" & @CRLF & _
"</iq>")
			$fblocks = _StringSplit(FileRead($fname),2048)
			For $iBl=0 To UBound($fblocks)-1 Step 1
				TCPSend($socket,"<message id='jadmin_" & $count+2 & "' to='" & $to & "'>" & @CRLF & _
				"<data xmlns='http://jabber.org/protocol/ibb' seq='" & $count & "' sid='" & $sid & "'>" & _Base64Encode($fblocks[$iBl]) & "</data>" & @CRLF & _
				"<amp xmlns='http://jabber.org/protocol/amp'>" & @CRLF & _
				"<rule condition='deliver-at' value='stored' action='error' />" & @CRLF & _
				"<rule condition='match-resource' value='exact' action='error' />" & @CRLF & _
				"</amp>" & @CRLF & _
				"</message>")
				$count = $count + 1
				Sleep(1000)
			Next
			TCPSend($socket,"<iq type='set' to='" & $to & "' id='jadmin_" & $count+2 & "'>" & @CRLF & _
			"<close xmlns='http://jabber.org/protocol/ibb' sid='" & $sid & "' />" & @CRLF & _
			"</iq>")
			return True
		ElseIf StringRegExp($recv,".*type=[""']cancel[""'].*") or StringRegExp($recv,".*type=[""']error[""'].*") Then
			Return False
		Else
			$recv = ""
			ContinueLoop
		EndIf
	WEnd
EndFunc

Func _StringSplit($str,$count)
	Dim $l[1]
	For $i=0 To StringLen($str) Step $count
		_ArrayAdd($l,StringTrimRight(StringTrimLeft($str,$i),StringLen($str)-$i-$count))
	Next
	_ArrayDelete($l,0)
	Return $l
EndFunc

Func _GetJID($jid1)
	$jid = StringSplit($jid1,"/",2)
	return $jid[0]
EndFunc

Func _Base64Decode($Data)
	Local $Opcode = "0xC81000005356578365F800E8500000003EFFFFFF3F3435363738393A3B3C3DFFFFFF00FFFFFF000102030405060708090A0B0C0D0E0F10111213141516171819FFFFFFFFFFFF1A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132338F45F08B7D0C8B5D0831D2E9910000008365FC00837DFC047D548A034384C0750383EA033C3D75094A803B3D75014AB00084C0751A837DFC047D0D8B75FCC64435F400FF45FCEBED6A018F45F8EB1F3C2B72193C7A77150FB6F083EE2B0375F08A068B75FC884435F4FF45FCEBA68D75F4668B06C0E002C0EC0408E08807668B4601C0E004C0EC0208E08847018A4602C0E00624C00A46038847028D7F038D5203837DF8000F8465FFFFFF89D05F5E5BC9C21000"
	
	Local $CodeBuffer = DllStructCreate("byte[" & BinaryLen($Opcode) & "]")
	DllStructSetData($CodeBuffer, 1, $Opcode)

	Local $Ouput = DllStructCreate("byte[" & BinaryLen($Data) & "]")
	Local $Ret = DllCall("user32.dll", "int", "CallWindowProc", "ptr", DllStructGetPtr($CodeBuffer), _
													"str", $Data, _
													"ptr", DllStructGetPtr($Ouput), _
													"int", 0, _
													"int", 0)

	Return BinaryMid(DllStructGetData($Ouput, 1), 1, $Ret[0])
EndFunc

Func _Base64Encode($Data, $LineBreak = 76)
	Local $Opcode = "0x5589E5FF7514535657E8410000004142434445464748494A4B4C4D4E4F505152535455565758595A6162636465666768696A6B6C6D6E6F707172737475767778797A303132333435363738392B2F005A8B5D088B7D108B4D0CE98F0000000FB633C1EE0201D68A06880731C083F901760C0FB6430125F0000000C1E8040FB63383E603C1E60409C601D68A0688470183F90176210FB6430225C0000000C1E8060FB6730183E60FC1E60209C601D68A06884702EB04C647023D83F90276100FB6730283E63F01D68A06884703EB04C647033D8D5B038D7F0483E903836DFC04750C8B45148945FC66B80D0A66AB85C90F8F69FFFFFFC607005F5E5BC9C21000"

	Local $CodeBuffer = DllStructCreate("byte[" & BinaryLen($Opcode) & "]")
	DllStructSetData($CodeBuffer, 1, $Opcode)

	$Data = Binary($Data)
	Local $Input = DllStructCreate("byte[" & BinaryLen($Data) & "]")
	DllStructSetData($Input, 1, $Data)

	$LineBreak = Floor($LineBreak / 4) * 4
	Local $OputputSize = Ceiling(BinaryLen($Data) * 4 / 3) 
	$OputputSize = $OputputSize + Ceiling($OputputSize / $LineBreak) * 2 + 4

	Local $Ouput = DllStructCreate("char[" & $OputputSize & "]")
	DllCall("user32.dll", "none", "CallWindowProc", "ptr", DllStructGetPtr($CodeBuffer), _
													"ptr", DllStructGetPtr($Input), _
													"int", BinaryLen($Data), _
													"ptr", DllStructGetPtr($Ouput), _
													"uint", $LineBreak)
	Return DllStructGetData($Ouput, 1)
EndFunc
