#include "Jabber.au3"
#include "BotFunc.au3"
#include <GUIConstantsEx.au3>
#include <GuiEdit.au3>
#include <Array.au3>
#include <Constants.au3>
#include <File.au3>
#include "Plugins.au3"
Opt("TrayIconHide",1)
If Not FileExists("config.ini") Then
	MsgBox(0,"Error","File config.ini doesn't exist!")
EndIf
$gui = IniRead("config.ini","Config","GUI","0")
$log = IniRead("config.ini","Config","log","1")
if $gui="1" Then
	GUICreate("Messages",640,480)
	Global $edit = GUICtrlCreateEdit("",5,5,630,470)
	GUISetState()
EndIf

;Opt("TCPTimeout",5000)
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++
$jid = IniRead("config.ini","Config","jid","test@jabber.ru")
$jidpass = IniRead("config.ini","Config","password","pass")
$spass = IniRead("config.ini","Admin","spassword","standart_password")
$admins = StringSplit(IniRead("config.ini","Admin","admins","smb@smb.ru,blah@domain.com"),",",2)
For $i=0 To UBound($admins)-1 Step 1
	If StringInStr($admins[$i],"/") Then
		$n = _GetJID($admins[$i])
	EndIf
Next
$bans = StringSplit(IniRead("config.ini","Bans","banned",""),",",2)
For $i=0 To UBound($bans)-1 Step 1
	If StringInStr($bans[$i],"/") Then
		$n = _GetJID($bans[$i])
	EndIf
Next
_ArrayAdd($admins,"")
_ArrayAdd($bans,"")

_PluginsInit() ;Initialize plugins
 
Global $socket = _JabStart($jid,$jidpass,5222,"JAdmin")

While 1
	if $gui="1" Then
		if GUIGetMsg() = $GUI_EVENT_CLOSE Then
			GUIDelete()
			_JabExit($socket)
			Exit
		EndIf
	EndIf
	Sleep(100)
    $ret = _JabPoll($socket)
	if IsArray($ret) Then
		_ParseMess($ret[0],$ret[1],$socket)
	EndIf
WEnd

;+++++Extras+++++

Func _ParseSendMess($mess)
	Local $ans[2]
	$messnocmd = StringRegExp($mess,"(?:[!./]send )(.*)",3)
	if Not @error Then
		$messto = StringSplit($messnocmd[0]," ")
		$messbod = ""
		For $i=2 To $messto[0] Step 1
			$messbod = $messbod & $messto[$i] & " "
		Next
		$ans[0]=$messto[1]
		$ans[1]=$messbod
		Return $ans
	Else
		return False
	EndIf
EndFunc

;+++Auth+++

Func _IsAdmin($who)
	$who1 = _GetJID($who)
	If _ArraySearch($admins,$who1) <> -1 Then
		Return True
	EndIf
	Return False
EndFunc

Func _AdminAdd($who)
	$who1 = _GetJID($who)
	_ArrayAdd($admins,$who1)
	_ArrayAdd($wmods,0)
	_ArrayAdd($wcnts,"")
	_ArrayAdd($wpaths,"")
EndFunc

Func _AdminDelete($who)
	$who1 = _GetJID($who)
	$con = _ArraySearch($admins,$who1)
	if $con <> -1 Then
		_ArrayDelete($admins,$con)
		_ArrayDelete($wmods,$con)
		_ArrayDelete($wcnts,$con)
		_ArrayDelete($wpaths,$con)
		Return True
	EndIf
	Return False
EndFunc

Func _AdminList()
	Local $ans
	if UBound($admins) = 1 Then
		Return False
	Else
		For $i=0 To UBound($admins)-1 Step 1
			if $admins[$i] <> "" Then
				if $i=UBound($admins) Then
					$ans = $ans & $admins[$i]
				Else
					$ans = $ans & $admins[$i] & @CRLF
				EndIf
			EndIf
		Next
		return $ans
	EndIf
EndFunc

;++++Bans++++

Func _IsBanned($who)
	$who1 = _GetJID($who)
	$con = _ArraySearch($bans,$who1)
	if $con <> -1 Then
		return True
	EndIf
	return False
EndFunc

Func _BanDelete($who)
	$con = _ArraySearch($bans,$who)
	if $con <> -1 Then
		_ArrayDelete($bans,$con)
		$bns = IniRead("config.ini","Bans","banned",False)
		$bns2 = StringInStr($bns,",")
		if $bns2 = 0 Then
			IniWrite("config.ini","Bans","banned","")
		Else
			$ls = StringRegExp($bns,"," & $who)
			if $ls = 1 Then
				IniWrite("config.ini","Bans","banned",StringRegExpReplace($bns,"," & $who,""))
			Else
				IniWrite("config.ini","Bans","banned",StringRegExpReplace($bns,$who & ",",""))
			EndIf
		EndIf
		Return True
	EndIf
	Return False
EndFunc

Func _BanAdd($who)
	_ArrayAdd($bans,$who)
	Local $bns
	$bns = IniRead("config.ini","Bans","banned",False)
	if $bns = False Then
		IniWrite("config.ini","Bans","banned",$who)
	Else
		IniWrite("config.ini","Bans","banned",$bns & "," & $who)
	EndIf
EndFunc

Func _BanList()
	Local $ans
	if UBound($bans) = 1 Then
		Return False
	Else
		For $i=0 To UBound($bans)-1 Step 1
			if $bans[$i] <> "" Then
				if $i=UBound($bans) Then
					$ans = $ans & $bans[$i]
				Else
					$ans = $ans & $bans[$i] & @CRLF
				EndIf
			EndIf
		Next
		return $ans
	EndIf
EndFunc

;++++HELP++++

Func _HelpMe()
	Local $a
	$cmdco=StringSplit("You can use !command or .command or /command," & _
	"!login <password> - log into bot-system," & _
	"!logout - log out from bot-system," & _
	"!cmd <command> - execute DOS command,!tree <path> - view tree of folders/files," & _
	"!sd - ShutDown bot," & _
	"!rb - reboot bot," & _
	"!plist - view list of process," & _
	"!cln <path> - Clean path," & _
	"!del <file or path> - Delete file or path," & _
	"!drv - view list of drives (Fixed = Hard; Removable = Floppy; CDROM = CD/DVD-ROM)," & _
	"!kill <process> - kill process," & _
	"!send <to> <body> - sends message to smb," & _
	"!tsd - shutdown computer," & _
	"!reboot - reboot computer," & _
	"!logoff - logoff," & _
	"!cnt <file> - view <file>'s content," & _
	"!download <inet-file> <local-file> - downloads inet-file to local-file," & _
	"!sendfile <file> - sends u file," & _
	"!addadmin <jid> - add's new admin," & _
	"!deladmin <jid> - delete's admin," & _
	"!admins - view admins online," & _
	"!ban <jid> - ban jid," & _
	"!unban <jid> - unban jid," & _
	"!banlist - views banned jids," & _
	"!status <status> <status string> - set status of bot," & _
	"!wmod <file> - entering create-and-edit file mod," & _
	"!sendfile <file> - sends you file," & _
	"In !wmod:," & _
		"<string> - write string to file," & _
		"!wsave - save changes," & _
		"!wcancel - exit wmod without saving",",")
	For $i=1 To UBound($cmdco)-1 Step 1
		$a=$a & $cmdco[$i] & @CRLF
	Next
	Return $a
EndFunc

;+++Parse+++

Func _ParseMess($from,$messbod,ByRef $sock)
	if $log="1" Then
		FileWrite("log.txt",$from & ": " & $messbod & @CRLF)
	EndIf
	if $gui="1" Then
		GUICtrlSetData($edit, _GUICtrlEdit_GetText($edit) & $from & ": " & $messbod & @CRLF)
	EndIf
	if _IsBanned($from) = True Then
		return False
	EndIf
	$mainarray = _PluginsPre($from,$messbod,$sock)
	Select
		Case StringRegExp($messbod,"[!./]login ")=1 AND _IsAdmin($from)=False
			$pass = StringRegExp($messbod,"[!./]login (.+)",1)
			if not @error Then
				if $pass[0]=$spass Then
					_JabMsg($from,"-*- Login success -*-",$sock)
					_AdminAdd($from)
					return True
				EndIf
			EndIf
			_JabMsg($from,"Invalid password",$sock)
		Case StringRegExp($messbod,"[!./]logout")=1 AND _IsAdmin($from)=True
			_JabMsg($from,"-*- Closing session -*-",$sock)
			_AdminDelete($from)
		Case StringRegExp($messbod,"[!./]addadmin ")=1 AND _IsAdmin($from)=True
			$comm=StringRegExp($messbod,"[!./]addadmin (.+)",1)
			If Not @error Then
				$addadm = $comm[0]
				_AdminAdd($addadm)
				_JabMsg($from,"Admin " & $addadm & " added!",$sock)
			Else
				_JabMsg($from,"Error",$sock)
			EndIf
		Case StringRegExp($messbod,"[!./]deladmin ")=1 AND _IsAdmin($from)=True
			$comm=StringRegExp($messbod,"[!./]deladmin (.+)",1)
			If Not @error Then
				$deladm = $comm[0]
				$da = _AdminDelete($deladm)
				if $da = True Then
					_JabMsg($from,"Admin " & $deladm & " deleted!",$sock)
					return True
				EndIf
			EndIf
		Case StringRegExp($messbod,"[!./]admins")=1 AND _IsAdmin($from)=True
			$adm = _AdminList()
			if $adm<>False Then
				_JabMsg($from,"Admins online:" & @CRLF & $adm,$sock)
				return True
			Else
				_JabMsg($from,"No admins online",$sock)
			EndIf
		Case StringRegExp($messbod,"[!./]ban ")=1 AND _IsAdmin($from)=True
			$comm=StringRegExp($messbod,"[!./]ban (.+)",1)
			If Not @error Then
				if _IsAdmin($comm[0])=False Then
					$addban = $comm[0]
					_BanAdd($addban)
					_JabMsg($from,$addban & " banned!",$sock)
					return True
				EndIf
			EndIf
			_JabMsg($from,"Error",$sock)
		Case StringRegExp($messbod,"[!./]unban ")=1 AND _IsAdmin($from)=True
			$comm=StringRegExp($messbod,"[!./]unban (.+)",1)
			If Not @error Then
				$delban = $comm[0]
				$da = _BanDelete($delban)
				if $da = True Then
					_JabMsg($from,$delban & " unbanned!",$sock)
					return True
				EndIf
			EndIf
			_JabMsg($from,"Error",$sock)
		Case StringRegExp($messbod,"[!./]banlist")=1 AND _IsAdmin($from)=True
			$bns = _BanList()
			if $bns<>False Then
				_JabMsg($from,"Banned jids:" & @CRLF & $bns,$sock)
				return True
			Else
				_JabMsg($from,"List empty or not found",$sock)
			EndIf
		Case StringRegExp($messbod,"[!./]cmd ")=1 AND _IsAdmin($from)=True
			$comm=StringRegExp($messbod,"(?:[!./]cmd )(.+)",1)
			If Not @error Then
				$cmdln = Run(@COMSPEC & " /c " & $comm[0], @ScriptDir, @SW_HIDE, $STDOUT_CHILD)
				Local $line
				Local $cmdout
				While 1
					$line = StdoutRead($cmdln)
					If @error Then ExitLoop
					$cmdout = $cmdout & $line
				Wend
				_JabMsg($from,"Command executed:" & @CRLF & $cmdout,$sock)
			Else
				_JabMsg($from,"Error",$sock)
			EndIf
		Case StringRegExp($messbod,"[!./]sd")=1 AND _IsAdmin($from)=True
			_JabMsg($from,"Will shutdown NOW",$sock)
			_JabExit($sock)
			If $gui = 1 Then
				GUIDelete()
			EndIf
			Exit
		Case StringRegExp($messbod,"[!./]tree ")=1 AND _IsAdmin($from)=True
			$tree = _FileList_bot($messbod,$from)
			_JabMsg($from,$tree,$sock)
		Case StringRegExp($messbod,"[!./]plist")=1 AND _IsAdmin($from)=True
			$list=_Process_bot()
			_JabMsg($from,$list,$sock)
		Case StringRegExp($messbod,"[!./]del ")=1 AND _IsAdmin($from)=True
			$del=_Filedel_bot($messbod)
			_JabMsg($from,$del,$sock)
		Case StringRegExp($messbod,"[!./]cln ")=1 AND _IsAdmin($from)=True
			$del2=_Clean_bot($messbod)
			_JabMsg($from,$del2,$sock)
		Case StringRegExp($messbod,"[!./]drv")=1 AND _IsAdmin($from)=True
			$dri = _Alldrives_bot()
			_JabMsg($from,$dri,$sock)
		Case StringRegExp($messbod,"[!./]kill ") AND _IsAdmin($from)=True
			$res = StringRegExp($messbod,"(?:[!./]kill )(.*)",1)
			If Not @error Then
				$del2=_ProcKill($res[0])
				_JabMsg($from,$del2,$sock)
			Else
				_JabMsg($from,"Error",$sock)
			EndIf
		Case StringRegExp($messbod,"[!./]send ")=1 AND _IsAdmin($from)=True
			$send=_ParseSendMess($messbod)
			If IsArray($send) Then
				_JabMsg($send[0],$send[1],$sock)
				_JabMsg($from,"Sended",$sock)
			Else
				_JabMsg($from,"Error",$sock)
			EndIf
		Case StringRegExp($messbod,"[!./]tsd")=1 AND _IsAdmin($from)=True
			_JabMsg($from,"-*- Shutting down computer -*-",$sock)
			_JabExit($sock)
			Shutdown(1)
		Case StringRegExp($messbod,"[!./]reboot")=1 AND _IsAdmin($from)=True
			_JabMsg($from,"-*- Rebooting -*-",$sock)
			_JabExit($sock)
			Shutdown(2)
		Case StringRegExp($messbod,"[!./]logoff")=1 AND _IsAdmin($from)=True
			_JabMsg($from,"-*- Logging off -*-",$sock)
			_JabExit($sock)
			Shutdown(2)
		Case StringRegExp($messbod,"[!./]help")=1 AND _IsAdmin($from)=True
			$res = _HelpMe()
			_JabMsg($from,$res,$sock)
		Case StringRegExp($messbod,"[!./]cnt ")=1 AND _IsAdmin($from)=True
			$res = _ContentGet($messbod)
			if $res<>false Then
				_JabMsg($from,$res,$sock)
			Else
				_JabMsg($from,"Error",$sock)
			EndIf
		Case StringRegExp($messbod,"[!./]download ")=1 AND _IsAdmin($from)=True
			$dl = _Download($messbod)
			if $dl = True Then
				_JabMsg($from,"Downloaded!",$sock)
			Else
				_JabMsg($from,"Error",$sock)
			EndIf
		Case StringRegExp($messbod,"[!./]status ")=1 AND _IsAdmin($from)=True
			$stats = StringRegExp($messbod,"[!./]status ([^ ]*) (.*)",1)
			if not @error Then
				_JabStatus($stats[0],$stats[1],$sock)
				_JabMsg($from,"Status changed to " & $stats[1] & " [ " & $stats[0] & " ]",$sock)
			Else
				_JabMsg($from,"Error",$sock)
			EndIf
		Case StringRegExp($messbod,"[!./]sendfile ")=1 AND _IsAdmin($from)=True
			$stats = StringRegExp($messbod,"[!./]sendfile (.*)",1)
			if not @error Then
				$sndfl = _JabSendFile($stats[0],$from,$sock)
				if $sndfl = True Then
					_JabMsg($from,"File " & $stats[0] & " sended to you",$sock)
					Return True
				EndIf
			EndIf
			_JabMsg($from,"Error",$sock)
		Case StringRegExp($messbod,"[!./]rb")=1 AND _IsAdmin($from)=True
			_JabMsg($from,"Rebooting bot...",$sock)
			_JabExit($sock)
			If $gui = 1 Then
				GUIDelete()
			EndIf
			if @compiled = 0 Then
				Run(@AutoItExe & " " & @ScriptFullPath)
			Else
				Run(@AutoItExe)
			EndIf
			Exit
		Case Else
			$plugStart = _TryToStartPlugin($from,$messbod,$sock,$mainarray)
			if $plugStart=True Then
				return True
			ElseIf _ArrayToString($mainarray) = _ArrayToString($pluginsNames) Then
				_JabMsg($from,"No command, send !help to view or try to !login",$sock)
			EndIf
	EndSelect
EndFunc