#include-once
#include <WindowsConstants.au3>
#include <GuiTreeView.au3>
#include <Array.au3>
#include <GUIConstantsEx.au3>
#include <Misc.au3>
Opt("MustDeclareVars", 1)
Global $oSpaceNames = ObjCreate('Scripting.Dictionary')
If $oSpaceNames = 0 Then
	MsgBox(16, '', 'Object Scripting.Dictionary - error')
	Exit
EndIf
$oSpaceNames.CompareMode = 1
Global $aPack[1][4], $bold, $aChecked[1][2], $aDellMod[1], $ef, $hDLL = DllOpen("user32.dll")
Global $g_GTVEx_hItemSelected = 0, $sPathData = 0, $notselect, $movtxt
Global $g_GTVEx_aTVData = 0, $DateCreate

Global $bTreeDrag = False, $hDragItem, $fWhere, $fledit

Func _GUITreeViewEx_LoadTV($ParamLoad = 0, $Dir = '', $PathDate = '', $configfile = '')
	Local $TreeIni, $sString
	If Not $ParamLoad Then
		$sString = IniRead($configfile, 'TreeView', 'data', '')
		If Not $sString Then Return SetError(1)
	Else
		$notselect = 1
		$DateCreate = IniRead($Dir & '\install.jmp', 'Date', 'Date', '')
		If $PathDate Then
			$sString = IniRead($PathDate & '\' & $DateCreate & '.jmp', 'TreeView', 'data', '')
			If Not $sString Then
				$sString = IniRead($Dir & '\install.jmp', 'TreeView', 'data', '')
				If Not $sString Then Return SetError(1)
			EndIf
		Else
			$sString = IniRead($Dir & '\install.jmp', 'TreeView', 'data', '')
			If Not $sString Then Return SetError(1)
		EndIf
	EndIf
	Local $sTVItem, $iLevel, $bChecked, $hChild, $infoparam, $arraycheck, $paramitem
	Local $sDelimiter = "|", $sLevel = "~", $sChecked = "#"
	Local $aLevelParent[100] = [0]
	Local $aTVItems = StringSplit($sString, $sDelimiter)
	For $i = 1 To $aTVItems[0]
		$sTVItem = StringReplace($aTVItems[$i], $sLevel, "")
		$iLevel = @extended
		$sTVItem = StringReplace($sTVItem, $sChecked, "")
		$bChecked = ((@extended) ? (True) : (False))
		$infoparam = StringSplit($sTVItem, '*', 2)
		If UBound($infoparam) <> 9 Then Return SetError(2)
		$sTVItem = $infoparam[0]
		$hChild = _GUICtrlTreeView_AddChild($g_GTVEx_aTVData, $aLevelParent[$iLevel], $sTVItem)
		_GUICtrlTreeView_SetState($g_GTVEx_aTVData, $hChild, $TVIS_EXPANDED, 1)
		$aLevelParent[$iLevel + 1] = $hChild
		$paramitem = Number($infoparam[1])
		_GUICtrlTreeView_SetItemParam($g_GTVEx_aTVData, $hChild, $paramitem)
		_ArrayDelete($infoparam, 0)
		_ArrayDelete($infoparam, 0)
		$oSpaceNames.Add($paramitem, $infoparam)
		If $bChecked Then _GUICtrlTreeView_SetChecked($g_GTVEx_aTVData, $aLevelParent[$iLevel + 1], True)
		If Not $ParamLoad Then
			If Number($infoparam[5]) Then
				_GUICtrlTreeView_SetIcon($g_GTVEx_aTVData, $hChild, "shell32.dll", 27)
			Else
				If Not Number($infoparam[5]) And Not $infoparam[2] Then
					_GUICtrlTreeView_SetIcon($g_GTVEx_aTVData, $hChild, "shell32.dll", 4)
				ElseIf Not Number($infoparam[5]) And $infoparam[2] Then
					_GUICtrlTreeView_SetIcon($g_GTVEx_aTVData, $hChild, "shell32.dll", 144)
				EndIf
			EndIf
		EndIf
	Next
EndFunc   ;==>_GUITreeViewEx_LoadTV

Func _TV_UnCheck()
	If Not _GUICtrlTreeView_GetCount($g_GTVEx_aTVData) Then Return SetError(1)
	Local $paramitem, $valparam
	Local $hHandle = _GUICtrlTreeView_GetFirstItem($g_GTVEx_aTVData)
	While 1
		$paramitem = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $hHandle)
		$valparam = $oSpaceNames.Item($paramitem)
		_GUICtrlTreeView_SetChecked($g_GTVEx_aTVData, $hHandle, False)
		$valparam[6] = 0
		$oSpaceNames.Item($paramitem) = $valparam
		$hHandle = _GUICtrlTreeView_GetNext($g_GTVEx_aTVData, $hHandle)
		If Not $hHandle Then ExitLoop
	WEnd
EndFunc   ;==>_TV_UnCheck

Func _GUITreeViewEx_SaveTV($sTitle = '', $sName = '', $ParamSave = 0, $InstPath = '', $update = 0, $InstallIni = '')
	If Not _GUICtrlTreeView_GetCount($g_GTVEx_aTVData) Then Return SetError(1)
	Local $sDelimiter = "|", $sLevel = "~", $paramitem, $valparam, $sChecked = "#"
	Local $a = 1, $x = 1, $z = 1, $c = 1, $q = 1, $w = 1
	Local $sString = "", $sText, $sLevelCount, $sCheck, $StringParam
	Local $hHandle = _GUICtrlTreeView_GetFirstItem($g_GTVEx_aTVData)
	While 1
		$sLevelCount = ""
		For $i = 1 To _GUICtrlTreeView_Level($g_GTVEx_aTVData, $hHandle)
			$sLevelCount &= $sLevel
		Next
		$sCheck = ""
		$sText = _GUICtrlTreeView_GetText($g_GTVEx_aTVData, $hHandle)
		$paramitem = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $hHandle)
		$valparam = $oSpaceNames.Item($paramitem)
		If _GUICtrlTreeView_GetChecked($g_GTVEx_aTVData, $hHandle) Then
			If $ParamSave = 2 Then
				If $valparam[2] Then
					ReDim $aChecked[$z + 1][2]
					$aChecked[$c][0] = $paramitem
					If _GUICtrlTreeView_GetChildCount($g_GTVEx_aTVData, $hHandle) <> -1 Then $aChecked[$c][1] = 1
					$z += 1
					$c += 1
				EndIf
			EndIf
			$sCheck = $sChecked
		Else
			If $ParamSave = 2 Then
				If $valparam[2] Then
					If $update Then
						ReDim $aDellMod[$q + 1]
						$aDellMod[$w] = $paramitem
						$q += 1
						$w += 1
					EndIf
				EndIf
			EndIf
		EndIf
		If $ParamSave = 1 Then
			If $valparam[2] Then
				ReDim $aPack[$x + 1][4]
				$aPack[$a][0] = $paramitem
				$aPack[$a][1] = $valparam[0]
				$aPack[$a][2] = $valparam[1]
				$aPack[$a][3] = $valparam[2]
				$a += 1
				$x += 1
				$valparam[2] = 1
			EndIf
		EndIf
		$StringParam = $paramitem & '*' & _ArrayToString($valparam, '*')
		$sString &= $sLevelCount & $sCheck & $sText & '*' & $StringParam & $sDelimiter
		$hHandle = _GUICtrlTreeView_GetNext($g_GTVEx_aTVData, $hHandle)
		If $hHandle = 0 Then ExitLoop
	WEnd
	Switch $ParamSave
		Case 0
			IniWrite($InstallIni, 'TreeView', 'data', StringTrimRight($sString, 1))
			IniWrite($InstallIni, 'Title', 'data', $sTitle)
			IniWrite($InstallIni, 'Title', 'name', $sName)
		Case 1
			If UBound($aPack) = 1 Then Return SetError(2)
			$InstallIni = @TempDir & '\tmp\install.jmp'
			IniWrite($InstallIni, 'TreeView', 'data', StringTrimRight($sString, 1))
			IniWrite($InstallIni, 'Title', 'data', $sTitle)
			IniWrite($InstallIni, 'Title', 'name', $sName)
		Case 2
			If UBound($aChecked) > 1 Then IniWrite($InstPath & '\' & $DateCreate & '.jmp', 'TreeView', 'data', StringTrimRight($sString, 1))
	EndSwitch
EndFunc   ;==>_GUITreeViewEx_SaveTV

Func _GUITreeViewEx_InitTV($hTV)
	If Not IsHWnd($hTV) Then
		$g_GTVEx_aTVData = GUICtrlGetHandle($hTV)
		GUIRegisterMsg($WM_NOTIFY, "_GUITreeViewEx")
	ElseIf IsHWnd($hTV) Then
		$g_GTVEx_aTVData = $hTV
		GUIRegisterMsg($WM_NOTIFY, "_GUITreeViewEx")
	EndIf
EndFunc   ;==>_GUITreeViewEx_InitTV

Func _GUITreeViewEx_CloseTV()
	GUIRegisterMsg($WM_NOTIFY, "")
EndFunc   ;==>_GUITreeViewEx_CloseTV

Func _GUITreeViewEx($hWnd, $iMsg, $wParam, $lParam)
	#forceref $hWnd, $iMsg, $wParam
	Local $tStruct = DllStructCreate("struct;hwnd hWndFrom;uint_ptr IDFrom;INT Code;endstruct;" & _
			"uint Action;struct;uint OldMask;handle OldhItem;uint OldState;uint OldStateMask;" & _
			"ptr OldText;int OldTextMax;int OldImage;int OldSelectedImage;int OldChildren;lparam OldParam;endstruct;" & _
			"struct;uint NewMask;handle NewhItem;uint NewState;uint NewStateMask;" & _
			"ptr NewText;int NewTextMax;int NewImage;int NewSelectedImage;int NewChildren;lparam NewParam;endstruct;" & _
			"struct;long PointX;long PointY;endstruct", $lParam)
	Local $tNMHDR = DllStructCreate($tagNMHDR, $lParam)
	Local $hWndFrom = DllStructGetData($tStruct, "hWndFrom")
	If $hWndFrom = $g_GTVEx_aTVData Then
		Local $hItem = DllStructGetData($tStruct, "NewhItem")
		Switch DllStructGetData($tStruct, "Code")
			Case $TVN_SELCHANGEDW, $TVN_SELCHANGEDA
				If $hItem Then
					If $notselect Then
						_GUICtrlTreeView_SetState($g_GTVEx_aTVData, $hItem, $TVIS_SELECTED, False)
					Else
						_GUICtrlTreeView_SetBold($g_GTVEx_aTVData, $bold, False)
						_GUICtrlTreeView_SetBold($g_GTVEx_aTVData, $hItem, True)
						$bold = $hItem
					EndIf
					$g_GTVEx_hItemSelected = $hItem
					$sPathData = $hItem
				EndIf
				$g_GTVEx_aTVData = $hWndFrom
;~ 			Case $TVN_KEYDOWN
;~ 				Local $tInfo = DllStructCreate($tagNMTVKEYDOWN, $lParam)
;~ 				Local $Key = DllStructGetData($tInfo, "VKey")
;~ 				Switch $Key
;~ 					Case 0x20
;~ 						Local $hItems = _GUICtrlTreeView_GetSelection($g_GTVEx_aTVData)
;~ 						If $hItems Then $g_GTVEx_hItemSelected = $hItems
;~ 				EndSwitch
;~ 				$g_GTVEx_aTVData = $hWndFrom
			Case $TVN_BEGINDRAGA, $TVN_BEGINDRAGW
				If Not $notselect Then
					$movtxt = _GUICtrlTreeView_GetText($g_GTVEx_aTVData, $hItem)
					$bTreeDrag = True
					$hDragItem = TreeItemFromPoint($g_GTVEx_aTVData)
					_GUICtrlTreeView_SetSelected($g_GTVEx_aTVData, _GUICtrlTreeView_GetSelection($g_GTVEx_aTVData), False)
					_GUICtrlTreeView_SetBold($g_GTVEx_aTVData, $bold, False)
					_GUICtrlTreeView_SetBold($g_GTVEx_aTVData, $hItem, True)
					$g_GTVEx_hItemSelected = $hItem
					$sPathData = $hItem
					$bold = $hItem
				EndIf
				$g_GTVEx_aTVData = $hWndFrom
			Case $TVN_ENDLABELEDITA, $TVN_ENDLABELEDITW
				If Not $notselect Then
					Local $tInfo = DllStructCreate($tagNMHDR & ";" & $tagTVITEMEX, $lParam)
					If DllStructGetData($tInfo, "Text") <> 0 Then
						Local $tBuffer = DllStructCreate("wchar Text[" & DllStructGetData($tInfo, "TextMax") & "]", DllStructGetData($tInfo, "Text"))
						Local $txt = StringStripWS(DllStructGetData($tBuffer, "Text"), 3)
						If $txt Then
							_GUICtrlTreeView_SetText($g_GTVEx_aTVData, _GUICtrlTreeView_GetSelection($g_GTVEx_aTVData), DllStructGetData($tBuffer, "Text"))
							_TextSet()
						EndIf
					EndIf
				EndIf
				$g_GTVEx_aTVData = $hWndFrom
		EndSwitch
	EndIf
	Return $GUI_RUNDEFMSG
EndFunc   ;==>_GUITreeViewEx

Func _TextSet()
	_GUICtrlTreeView_EndEdit($g_GTVEx_aTVData)
EndFunc   ;==>_TextSet

Func TreeItemFromPoint($hWnd)
	Local $tMPos = _WinAPI_GetMousePos(True, $hWnd)
	Return _GUICtrlTreeView_HitTestItem($hWnd, DllStructGetData($tMPos, 1), DllStructGetData($tMPos, 2))
EndFunc   ;==>TreeItemFromPoint

Func _TVAutoCheckUncheck()
	If Not $g_GTVEx_hItemSelected Then Return
	Local $valparam
	Local $gettext = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $g_GTVEx_hItemSelected)
	Local $check = _GUICtrlTreeView_GetChecked($g_GTVEx_aTVData, $g_GTVEx_hItemSelected)
	Local $parentcheck = _GUICtrlTreeView_GetParentHandle($g_GTVEx_aTVData, $g_GTVEx_hItemSelected)
	If $check Then
		$valparam = $oSpaceNames.Item($gettext)
		If Number($valparam[6]) Then
			$g_GTVEx_hItemSelected = 0
			Return
		Else
			$valparam[6] = 1
			$oSpaceNames.Item($gettext) = $valparam
			__TVUnCheck($g_GTVEx_hItemSelected, True, True)
		EndIf
		If Not _GUICtrlTreeView_GetChecked($g_GTVEx_aTVData, $parentcheck) Then
			_AutoCheckParents($g_GTVEx_hItemSelected)
			__TVUnCheck($g_GTVEx_hItemSelected, True, True)
			$g_GTVEx_hItemSelected = 0
			Return
		EndIf
		If $parentcheck Then
			Local $textparent = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $parentcheck)
			$valparam = $oSpaceNames.Item($textparent)
			Local $textchild, $Child
			If Number($valparam[5]) Then
				$Child = _GUICtrlTreeView_GetFirstChild($g_GTVEx_aTVData, $parentcheck)
				If $Child = 0 Then
					$g_GTVEx_hItemSelected = 0
					Return
				EndIf
				While 1
					$textchild = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $Child)
					If StringCompare($gettext, $textchild) Then
						_GUICtrlTreeView_SetChecked($g_GTVEx_aTVData, $Child, False)
						__TVUnCheck($Child, False)
					EndIf
					$Child = _GUICtrlTreeView_GetNextChild($g_GTVEx_aTVData, $Child)
					If Not $Child Then ExitLoop
				WEnd
			EndIf
		EndIf
		$g_GTVEx_hItemSelected = 0
	Else
		$valparam = $oSpaceNames.Item($gettext)
		If Not Number($valparam[6]) Then
			$g_GTVEx_hItemSelected = 0
			Return
		Else
			__TVUnCheck($g_GTVEx_hItemSelected, False)
			_AutoUnCheckParents($g_GTVEx_hItemSelected)
			$g_GTVEx_hItemSelected = 0
		EndIf
	EndIf
EndFunc   ;==>_TVAutoCheckUncheck


;----------------------------------------------------------------------------------------------------------------------

Func _AutoUnCheckParents($hPassedItem)
	Local $hParent = _GUICtrlTreeView_GetParentHandle($g_GTVEx_aTVData, $hPassedItem)
	If Not $hParent Then Return
	Local $vch = __TVVerifyCheck($hParent)
	If Not $vch Then
		Local $textchild = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $hParent)
		Local $getparam = $oSpaceNames.Item($textchild)
		If Not $getparam[2] Then
			$getparam[6] = 0
			$oSpaceNames.Item($textchild) = $getparam
			_GUICtrlTreeView_SetChecked($g_GTVEx_aTVData, $hParent, False)
			_AutoUnCheckParents($hParent)
		EndIf
	EndIf
EndFunc   ;==>_AutoUnCheckParents

Func __TVVerifyCheck($hPassedItem)
	Local $hChild = _GUICtrlTreeView_GetFirstChild($g_GTVEx_aTVData, $hPassedItem)
	If Not $hChild Then Return
	While 1
		If _GUICtrlTreeView_GetChecked($g_GTVEx_aTVData, $hChild) Then Return 1
		$hChild = _GUICtrlTreeView_GetNextChild($g_GTVEx_aTVData, $hChild)
		If Not $hChild Then ExitLoop
	WEnd
EndFunc   ;==>__TVVerifyCheck

;-----------------------------------------------------------------------------------------------------------------------


Func _AutoCheckParents($hPassedItem)
	Local $hParent = _GUICtrlTreeView_GetParentHandle($g_GTVEx_aTVData, $hPassedItem)
	If Not $hParent Then Return
	Local $textchild = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $hParent)
	Local $getparam = $oSpaceNames.Item($textchild)
	$getparam[6] = 1
	$oSpaceNames.Item($textchild) = $getparam
	_GUICtrlTreeView_SetChecked($g_GTVEx_aTVData, $hParent, True)
	If Number($getparam[5]) Then _TVUnCheckOther($hPassedItem, $hParent)
	_AutoCheckParents($hParent)
EndFunc   ;==>_AutoCheckParents

Func _TVUnCheckOther($hPassedItem, $hParent)
	Local $text = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $hPassedItem)
	Local $Child, $textchild, $getparam
	$Child = _GUICtrlTreeView_GetFirstChild($g_GTVEx_aTVData, $hParent)
	If Not $Child Then Return
	While 1
		$textchild = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $Child)
		If StringCompare($text, $textchild) Then
			$getparam = $oSpaceNames.Item($textchild)
			$getparam[6] = 0
			$oSpaceNames.Item($textchild) = $getparam
			_GUICtrlTreeView_SetChecked($g_GTVEx_aTVData, $Child, False)
			__TVUnCheck($Child, False)
		EndIf
		$Child = _GUICtrlTreeView_GetNextChild($g_GTVEx_aTVData, $Child)
		If Not $Child Then ExitLoop
	WEnd
EndFunc   ;==>_TVUnCheckOther

Func __TVUnCheck($hPassedItem, $bState, $itemf = False)
	Local $checkpram, $valparam
	$checkpram = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $hPassedItem)
	$valparam = $oSpaceNames.Item($checkpram)
	$valparam[6] = Number($bState)
	$oSpaceNames.Item($checkpram) = $valparam
	Local $hChild = _GUICtrlTreeView_GetFirstChild($g_GTVEx_aTVData, $hPassedItem)
	If $hChild = 0 Then Return
	While 1
		_GUICtrlTreeView_SetChecked($g_GTVEx_aTVData, $hChild, $bState)
		$checkpram = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $hChild)
		$valparam = $oSpaceNames.Item($checkpram)
		$valparam[6] = Number($bState)
		$oSpaceNames.Item($checkpram) = $valparam
		__TVUnCheck($hChild, $bState, $itemf)
		If Not $itemf Then
			$hChild = _GUICtrlTreeView_GetNextChild($g_GTVEx_aTVData, $hChild)
		Else
			$hChild = _GUICtrlTreeView_GetFirstChild($g_GTVEx_aTVData, $hChild)
		EndIf
		If $hChild = 0 Then ExitLoop
	WEnd
EndFunc   ;==>__TVUnCheck
