##icon=WoT.ico
##upx=n
##lang=1049
##comments=  JMPack 1.9
##legalcopyright=Joiner( )
##legaltrademarks=Joiner
##productversion=0.1.9.0
##fileversion=0.1.9.0
##originalfilename=JMinstall.exe
##companyname=Joiner (http://autoit-script.ru)
##productname=JMinstall 1.9
##internalname=JMinstall.exe
##filedescription=    WG
##compile=rtm;v3.3.12.0
##bit=x86

#RequireAdmin
#include <WinAPIDiag.au3>
#include <WinAPIFiles.au3>
#include <WinAPISys.au3>

Local $JMPPR = _WinAPI_OpenFileMapping('MODPACKPROC')
If $JMPPR Then
	Local $RJMP = _WinAPI_MapViewOfFile($JMPPR)
	Local $stData = DllStructCreate('wchar [256]', $RJMP)
	Local $WJM = _WinAPI_EnumProcessWindows(DllStructGetData($stData, 1))
	MsgBox(64, '', 'Installation is already in progress', 0, HWnd($WJM[1][0]))
	Exit
Else
	Local $CJMF = _WinAPI_CreateFileMapping(-1, 1024, 'MODPACKPROC')
	Local $RJMP = _WinAPI_MapViewOfFile($CJMF)
	Local $stData = DllStructCreate('wchar [256]', $RJMP)
	DllStructSetData($stData, 1, @AutoItPID)
EndIf
#include <GuiButton.au3>
#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <TreeViewConstants.au3>
#include <WindowsConstants.au3>
#include <GuiTreeView.au3>
#include <GDIPlus.au3>
#include <UDF\TreeView.au3>
#include <UDF\FileEx.au3>
#include <UDF\7ZipM.au3>
#include <UDF\Icons.au3>
#include <StaticConstants.au3>
#include <Date.au3>
#include <UDF\CDCF.au3>
#include <UDF\IniVirtualSPE.au3>

Opt("TrayMenuMode", 1)
Opt("GUIOnEventMode", 1)
Opt("MustDeclareVars", 1)

Global $vsys
If Number(_WinAPI_GetVersion(), 1) >= 6 Then $vsys = 1
Global $OverallSize, $iPercent, $iWriteSize, $firstproc, $WoT, $pathgame, $itemsetpic, $GP, $PGP, $upd, $activ, $ex, $flagaudio
Global $TmpDir = @TempDir & '\ModTmp', $flagcansel, $wsizetmp = 0, $nameex, $fileex = 1, $flagproc, $coltext = 0xFFFFFF, $colfon = 0x000000, $cprc = 0xFF0000
Global $sFontName = "Georgia", $iFontSize = 10, $iFontWeight = 800, $FontAttrib = 0, $Proc, $WD = @DesktopWidth / 2, $HD = @DesktopHeight / 2, $SW = 0, $WX, $WY, $XWP, $YHP
Global $config = $TmpDir & '\install.jmp', $SWGEX, $URL, $sURL = '', $sInfo = '', $TVP = ''
If FileExists($TmpDir) Then _DelTmp()
DirCreate($TmpDir)
_7ZipStartup()
_7ZIPExtractEx($WoT, _ANSIToOEM(@ScriptFullPath), _ANSIToOEM($TmpDir), 1, 0, 0, 0, 0, 'flash.png', 0, 'shootingatslip')
_GDIPlus_Startup()
If FileExists($TmpDir & '\flash.png') Then
	_WinExFF()
	If @error Then _EXF()
Else
	_EXF()
EndIf
Global $VerWot = IniRead($config, 'title', 'data', '')
If Not $VerWot Then
	MsgBox(16, '', 'Error reading installation file')
	_DelTmp()
	Exit
EndIf
Global $WG = IniRead($config, 'Games', 'game', '')
Global $rebuild = ''
Local $tver = StringTrimLeft($VerWot, StringInStr($VerWot, '.', 0, -1))
If $WG Then
	Switch $WG
		Case 'World of Tanks'
			$SWGEX = '\WorldOfTanks.exe'
			Switch $tver
				Case '0'
					$rebuild = StringTrimRight($VerWot, 2)
				Case '00'
					$rebuild = StringTrimRight($VerWot, 3)
				Case Else
					$rebuild = $VerWot
			EndSwitch
		Case 'World of Warships'
			$SWGEX = '\WorldofWarships.exe'
			$rebuild = $VerWot
	EndSwitch
Else
	MsgBox(16, '', 'Error reading installation file')
EndIf
;~ Local $RCW = IniRead($config, 'Color', 'text', '')
;~ If $RCW Then $coltext = $RCW
Local $RCW = IniRead($config, 'Color', 'fon', '')
If $RCW Then $colfon = $RCW
$RCW = IniRead($config, 'Color', 'prc', '')
If $RCW Then $cprc = $RCW
;~ Global $font = IniReadSection($config, 'Font')
;~ If IsArray($font) Then
;~ 	$FontAttrib = Number($font[1][1])
;~ 	$sFontName = $font[2][1]
;~ 	$iFontSize = Number($font[3][1])
;~ 	$iFontWeight = Number($font[4][1])
;~ EndIf
$sURL = IniRead($config, 'URL', 'URL', '')
$sInfo = IniRead($config, 'TEXT', 'SP', '')
$sInfo = StringReplace($sInfo, '\n', @CRLF)
$sInfo = StringReplace($sInfo, '\h', ' ')
Global $DCM = IniRead($config, 'Date', 'Date', '')
Global $Name = IniRead($config, 'title', 'name', '')
$TVP = IniRead($config, 'title', 'tvp', '')
If $TVP Then $rebuild = $TVP
Global $flagnext = 0, $flagback = 0, $flagpath, $getver = ''
Local $aSoftwareInfo = _CGW()
For $str = 0 To UBound($aSoftwareInfo) - 1
	If $aSoftwareInfo[$str][0] = $WG Then
		If FileExists($aSoftwareInfo[$str][1] & $SWGEX) Then
			$getver = FileGetVersion($aSoftwareInfo[$str][1] & $SWGEX)
			If Not StringCompare($VerWot, $getver) Then
				$pathgame = $aSoftwareInfo[$str][1]
				$flagpath = 1
			Else
				$pathgame = 'Modpack version does not correspond to ' & $WG & ' version'
			EndIf
			ExitLoop
		Else
			$pathgame = 'Path to ' & $WG & ' is not found. Please specify path'
		EndIf
	Else
		$pathgame = 'Path to ' & $WG & ' is not found. Please specify path'
	EndIf
Next
Local $bck = $TmpDir & '\bck0.png'
If Not FileInstall('bck0.png', $bck) Then _exit()
If Not FileInstall('mini.jpg', $TmpDir & '\mini.jpg') Then _exit()
$WoT = GUICreate('', 600, 450, -1, -1, $WS_POPUP, $WS_EX_TOPMOST + $WS_EX_CONTROLPARENT)
GUISetBkColor($colfon)
If FileExists($TmpDir & '\back.png') Then
	Local $hI = _GDIPlus_BitmapCreateFromFile($TmpDir & '\back.png')
	If Not @error Then
		Local $PicBack = GUICtrlCreatePic('', 0, 30, 600, 420, $SS_CENTERIMAGE)
		GUICtrlSetState(-1, $GUI_DISABLE)
		_SetImage($PicBack, $hI, -1)
	EndIf
EndIf
Local $shI = _GDIPlus_BitmapCreateFromFile($bck)
If Not @error Then
	Local $ShP = GUICtrlCreatePic('', 0, 30, 600, 420)
	GUICtrlSetState(-1, $GUI_DISABLE)
	_SetImage($ShP, $shI, -1)
Else
	_exit()
EndIf
Global $LBI = GUICtrlCreateLabel(' ' & $Name, 0, 0, 360, 30, $SS_CENTERIMAGE + $SS_LEFTNOWORDWRAP, $GUI_WS_EX_PARENTDRAG)
GUICtrlSetBkColor(-1, 0x4A4A4A)
GUICtrlSetFont(-1, 14, 800, 0, "Verdana")
GUICtrlSetColor(-1, 0xFFFFFF)
Global $LBIV = GUICtrlCreateLabel($WG & '(' & $rebuild & ')', 360, 0, 220, 30, $SS_CENTERIMAGE, $GUI_WS_EX_PARENTDRAG)
GUICtrlSetBkColor(-1, 0x4A4A4A)
GUICtrlSetFont(-1, 10, 800, 0, "Verdana")
GUICtrlSetColor(-1, 0xFFFFFF)
Global $Mini = GUICtrlCreatePic($TmpDir & '\mini.jpg', 580, 0, 20, 30)
GUICtrlSetTip(-1, 'Collapse')

$URL = GUICtrlCreateLabel('Author page', 10, 410, 200, 25, $SS_CENTERIMAGE)
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
GUICtrlSetFont(-1, 10, 800, 0, "Times New Roman")
GUICtrlSetColor(-1, 0xE5AA70)
GUICtrlSetCursor(-1, 0)
GUICtrlSetTip(-1, "Go to modpack's author page", '', 0, 3)
If Not $sURL Then GUICtrlSetState($URL, $GUI_HIDE)
Global $UnCheck = GUICtrlCreateLabel('', 196, 410, 65, 25, $SS_WHITEFRAME)
GUICtrlSetOnEvent(-1, '_CheckOr')
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
Global $UnCheck1 = GUICtrlCreateLabel('Click', 196, 410, 65, 25, $SS_CENTER + $SS_CENTERIMAGE)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
GUICtrlSetFont(-1, $iFontSize, $iFontWeight, $FontAttrib, $sFontName)
GUICtrlSetColor(-1, $coltext)

Global $Help = GUICtrlCreateLabel('', 190, 410, 80, 25, $SS_WHITEFRAME)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, '_Help')
Global $Help1 = GUICtrlCreateLabel('Help', 190, 410, 80, 25, $SS_CENTER + $SS_CENTERIMAGE)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
GUICtrlSetFont(-1, $iFontSize, $iFontWeight, $FontAttrib, $sFontName)
GUICtrlSetColor(-1, $coltext)

Global $BackUp = GUICtrlCreateLabel('', 284, 410, 80, 25, $SS_WHITEFRAME)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, '_Back')
Global $BackUp1 = GUICtrlCreateLabel('Back', 284, 410, 80, 25, $SS_CENTER + $SS_CENTERIMAGE)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
GUICtrlSetFont(-1, $iFontSize, $iFontWeight, $FontAttrib, $sFontName)
GUICtrlSetColor(-1, $coltext)

Global $Next = GUICtrlCreateLabel('', 385, 410, 80, 25, $SS_WHITEFRAME)
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
GUICtrlSetOnEvent(-1, '_Next')
Global $Next1 = GUICtrlCreateLabel('Next', 385, 410, 80, 25, $SS_CENTER + $SS_CENTERIMAGE)
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
GUICtrlSetFont(-1, $iFontSize, $iFontWeight, $FontAttrib, $sFontName)
GUICtrlSetColor(-1, $coltext)

Global $Cancel = GUICtrlCreateLabel('', 485, 410, 80, 25, $SS_WHITEFRAME)
GUICtrlSetOnEvent(-1, '_Exit')
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
Global $Cancel1 = GUICtrlCreateLabel('Cancel', 485, 410, 80, 25, $SS_CENTER + $SS_CENTERIMAGE)
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
GUICtrlSetFont(-1, $iFontSize, $iFontWeight, $FontAttrib, $sFontName)
GUICtrlSetColor(-1, $coltext)

Global $Path = GUICtrlCreateLabel('', 497, 123, 80, 25, $SS_WHITEFRAME)
GUICtrlSetOnEvent(-1, '_Select')
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)

GUISetState(@SW_SHOW, $WoT)
GUIRegisterMsg(0x0111, 'WM_MINI')
;---------------------------------------------------------------------------------------------
Global $WoT1 = GUICreate("", 582, 370, 10, 35, $WS_POPUP, BitOR($WS_EX_LAYERED, $WS_EX_MDICHILD), $WoT)
GUISetBkColor(0x808080)

Global $InfoString = GUICtrlCreateLabel($sInfo, 110, 5, 360, 330, $GUI_SS_DEFAULT_LABEL)
GUICtrlSetFont(-1, 11, 800, 0, "Arial")
GUICtrlSetColor(-1, $coltext)

Global $Path1 = GUICtrlCreateLabel('Browse', 490, 91, 78, 23, $SS_CENTER + $SS_CENTERIMAGE)
GUICtrlSetFont(-1, 10, 800, 0, "Arial")
GUICtrlSetColor(-1, $coltext)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, '_Select')

Global $FL = GUICtrlCreateLabel('', 40, 118, 505, 24, $SS_WHITEFRAME)
GUICtrlSetState(-1, $GUI_HIDE)
Local $xpr = 43, $lb
Global $aHL[101]
For $i = 1 To 100
	$lb = GUICtrlCreateLabel('', $xpr, 120, 4, 20)
	GUICtrlSetState(-1, $GUI_HIDE)
	GUICtrlSetBkColor(-1, $cprc)
	$aHL[$i] = $lb
	$xpr += 5
Next

Global $PathIstall1 = GUICtrlCreateLabel('', 20, 120, 550, 25, $SS_WHITEFRAME)
GUICtrlSetState(-1, $GUI_HIDE)
Global $PathIstall = GUICtrlCreateLabel($pathgame, 21, 121, 548, 23, $SS_LEFTNOWORDWRAP + $SS_CENTERIMAGE)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetFont(-1, 11, 800, 0, "Arial")
GUICtrlSetColor(-1, $coltext)

Global $noclinst, $setarc

Global $clearInst = GUICtrlCreateCheckbox('', 20, 155, 13, 13)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, '_CheckR1')
GUICtrlSetState(-1, $GUI_CHECKED)
Global $clearInst1 = GUICtrlCreateLabel('Clear install', 35, 155, 200, 20, $SS_LEFTNOWORDWRAP + $SS_CENTERIMAGE)
GUICtrlSetFont(-1, 10, 800, 0, "Arial")
GUICtrlSetColor(-1, $coltext)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, '_CheckR1')
Global $noClear = GUICtrlCreateCheckbox('', 20, 185, 13, 13)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, '_CheckR2')
Global $noClear1 = GUICtrlCreateLabel('Leave as it is', 35, 185, 200, 20, $SS_LEFTNOWORDWRAP + $SS_CENTERIMAGE)
GUICtrlSetFont(-1, 10, 800, 0, "Arial")
GUICtrlSetColor(-1, $coltext)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, '_CheckR2')
Global $reInst = GUICtrlCreateCheckbox('', 20, 215, 13, 13)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, '_CheckR3')
Global $reInst1 = GUICtrlCreateLabel('Renew installation (update)', 35, 215, 280, 20, $SS_LEFTNOWORDWRAP + $SS_CENTERIMAGE)
GUICtrlSetFont(-1, 10, 800, 0, "Arial")
GUICtrlSetColor(-1, $coltext)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, '_CheckR3')
Global $dline = GUICtrlCreateLabel('--------------------------------------------------------------------------------------', 20, 235, 310, 10, $SS_LEFTNOWORDWRAP + $SS_CENTERIMAGE)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetFont(-1, 10, 800, 0, "Arial")
GUICtrlSetColor(-1, $coltext)
Global $arcMod = GUICtrlCreateCheckbox('', 20, 250, 13, 13)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, '_arcMod')
Global $arcMod1 = GUICtrlCreateLabel('Keep installed mods (backup)', 35, 250, 290, 20, $SS_LEFTNOWORDWRAP + $SS_CENTERIMAGE)
GUICtrlSetFont(-1, 10, 800, 0, "Arial")
GUICtrlSetColor(-1, $coltext)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, '_arcMod')

Global $Selection = GUICtrlCreateTreeView(0, 0, 600, 370, BitOR($TVS_DISABLEDRAGDROP, $TVS_HASLINES, $TVS_LINESATROOT, $TVS_CHECKBOXES, $TVS_NOHSCROLL, $TVS_NOTOOLTIPS))
GUICtrlSetFont(-1, 10, 800, 0, 'MS Sans Serif')
GUICtrlSetColor(-1, 0xFFFFFF)
GUICtrlSetBkColor(-1, 0x808080)
GUICtrlSetState(-1, $GUI_HIDE)
GUISetState(@SW_SHOW, $WoT1)
_WinAPI_SetLayeredWindowAttributes($WoT1, 0x808080, 255)
GUIRegisterMsg(0x020A, "WM_MOUSEWHEEL")
;---------------------------------------------------------------------------------------------------
$GP = GUICreate('', $SW, $SW, 0, 0, BitOR($WS_BORDER, $WS_POPUP, $DS_SETFOREGROUND), BitOR($WS_EX_TOOLWINDOW, $WS_EX_TOPMOST), $WoT1)
$PGP = GUICtrlCreatePic('', 0, 0, $SW, $SW)
GUISetState(@SW_HIDE, $GP)
_GUITreeViewEx_InitTV($Selection)

While 1
	Sleep(10)
	If $flagnext = 2 Then
		_TVAutoCheckUncheck()
		_SetPic()
	EndIf
	If $ex Then _exit()
WEnd

Func _Help()
	Local $msbhelp = '1. Clear installation - "res_mods" folder will be cleared' & @CRLF & @CRLF & _
			'2. Leave as it is - "res_mods" folder will remain as it is now' & @CRLF & @CRLF & _
			'3. Reinstall (update) - option to reinstall this modpack again.' & @CRLF & _
			'You can remove/install mods that were previously installed using this modpack.' & @CRLF & _
			'If you choose this option but modpack is being stalled for the first time then Clear installation will proceed' & @CRLF & @CRLF & _
			'4. Keep installed mods (backup) - a copy of "res_mods" folder will be created in game folder before installation' & @CRLF & @CRLF & _
			'P.S. If no modifications are selected then only res_mods clearing will proceed'
	MsgBox(64, 'Installation options', $msbhelp, 0, $WoT)
EndFunc   ;==>_Help

Func _FontInstall($sFile) ; ONLY TTF FONTS!!!
	Local $Font, $Name, $Path
	$Name = _WinAPI_GetFontResourceInfo($sFile, 1)
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	$Name &= ' (TrueType)'
	$Font = StringRegExpReplace($sFile, '^.*\\', '')
	If Not RegWrite('HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Fonts', $Name, 'REG_SZ', $Font) Then
		Return SetError(2, 0, 0)
	EndIf
	$Path = _WinAPI_ShellGetSpecialFolderPath($CSIDL_FONTS)
	If Not FileCopy($sFile, $Path) Then
		RegDelete('HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Fonts', $Name)
		Return SetError(3, 0, 0)
	EndIf
	If Not _WinAPI_AddFontResourceEx($Path & '\' & $Font, 0, 1) Then
		Return SetError(4, 0, 0)
	EndIf
	Return 1
EndFunc   ;==>_FontInstall

Func WM_MINI($hWnd, $iMsg, $wParam, $lParam)
	Local $Msg = BitShift($wParam, 16)
	Switch $hWnd
		Case $WoT
			Switch BitAND($wParam, 0xFFFF)
				Case $Mini
					GUISetState(@SW_MINIMIZE, $WoT)
				Case $URL
					ShellExecute($sURL)
			EndSwitch
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_MINI

Func WM_Exit($hWnd, $Msg, $wParam, $lParam)
	Local $nNotifyCode = BitShift($wParam, 16)
	Local $nID = BitAND($wParam, 0xFFFF)
	Switch $nNotifyCode
		Case 0
			Switch $nID
				Case $Cancel
					$ex = 1
				Case $Mini
					GUISetState(@SW_MINIMIZE, $WoT)
				Case $URL
					ShellExecute($sURL)
			EndSwitch
	EndSwitch
	Return 'GUI_RUNDEFMSG'
EndFunc   ;==>WM_Exit

Func _Scroll($Param)
	Local $dvis
	Local $CursorInfo = GUIGetCursorInfo($WoT1)
	If Not @error And $CursorInfo[4] = $Selection Then
		Local $visf = _GUICtrlTreeView_GetFirstVisible($Selection)
		If $Param = 120 Then
			Local $prch = _GUICtrlTreeView_GetPrev($Selection, $visf)
			_GUICtrlTreeView_EnsureVisible($Selection, $prch)
		ElseIf $Param = -120 Then
			Local $Hit = _GUICtrlTreeView_GetHeight($Selection)
			Local $vc = _GUICtrlTreeView_GetVisibleCount($Selection) * $Hit - 1
			Local $gt = _GUICtrlTreeView_HitTestItem($Selection, 0, $vc)
			$dvis = _GUICtrlTreeView_GetNext($Selection, $gt)
			If Not $dvis Then Return
			_GUICtrlTreeView_EnsureVisible($Selection, $dvis)
		EndIf
	EndIf
EndFunc   ;==>_Scroll

Func WM_MOUSEWHEEL($hWndGui, $MsgId, $wParam, $lParam)
	Local $GSTWH = BitShift($wParam, 16)
	_Scroll($GSTWH)
EndFunc   ;==>WM_MOUSEWHEEL

Func _CheckOr()
	_TV_UnCheck()
EndFunc   ;==>_CheckOr

Func _EXF()
	_7ZIPExtractEx($WoT, _ANSIToOEM(@ScriptFullPath), _ANSIToOEM($TmpDir), 1, 0, 0, 0, 0, 'back.png', 0, 'shootingatslip')
	_7ZIPExtractEx($WoT, _ANSIToOEM(@ScriptFullPath), _ANSIToOEM($TmpDir), 1, 0, 0, 0, 0, '*.jpg;*.jmp', 0, 'shootingatslip')
	_7ZipShutdown()
EndFunc   ;==>_EXF

Func _arcMod()
	If Not $setarc Then
		GUICtrlSetState($arcMod, $GUI_CHECKED)
		$setarc = 1
	Else
		GUICtrlSetState($arcMod, $GUI_UNCHECKED)
		$setarc = 0
	EndIf
EndFunc   ;==>_arcMod

Func _CheckR1()
	GUICtrlSetState($clearInst, $GUI_CHECKED)
	GUICtrlSetState($noClear, $GUI_UNCHECKED)
	GUICtrlSetState($reInst, $GUI_UNCHECKED)
	$upd = 0
	$noclinst = 0
EndFunc   ;==>_CheckR1

Func _CheckR2()
	GUICtrlSetState($clearInst, $GUI_UNCHECKED)
	GUICtrlSetState($noClear, $GUI_CHECKED)
	GUICtrlSetState($reInst, $GUI_UNCHECKED)
	$upd = 0
	$noclinst = 1
EndFunc   ;==>_CheckR2

Func _CheckR3()
	GUICtrlSetState($clearInst, $GUI_UNCHECKED)
	GUICtrlSetState($noClear, $GUI_UNCHECKED)
	GUICtrlSetState($reInst, $GUI_CHECKED)
	$upd = 1
	$noclinst = 0
EndFunc   ;==>_CheckR3

Func _WinExFF()
	Local $hImage = _GDIPlus_ImageLoadFromFile($TmpDir & '\flash.png')
	If @error Then Return SetError(1)
	Local $XW = _GDIPlus_ImageGetWidth($hImage)
	Local $YH = _GDIPlus_ImageGetHeight($hImage)
	Local $hGui = GUICreate('', $XW, $YH, -1, -1, $WS_POPUP, BitOR($WS_EX_TOOLWINDOW, $WS_EX_LAYERED, $WS_EX_TOPMOST))
	GUISetState()
	Local $hScrDC = _WinAPI_GetDC($hGui)
	Local $hMemDC = _WinAPI_CreateCompatibleDC($hScrDC)
	Local $hBitmap = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hImage)
	Local $hOld = _WinAPI_SelectObject($hMemDC, $hBitmap)
	Local $tSize = DllStructCreate($tagSIZE)
	Local $pSize = DllStructGetPtr($tSize)
	DllStructSetData($tSize, 'X', $XW)
	DllStructSetData($tSize, 'Y', $YH)
	Local $tSource = DllStructCreate($tagPOINT)
	Local $pSource = DllStructGetPtr($tSource)
	Local $tBlend = DllStructCreate($tagBLENDFUNCTION)
	Local $pBlend = DllStructGetPtr($tBlend)
	DllStructSetData($tBlend, 'Format', 1)
	For $i = 0 To 255 Step 5
		DllStructSetData($tBlend, 'Alpha', $i)
		_WinAPI_UpdateLayeredWindow($hGui, $hScrDC, 0, $pSize, $hMemDC, $pSource, 0, $pBlend, $ULW_ALPHA)
		Sleep(30)
	Next
	_EXF()
	Sleep(2000)
	For $i = 255 To 0 Step -5
		DllStructSetData($tBlend, 'Alpha', $i)
		_WinAPI_UpdateLayeredWindow($hGui, $hScrDC, 0, $pSize, $hMemDC, $pSource, 0, $pBlend, $ULW_ALPHA)
		Sleep(30)
	Next
	GUIDelete($hGui)
	_GDIPlus_ImageDispose($hImage)
	_WinAPI_ReleaseDC($hGui, $hScrDC)
	_WinAPI_SelectObject($hMemDC, $hOld)
	_WinAPI_DeleteObject($hBitmap)
	_WinAPI_DeleteDC($hMemDC)
EndFunc   ;==>_WinExFF

Func _WinMove($WX, $WY)
	Local $CHPM = MouseGetPos()
	Local $erchpm = @error
	If Not $erchpm Then
		Local $X = $CHPM[0], $Y = $CHPM[1]
		If $X > $WD Then
			$X = $X - $WX - 5
		Else
			$X = $X + 5
		EndIf
		If $Y > $HD Then
			$Y = $Y - $WY - 5
		Else
			$Y = $Y + 5
		EndIf
		WinMove($GP, '', $X, $Y, $WX, $WY)
		GUICtrlSetPos($PGP, 0, 0, $WX, $WY)
	EndIf
EndFunc   ;==>_WinMove

Func _SetPic()
	Local $CursorInfo = GUIGetCursorInfo($WoT1)
	If Not @error And $CursorInfo[4] = $Selection Then
		$activ = 1
		_WinMove($XWP, $YHP)
		Local $hitemcursor = _GUICtrlTreeView_HitTestItem($g_GTVEx_aTVData, $CursorInfo[0], $CursorInfo[1])
		If $hitemcursor Then
			Local $HT = _GUICtrlTreeView_HitTest($g_GTVEx_aTVData, $CursorInfo[0], $CursorInfo[1])
			If $HT = 4 Or $HT = 64 Then
				Local $textpath = _GUICtrlTreeView_GetItemParam($g_GTVEx_aTVData, $hitemcursor)
				If Not StringCompare($textpath, $itemsetpic) Then
					Return
				EndIf
				If FileExists($TmpDir & '\' & $textpath & '.jpg') Then
					Local $hI = _GDIPlus_ImageLoadFromFile($TmpDir & '\' & $textpath & '.jpg')
					$XWP = _GDIPlus_ImageGetWidth($hI)
					$YHP = _GDIPlus_ImageGetHeight($hI)
					_GDIPlus_BitmapDispose($hI)
					_WinMove($XWP, $YHP)
					GUICtrlSetImage($PGP, $TmpDir & '\' & $textpath & '.jpg')
					GUISetState(@SW_SHOW, $GP)
				Else
					If BitAND(WinGetState($GP), 15) Then
						GUISetState(@SW_HIDE, $GP)
					EndIf
				EndIf
				$itemsetpic = $textpath
			Else
				If BitAND(WinGetState($GP), 15) Then
					GUISetState(@SW_HIDE, $GP)
					$itemsetpic = 0
				EndIf
			EndIf
		Else
			If BitAND(WinGetState($GP), 15) Then
				GUISetState(@SW_HIDE, $GP)
				$itemsetpic = 0
			EndIf
		EndIf
	Else
		If BitAND(WinGetState($GP), 15) Then
			GUISetState(@SW_HIDE, $GP)
			$itemsetpic = 0
			If $activ Then
				WinActivate($WoT)
				$activ = 0
			EndIf
		EndIf
	EndIf
EndFunc   ;==>_SetPic

Func _Select()
	GUISetState(@SW_DISABLE, $WoT)
	Local $Pathinst = FileSelectFolder('Browse folder ' & $WG, "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", 2, '', $WoT)
	GUISetState(@SW_ENABLE, $WoT)
	If $Pathinst Then
		If FileExists($Pathinst & $SWGEX) Then
			$getver = FileGetVersion($Pathinst & $SWGEX)
			If Not StringCompare($VerWot, $getver) Then
				GUICtrlSetData($PathIstall, $Pathinst)
				$flagpath = 1
				GUICtrlSetState($Next, $GUI_ENABLE)
				GUICtrlSetState($Next1, $GUI_ENABLE)
			Else
				$flagpath = 0
				GUICtrlSetState($Next, $GUI_DISABLE)
				GUICtrlSetState($Next1, $GUI_DISABLE)
				GUICtrlSetData($PathIstall, 'Modpack version does not correspond to ' & $WG & ' version')
			EndIf
		Else
			$flagpath = 0
			GUICtrlSetData($PathIstall, 'Path to ' & $WG & ' is not found. Please specify path')
			GUICtrlSetState($Next, $GUI_DISABLE)
			GUICtrlSetState($Next1, $GUI_DISABLE)
		EndIf
	EndIf
EndFunc   ;==>_Select

Func _Next()
	Switch $flagnext
		Case 0
			If Not $flagpath Then
				GUICtrlSetState($Next, $GUI_DISABLE)
				GUICtrlSetState($Next1, $GUI_DISABLE)
			EndIf
			GUICtrlSetState($Help, $GUI_SHOW)
			GUICtrlSetState($Help1, $GUI_SHOW)
			GUICtrlSetState($PathIstall, $GUI_SHOW)
			GUICtrlSetState($PathIstall1, $GUI_SHOW)
			GUICtrlSetState($Path, $GUI_SHOW)
			GUICtrlSetState($Path1, $GUI_SHOW)
			GUICtrlSetPos($InfoString, 110, 45, 360, 50)
			GUICtrlSetStyle($InfoString, $SS_CENTER)
			GUICtrlSetData($InfoString, 'Installation path')
			GUICtrlSetState($BackUp, $GUI_SHOW)
			GUICtrlSetState($BackUp1, $GUI_SHOW)
			GUICtrlSetState($clearInst, $GUI_SHOW)
			GUICtrlSetState($arcMod, $GUI_SHOW)
			GUICtrlSetState($noClear, $GUI_SHOW)
			GUICtrlSetState($reInst, $GUI_SHOW)
			GUICtrlSetState($clearInst1, $GUI_SHOW)
			GUICtrlSetState($arcMod1, $GUI_SHOW)
			GUICtrlSetState($noClear1, $GUI_SHOW)
			GUICtrlSetState($reInst1, $GUI_SHOW)
			GUICtrlSetState($dline, $GUI_SHOW)
			$flagnext = 1
			$flagback = 1
		Case 1
			If Not _GUICtrlTreeView_GetCount($Selection) Then
				GUISetState(@SW_DISABLE, $WoT)
				_GUITreeViewEx_LoadTV(1, $TmpDir, GUICtrlRead($PathIstall))
				If @error Then
					GUIDelete($WoT)
					MsgBox(16, '', 'Error loading installation choice')
					_DelTmp()
					Exit
				EndIf
				_GUICtrlTreeView_SetFocused($Selection, _GUICtrlTreeView_GetFirstItem($Selection), True)
				GUISetState(@SW_ENABLE, $WoT)
			EndIf
			GUICtrlSetState($Help, $GUI_HIDE)
			GUICtrlSetState($Help1, $GUI_HIDE)
			GUICtrlSetState($dline, $GUI_HIDE)
			GUICtrlSetState($clearInst1, $GUI_HIDE)
			GUICtrlSetState($arcMod1, $GUI_HIDE)
			GUICtrlSetState($noClear1, $GUI_HIDE)
			GUICtrlSetState($reInst1, $GUI_HIDE)
			GUICtrlSetState($clearInst, $GUI_HIDE)
			GUICtrlSetState($arcMod, $GUI_HIDE)
			GUICtrlSetState($noClear, $GUI_HIDE)
			GUICtrlSetState($reInst, $GUI_HIDE)
			GUICtrlSetState($UnCheck, $GUI_SHOW)
			GUICtrlSetState($UnCheck1, $GUI_SHOW)
			GUICtrlSetState($PathIstall, $GUI_HIDE)
			GUICtrlSetState($PathIstall1, $GUI_HIDE)
			GUICtrlSetState($Path, $GUI_HIDE)
			GUICtrlSetState($Path1, $GUI_HIDE)
			GUICtrlSetState($InfoString, $GUI_HIDE)
			GUICtrlSetData($Next, 'Start')
			GUICtrlSetState($Selection, $GUI_SHOW)
			WinActivate($WoT)
			$flagnext = 2
			$flagback = 2
		Case 2
			_GDIPlus_Shutdown()
			Local $gamedir = GUICtrlRead($PathIstall)
			If Not $upd Then FileDelete($gamedir & '\' & $DCM & '.jmp')
			GUICtrlSetState($Selection, $GUI_HIDE)
			GUICtrlSetState($UnCheck, $GUI_HIDE)
			GUICtrlSetState($UnCheck1, $GUI_HIDE)
			GUICtrlSetState($InfoString, $GUI_SHOW)
			GUICtrlSetState($BackUp, $GUI_HIDE)
			GUICtrlSetState($BackUp1, $GUI_HIDE)
			GUICtrlSetState($Next, $GUI_HIDE)
			GUICtrlSetState($Next1, $GUI_HIDE)
			GUICtrlSetState($FL, $GUI_SHOW)
			$flagnext = 3
			GUIRegisterMsg(0x020A, "")
			If Not FileExists(($gamedir & '\' & $DCM & '.jmp')) Then $upd = 0
			_GUITreeViewEx_SaveTV('', '', 2, $gamedir, $upd)
			If UBound($aChecked) = 1 Then
				GUICtrlSetData($InfoString, 'Deleting game modifications')
				_Cansel($gamedir)
				_End($WG & ' modifications are deleted')
				Return
			EndIf
			_GUITreeViewEx_CloseTV()
			_GUICtrlTreeView_Destroy($Selection)
			Opt("GUIOnEventMode", 0)
			_Install($gamedir)
	EndSwitch
EndFunc   ;==>_Next

Func _ProcN()
	For $i = 100 To 1 Step -1
		GUICtrlSetState($aHL[$i], $GUI_HIDE)
	Next
EndFunc   ;==>_ProcN

Func _Back()
	Switch $flagback
		Case 1
			GUICtrlSetState($Help, $GUI_HIDE)
			GUICtrlSetState($Help1, $GUI_HIDE)
			GUICtrlSetState($BackUp, $GUI_HIDE)
			GUICtrlSetState($BackUp1, $GUI_HIDE)
			GUICtrlSetState($Path, $GUI_HIDE)
			GUICtrlSetState($Path1, $GUI_HIDE)
			GUICtrlSetState($PathIstall, $GUI_HIDE)
			GUICtrlSetState($PathIstall1, $GUI_HIDE)
			GUICtrlSetPos($InfoString, 110, 5, 360, 330)
			GUICtrlSetStyle($InfoString, $GUI_SS_DEFAULT_LABEL)
			GUICtrlSetData($InfoString, $sInfo)
			GUICtrlSetState($Next, $GUI_ENABLE)
			GUICtrlSetState($Next1, $GUI_ENABLE)
			GUICtrlSetState($dline, $GUI_HIDE)
			GUICtrlSetState($clearInst1, $GUI_HIDE)
			GUICtrlSetState($arcMod1, $GUI_HIDE)
			GUICtrlSetState($noClear1, $GUI_HIDE)
			GUICtrlSetState($reInst1, $GUI_HIDE)
			GUICtrlSetState($clearInst, $GUI_HIDE)
			GUICtrlSetState($arcMod, $GUI_HIDE)
			GUICtrlSetState($noClear, $GUI_HIDE)
			GUICtrlSetState($reInst, $GUI_HIDE)
			$flagnext = 0
			$flagback = 0
		Case 2
			GUICtrlSetState($Help, $GUI_SHOW)
			GUICtrlSetState($Help1, $GUI_SHOW)
			GUICtrlSetState($PathIstall, $GUI_SHOW)
			GUICtrlSetState($PathIstall1, $GUI_SHOW)
			GUICtrlSetState($Path, $GUI_SHOW)
			GUICtrlSetState($Path1, $GUI_SHOW)
			GUICtrlSetState($InfoString, $GUI_SHOW)
			GUICtrlSetData($InfoString, 'Installation path')
			GUICtrlSetData($Next1, 'Next')
			GUICtrlSetState($Selection, $GUI_HIDE)
			GUICtrlSetState($UnCheck, $GUI_HIDE)
			GUICtrlSetState($UnCheck1, $GUI_HIDE)
			GUICtrlSetState($clearInst, $GUI_SHOW)
			GUICtrlSetState($arcMod, $GUI_SHOW)
			GUICtrlSetState($noClear, $GUI_SHOW)
			GUICtrlSetState($reInst, $GUI_SHOW)
			GUICtrlSetState($clearInst1, $GUI_SHOW)
			GUICtrlSetState($arcMod1, $GUI_SHOW)
			GUICtrlSetState($noClear1, $GUI_SHOW)
			GUICtrlSetState($reInst1, $GUI_SHOW)
			GUICtrlSetState($dline, $GUI_SHOW)
			$flagnext = 1
			$flagback = 1
	EndSwitch
EndFunc   ;==>_Back

Func WM_COMMAND($hWnd, $Msg, $wParam, $lParam)
	Local $nNotifyCode = BitShift($wParam, 16)
	Local $nID = BitAND($wParam, 0xFFFF)
	Switch $nNotifyCode
		Case 0
			Switch $nID
				Case $Cancel
					$flagcansel = 1
				Case $Mini
					GUISetState(@SW_MINIMIZE, $WoT)
				Case $URL
					ShellExecute($sURL)
			EndSwitch
	EndSwitch
	Return 'GUI_RUNDEFMSG'
EndFunc   ;==>WM_COMMAND

Func _Update($gd)
	Local $ir, $if = $gd & '\' & $DCM & '.jmp', $Rini
	$Rini = FileRead($if)
	If @error Then Return SetError(1)
	GUICtrlSetData($InfoString, 'Deleting unused modifications')
	For $i = 1 To UBound($aDellMod) - 1
		$ir = _IniVirtualSPE_ReadSection($Rini, $aDellMod[$i])
		If @error Then ContinueLoop ;Return SetError(1)
		For $d = 1 To $ir[0][0]
			FileDelete($ir[$d][1])
		Next
		IniDelete($if, $aDellMod[$i])
	Next
	If $WG = 'World of Warships' Then
		If FileExists($gd & '\res_mods\' & $rebuild & '\audio') Then
			GUICtrlSetData($InfoString, 'Checking res_mods files')
			Local $rp
			Switch $vsys
				Case 0
					Local $resaudio = _FileSearch($gd & '\res\audio')
					If @error Then Return
					For $i = 1 To $resaudio[0]
						$rp = StringReplace($resaudio[$i], $gd & '\res\', $gd & '\res_mods\' & $rebuild & '\', 1)
						_FLC($resaudio[$i], $rp)
					Next
				Case 1
					_SymLnk($gd & '\res\audio', $gd, $rebuild, 'audio')
					If @error Then Return SetError(@error)
			EndSwitch
		EndIf
	EndIf
	For $i = 1 To UBound($aChecked) - 1
		IniReadSection($if, $aChecked[$i][0])
		If Not @error And Not $aChecked[$i][1] Then $aChecked[$i][0] = ''
	Next
EndFunc   ;==>_Update

Func _SymLnk($ResFl, $PathG, $Nvc, $FD = '', $up = 0)
	Local $aAdjust, $prepres
	Local $hToken = _WinAPI_OpenProcessToken(BitOR($TOKEN_ADJUST_PRIVILEGES, $TOKEN_QUERY))
	_WinAPI_AdjustTokenPrivileges($hToken, $SE_CREATE_SYMBOLIC_LINK_NAME, $SE_PRIVILEGE_ENABLED, $aAdjust)
	If @error Or @extended Then
		_WinAPI_AdjustTokenPrivileges($hToken, $aAdjust, 0, $aAdjust)
		_WinAPI_CloseHandle($hToken)
		Return SetError(1)
	EndIf
	Local $rp
	Local $res = _FileSearch($ResFl)
	If @error Then
		_WinAPI_AdjustTokenPrivileges($hToken, $aAdjust, 0, $aAdjust)
		_WinAPI_CloseHandle($hToken)
		Return
	EndIf
	DirCreate($PathG & '\res_mods\' & $Nvc & '\' & $FD)
	Local $fod, $cfod, $pfod, $tmpp, $l = 1, $t
	Local $CF = Number($res[0])
	For $i = 1 To $res[0]
		If $flagcansel Then Return SetError(2)
		$rp = StringReplace($res[$i], $PathG & '\res\', $PathG & '\res_mods\' & $Nvc & '\', 1)
		$prepres = StringLeft($rp, StringInStr($rp, '\', 0, -1) - 1)
		DirCreate($prepres)
		If Not _WinAPI_CreateSymbolicLink($rp, $res[$i]) Then
			If Not $up Then
				_FLC($res[$i], $rp)
				If @error Then
					_WinAPI_AdjustTokenPrivileges($hToken, $aAdjust, 0, $aAdjust)
					_WinAPI_CloseHandle($hToken)
					Return SetError(3)
				EndIf
			Else
				_FLC($res[$i], $rp, 1, 1)
				If @error Then
					_WinAPI_AdjustTokenPrivileges($hToken, $aAdjust, 0, $aAdjust)
					_WinAPI_CloseHandle($hToken)
					Return SetError(3)
				EndIf
			EndIf
		EndIf
		$cfod += 1
		$pfod = Floor($cfod / $CF * 100)
		If $pfod <= 100 Then
			If $tmpp < $pfod Then
				$t = 0
				For $d = $l To $pfod
					GUICtrlSetState($aHL[$d], $GUI_SHOW)
					$t += 1
				Next
				$l += $t
				$tmpp = $pfod
			EndIf
		EndIf
	Next
	_WinAPI_AdjustTokenPrivileges($hToken, $aAdjust, 0, $aAdjust)
	_WinAPI_CloseHandle($hToken)
	Sleep(500)
	_ProcN()
EndFunc   ;==>_SymLnk

Func _Install($gamedir)
	GUIRegisterMsg(0x0111, 'WM_MINI')
	Local $valparam, $oname, $inclfile, $pathtext, $totaltext, $filestext, $copyres, $inclcopy, $totalcount
	Local $totalaudio, $filesaudio, $overproc, $perc, $filesres, $in, $origfile, $destfile, $pathdel, $pathaudio
	GUICtrlSetState($Cancel, $GUI_DISABLE)
	GUICtrlSetState($Cancel1, $GUI_DISABLE)
	If $setarc Then
		GUICtrlSetData($InfoString, 'Creating res_mods backup')
		Local $namearcres
		While 1
			$namearcres = Random(1, 100000, 1)
			If Not FileExists($gamedir & '\' & $namearcres & '_res_mods') Then ExitLoop
			Sleep(1)
		WEnd
		DirCreate($gamedir & '\' & $namearcres & '_res_mods\res_mods\' & $rebuild)
		Local $aResBackup[1][2]
		$aResBackup[0][0] = $gamedir & '\res_mods'
		$aResBackup[0][1] = $gamedir & '\' & $namearcres & '_res_mods'
		_CDCF($aResBackup, 0, '', 0, $Proc, $Cancel, 1, 0, $cprc, $aHL, 2, $WoT, $Mini, $URL, $sURL)
	EndIf
	GUIRegisterMsg(0x0111, 'WM_MINI')
	If $upd Then
		_Update($gamedir)
		If @error = 1 Or @error = 3 Then
			GUICtrlSetData($InfoString, 'Cancelling installation' & @CRLF & 'Error copying files')
			_End('Installation cancelled' & @CRLF & 'Error copying files')
			Return
		ElseIf @error = 2 Then
			GUICtrlSetData($InfoString, 'Cancelling installation')
			_End('Installation cancelled by user')
			Return
		EndIf
	EndIf
	For $i = 1 To UBound($aChecked) - 1
		If $aChecked[$i][0] Then
			$oname = Number($aChecked[$i][0])
			$valparam = $oSpaceNames.Item($oname)
			$totalcount += Number($valparam[1])
;~ 			If Number($valparam[3]) = 1 Then $flagtext = 1
			If Number($valparam[4]) = 1 Then $flagaudio = 1
			$inclfile &= '*.' & $aChecked[$i][0] & ';'
			$inclcopy &= $aChecked[$i][0] & '|'
		EndIf
	Next
	$inclfile = StringTrimRight($inclfile, 1)
;~ 	;-------------------------------------------------
;~ 	FileWrite(@ScriptDir & '\bagin.txt', $inclfile) ;test
;~ 	;-------------------------------------------------
	$inclcopy = StringTrimRight($inclcopy, 1)
	If Not $inclcopy Then
		_End('Modifications configuration updated')
		Return
	EndIf
	If $upd = 0 And $noclinst = 0 Then
		GUICtrlSetData($InfoString, 'Clearing res_mods folde')
		_DirRemove($gamedir & '\res_mods')
		DirCreate($gamedir & '\res_mods\' & $rebuild)
	EndIf
	If $WG = 'World of Warships' Then
		If $flagaudio Then
			If Not FileExists($gamedir & '\res_mods\' & $rebuild & '\audio') Then
				$pathaudio = $gamedir & '\res\audio'
			Else
				$pathaudio = ''
			EndIf
		EndIf
	EndIf
	GUICtrlSetData($InfoString, 'Unpacking chosen packages')
	Local $MapFile = _WinAPI_CreateFileMapping(-1, 4194304, 'DataExchangeFile')
	If $MapFile = 0 Then
		GUIDelete($WoT)
		MsgBox(16, '', 'Error creating virtual file')
		_DelTmp()
		Exit
	EndIf
	Local $PosFile = _WinAPI_MapViewOfFile($MapFile)
	If $PosFile = 0 Then
		GUIDelete($WoT)
		MsgBox(16, '', 'Error reading virtual file')
		_DelTmp()
		Exit
	EndIf
	Local $StructFile = DllStructCreate('wchar arc[512];wchar dest[512];wchar incl[1048576];int total[12];int perc[12];int exit;int err', $PosFile)
	DllStructSetData($StructFile, 'arc', @ScriptFullPath)
	DllStructSetData($StructFile, 'dest', $TmpDir)
	DllStructSetData($StructFile, 'incl', $inclfile)
	DllStructSetData($StructFile, 'total', $totalcount)
	Local $instEx = FileInstall('Ex7.exe', $TmpDir & '\Ex7.exe', 1)
	If Not $instEx Then
		GUICtrlSetData($InfoString, 'Error unpacking files' & @CRLF & 'Cancelling changes')
		GUICtrlSetState($Cancel, $GUI_DISABLE)
		GUICtrlSetState($Cancel1, $GUI_DISABLE)
		FileDelete($gamedir & '\' & $DCM & '.jmp')
		_DirRemove($TmpDir)
		_End('Error unpacking files' & @CRLF & 'Unable to start unpacking module')
		Return
	EndIf
	Local $Pid = Run($TmpDir & '\Ex7.exe')
	Local $waitproc = ProcessWait('Ex7.exe', 5)
	If Not $waitproc Then
		GUICtrlSetData($InfoString, 'Error unpacking files' & @CRLF & 'Cancelling changes')
		GUICtrlSetState($Cancel, $GUI_DISABLE)
		GUICtrlSetState($Cancel1, $GUI_DISABLE)
		FileDelete($gamedir & '\' & $DCM & '.jmp')
		_DirRemove($TmpDir)
		_End('Error unpacking files' & @CRLF & 'Unable to start unpacking module')
		Return
	EndIf
	GUIRegisterMsg(0x0111, 'WM_COMMAND')
	GUICtrlSetState($Cancel, $GUI_ENABLE)
	GUICtrlSetState($Cancel1, $GUI_ENABLE)
	Local $percent, $tmpp, $d, $l = 1, $t
	While 1
		Select
			Case DllStructGetData($StructFile, 'exit') <> 1 And DllStructGetData($StructFile, 'err') <> 1 And ProcessExists($Pid) = 0
				GUICtrlSetData($InfoString, 'Error unpacking files' & @CRLF & 'Restoring changes')
				GUICtrlSetState($Cancel, $GUI_DISABLE)
				GUICtrlSetState($Cancel1, $GUI_DISABLE)
				FileDelete($gamedir & '\' & $DCM & '.jmp')
				_DirRemove($TmpDir)
				_End('Error unpacking files' & @CRLF & 'Unpacking module stoppeds')
				Return
			Case DllStructGetData($StructFile, 'exit') = 1
				ExitLoop
			Case $flagcansel = 1
				GUICtrlSetState($Cancel, $GUI_DISABLE)
				GUICtrlSetState($Cancel1, $GUI_DISABLE)
				GUICtrlSetData($InfoString, 'Installation cancelled' & @CRLF & 'Restoring changes')
				DllStructSetData($StructFile, 'exit', 1)
				ProcessWaitClose($Pid, 5)
				ProcessClose($Pid)
				FileDelete($gamedir & '\' & $DCM & '.jmp')
				_DirRemove($TmpDir)
				_End('Installation cancelled')
				Return
			Case DllStructGetData($StructFile, 'err') = 1
				GUICtrlSetData($InfoString, 'Error unpacking files' & @CRLF & 'Restoring changes')
				GUICtrlSetState($Cancel, $GUI_DISABLE)
				GUICtrlSetState($Cancel1, $GUI_DISABLE)
				FileDelete($gamedir & '\' & $DCM & '.jmp')
				_DirRemove($TmpDir)
				_End('Error unpacking files')
				Return
		EndSelect
		$percent = Floor(DllStructGetData($StructFile, 'perc'))
		If $percent <= 100 Then
			If $tmpp < $percent Then
				$t = 0
				For $d = $l To $percent
					GUICtrlSetState($aHL[$d], $GUI_SHOW)
					$t += 1
				Next
				$l += $t
				$tmpp = $percent
			EndIf
		EndIf
		Sleep(10)
	WEnd
	If $pathaudio Then
		Sleep(500)
		_ProcN()
		GUICtrlSetData($InfoString, 'Copying original files')
		Switch $vsys
			Case 0
				Local $FileSource[1][2]
				$FileSource[0][0] = $pathaudio
				$FileSource[0][1] = $gamedir & '\res_mods\' & $rebuild
				_CDCF($FileSource, 0, '', 0, $Proc, $Cancel, 1, 0, $cprc, $aHL, 0, $WoT, $Mini, $URL, $sURL)
				Local $ercodout = @error
				Switch $ercodout
					Case 1
						GUICtrlSetData($InfoString, 'Installation error' & @CRLF & 'Restoring changes')
						_Cansel($gamedir)
						_End('Installation cancelled')
						Return
					Case 2
						GUICtrlSetData($InfoString, 'Installation error' & @CRLF & 'Restoring changes')
						_Cansel($gamedir)
						_End('Error copying files - ' & $ercodout)
						Return
				EndSwitch
			Case 1
				_SymLnk($pathaudio, $gamedir, $rebuild, 'audio', 1)
				Local $ercodout = @error
				If $ercodout = 1 Or $ercodout = 4 Then
					GUICtrlSetData($InfoString, 'Installation error' & @CRLF & 'Restoring changes')
					_Cansel($gamedir)
					_End('Error copying files - ' & $ercodout)
					Return
				ElseIf $ercodout = 3 Then
					GUICtrlSetData($InfoString, 'Installation error' & @CRLF & 'Restoring changes')
					_Cansel($gamedir)
					_End('Installation cancelled')
					Return
				EndIf
		EndSwitch
	EndIf
	GUIRegisterMsg(0x0111, 'WM_MINI')
	Sleep(500)
	_ProcN()
	GUICtrlSetData($InfoString, 'Installing modifications')
	Local $FileSource[1][2]
	$FileSource[0][0] = $TmpDir & '\res_mods'
	$FileSource[0][1] = $gamedir
	If $upd = 1 Or $noclinst = 1 Then
		$vsys = 1
	ElseIf $upd = 0 Or $noclinst = 0 Then
		$vsys = 0
	EndIf
	Local $instfile = _CDCF($FileSource, -1, $inclcopy, 2, $Proc, $Cancel, 1, 1, $cprc, $aHL, $vsys, $WoT, $Mini, $URL, $sURL)
	Switch @error
		Case 1
			GUICtrlSetData($InfoString, 'Cancelling installation' & @CRLF & 'Restoring changes')
			_Cansel($gamedir)
			_End('Installation cancelled')
			Return
		Case 2
			GUICtrlSetData($InfoString, 'Cancelling installation' & @CRLF & 'Restoring changes')
			_Cansel($gamedir)
			_End('Error copying files')
			Return
	EndSwitch
	GUIRegisterMsg(0x0111, 'WM_MINI')
	GUICtrlSetState($Cancel, $GUI_DISABLE)
	GUICtrlSetState($Cancel1, $GUI_DISABLE)
	If Not $upd Then
		Local $Fonts = _FileSearch($TmpDir, 'ttf', 2, 1, 2)
		If Not @error Then
			GUICtrlSetData($InfoString, 'Installing fonts')
			For $i = 0 To UBound($Fonts) - 1
				_FontInstall($Fonts[$i])
			Next
		EndIf
	EndIf
	If $instfile Then
		Local $fo = FileOpen($gamedir & '\' & $DCM & '.jmp', 1)
		FileWrite($fo, StringTrimRight($instfile, 2))
		FileClose($fo)
	EndIf
	Sleep(500)
	_ProcN()
	GUICtrlSetData($InfoString, 'Deleting temporary files')
	_DirRemove($TmpDir)
	If $upd Then
		_End('Modifications configuration updated')
	Else
		_End($WG & ' modifications installed')
	EndIf
EndFunc   ;==>_Install

Func _End($sString)
	For $i = 1 To 100
		GUICtrlSetState($aHL[$i], $GUI_HIDE)
	Next
	GUICtrlSetState($FL, $GUI_HIDE)
	GUICtrlSetData($InfoString, $sString)
	GUICtrlSetState($Cancel, $GUI_ENABLE)
	GUICtrlSetState($Cancel1, $GUI_ENABLE)
	GUICtrlSetData($Cancel1, 'Close')
	GUIRegisterMsg(0x0111, 'WM_Exit')
EndFunc   ;==>_End

Func _Cansel($gamedir)
	GUICtrlSetState($Cancel, $GUI_DISABLE)
	GUICtrlSetState($Cancel1, $GUI_DISABLE)
	FileDelete($gamedir & '\' & $DCM & '.jmp')
	_DirRemove($TmpDir)
	_DirRemove($gamedir & '\res_mods')
	DirCreate($gamedir & '\res_mods\' & $rebuild)
EndFunc   ;==>_Cansel

Func _exit()
	GUIDelete($WoT)
	_DelTmp()
	Exit
EndFunc   ;==>_exit

Func _DelTmp()
	Local $FTR = _FileSearch($TmpDir)
	If Not @error Then
		For $i = 1 To $FTR[0]
			FileDelete($FTR[$i])
		Next
	EndIf
	Local $emptd = _FileSearch($TmpDir, '', 3)
	If Not @error Then
		For $i = UBound($emptd) - 1 To 0 Step -1
			DirRemove($emptd[$i])
		Next
	EndIf
	DirRemove($TmpDir)
EndFunc   ;==>_DelTmp

Func _DirRemove($PF)
	_7ZipShutdown()
	_ProcN()
	Local $fod, $cfod, $pfod, $tmpp, $l = 1, $t
	Local $FTR = _FileSearch($PF)
	If Not @error Then
		Local $CF = Number($FTR[0])
		For $i = 1 To $FTR[0]
			FileDelete($FTR[$i])
			$cfod += 1
			$pfod = Floor($cfod / $CF * 100)
			If $pfod <= 100 Then
				If $tmpp < $pfod Then
					$t = 0
					For $d = $l To $pfod
						GUICtrlSetState($aHL[$d], $GUI_SHOW)
						$t += 1
					Next
					$l += $t
					$tmpp = $pfod
				EndIf
			EndIf
		Next
	EndIf
	Local $emptd = _FileSearch($PF, '', 3)
	If Not @error Then
		For $i = UBound($emptd) - 1 To 0 Step -1
			DirRemove($emptd[$i])
		Next
	EndIf
	DirRemove($PF)
	_ProcN()
EndFunc   ;==>_DirRemove

Func _CGW()
	Local $all_key[3]
	$all_key[0] = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall"
	$all_key[1] = "HKEY_LOCAL_MACHINE64\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall"
	$all_key[2] = 'HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Uninstall'
	Local $aSA[1][2], $AppKey_all, $n = 0, $X = 1, $rn, $il
	For $i = 0 To 2
		Local $a = 1
		While 1
			$AppKey_all = RegEnumKey($all_key[$i], $a)
			If Not $AppKey_all Then ExitLoop
			$rn = StringStripWS(StringReplace(RegRead($all_key[$i] & "\" & $AppKey_all, "DisplayName"), " (remove only)", ""), 3)
			$il = StringStripWS(RegRead($all_key[$i] & "\" & $AppKey_all, "InstallLocation"), 3)
			If $rn <> '' And $il <> '' Then
				ReDim $aSA[$X][2]
				$aSA[$n][0] = $rn
				If StringRight($il, 1) = '\' Then $il = StringTrimRight($il, 1)
				$aSA[$n][1] = StringReplace($il, '"', '')
				$n += 1
				$X += 1
			EndIf
			$a += 1
		WEnd
	Next
	Return $aSA
EndFunc   ;==>_CGW



